/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.formula.functions.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.jxdinfo.idp.common.entity.externalserve.llm.LLMAnswers;
import com.jxdinfo.idp.common.entity.externalserve.llm.LLMQuestions;
import com.jxdinfo.idp.common.externalserve.LLMServe;
import com.jxdinfo.idp.rule.formula.annotation.RuleFunction;
import com.jxdinfo.idp.rule.formula.util.RuleFunctionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@RuleFunction(typeName="llm", functionName="llmRule", alisa="\u5927\u6a21\u578b\u5ba1\u67e5", isCommon=0, paramList={"text", "text", "text"}, describe="\u8bbe\u7f6e\u5927\u6a21\u578b\u5ba1\u67e5\u89c4\u5219\u4f20\u5165\u5f85\u5ba1\u67e5\u7684\u53c2\u6570\u8fdb\u884c\u5ba1\u67e5", usage="llmRule(str, str, str)", example="llmRule('\u68c0\u67e5\u4e2d\u6807\u901a\u77e5\u4e66\u7684\u4ef7\u683c\u4e0e\u5408\u540c\u7684\u4ef7\u683c\u662f\u5426\u4e00\u81f4\uff1b\u4ee5\u4e0b\u662f\u4e2d\u6807\u901a\u77e5\u4e66\u7684\u4ef7\u683c\uff1a{$1}\\n\u4ee5\u4e0b\u662f\u5408\u540c\u7684\u4ef7\u683c\u6587\u672c:{$2}\\n', '40\u4e07\u5143', '40\u4e07\u5143')\uff0c\u8fd4\u56detrue", returnType="boolean", order=501)
public class LLMFunction
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(LLMFunction.class);
    @Resource
    private LLMServe llmService;
    private static final List<Pattern> PARSE_PATTERN = new ArrayList<Pattern>();

    public String getName() {
        return "llmRule";
    }

    public AviatorObject call(Map<String, Object> env, AviatorObject p1, AviatorObject p2, AviatorObject p3) {
        Object p1Value = RuleFunctionUtils.getParamValue(env, p1);
        Object p2Value = RuleFunctionUtils.getParamValue(env, p2);
        Object p3Value = RuleFunctionUtils.getParamValue(env, p3);
        long startTime = System.nanoTime();
        log.info("llm\u5f00\u59cb\u5ba1\u67e5\uff1a{}", p1Value);
        String prompt = String.valueOf(p1Value);
        if (prompt.contains("{$1}")) {
            prompt = prompt.replaceAll("\\{\\$1\\}", String.valueOf(p2Value));
        }
        if (prompt.contains("{$2}")) {
            prompt = prompt.replaceAll("\\{\\$2\\}", String.valueOf(p3Value));
        }
        String prompts = "\u4f60\u662f\u4e00\u540d\u6587\u6863\u5408\u89c4\u5ba1\u67e5\u4eba\u5458\uff0c\u4f60\u7684\u4efb\u52a1\u662f" + prompt + "\\n\u8bf7\u8fdb\u884c\u5ba1\u67e5\uff0c\u5e76\u4e25\u683c\u6309\u7167JSON\u683c\u5f0f\u8f93\u51fa\u5ba1\u67e5\u7ed3\u8bba\uff1a{\"\u5ba1\u67e5\u7ed3\u8bba\u53ca\u5206\u6790\":\"###\",\"\u5ba1\u67e5\u662f\u5426\u901a\u8fc7\":\"\u662f/\u5426\"}\uff1b";
        LLMQuestions llmQuestions = new LLMQuestions(prompts);
        LLMAnswers answers = this.llmService.llmRecall(llmQuestions);
        String res = answers.extractResult();
        String targetstr = res.substring(res.indexOf("{"), res.indexOf("}") + 1);
        log.info("llm\u7ed3\u675f\u5ba1\u67e5\uff1a{}ms", (Object)((System.nanoTime() - startTime) / 1000000L));
        try {
            if (this.countBrace(res) > 1) {
                targetstr = res.substring(res.lastIndexOf("{"), res.lastIndexOf("}") + 1);
            }
            JSONObject jsonObject = JSON.parseObject((String)targetstr);
            String resultReason = String.valueOf(jsonObject.get((Object)"\u5ba1\u67e5\u7ed3\u8bba\u53ca\u5206\u6790"));
            String result = String.valueOf(jsonObject.get((Object)"\u5ba1\u67e5\u662f\u5426\u901a\u8fc7"));
            env.put("idp_rule_check_result_reason", resultReason);
            log.info("llm\u5ba1\u67e5\u7ed3\u675f\uff1a{}", (Object)res);
            return AviatorRuntimeJavaType.valueOf((Object)result.contains("\u662f"));
        }
        catch (Exception e) {
            log.info("llm\u672a\u6309\u7167\u6307\u5b9a\u683c\u5f0f\u8fd4\u56de\u5ba1\u67e5\u7ed3\u679c:{}", (Object)e.getMessage());
            log.info("llm\u5206\u6790\u7ed3\u679c\uff1a{}", (Object)answers.extractResult());
            return AviatorRuntimeJavaType.valueOf((Object)false);
        }
    }

    private int countBrace(String input) {
        int count = 0;
        int index = input.indexOf(123);
        while (index != -1) {
            ++count;
            index = input.indexOf(44, index + 1);
        }
        return count;
    }

    static {
        PARSE_PATTERN.add(Pattern.compile("```json(.*)```", 32));
        PARSE_PATTERN.add(Pattern.compile("(\\{.*\\})", 32));
    }
}

