/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.formula.functions.llm;

import com.alibaba.fastjson.JSONObject;
import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.jxdinfo.idp.common.util.http.RequestHTTPUtil;
import com.jxdinfo.idp.rule.formula.annotation.RuleFunction;
import com.jxdinfo.idp.rule.formula.enums.LLMPromptEnum;
import com.jxdinfo.idp.rule.formula.exception.RuleExecuteExption;
import com.jxdinfo.idp.rule.formula.util.PromptUtils;
import com.jxdinfo.idp.rule.formula.util.RuleFunctionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;

@RuleFunction(typeName="llm", functionName="llmRule", alisa="\u8c03\u7528\u5927\u6a21\u578b\u8fdb\u884c\u6587\u672c\u5ba1\u67e5", isCommon=0, paramList={"text*"}, describe="\u5927\u6a21\u578b\u63d0\u793a\u8bcd\u7c7b\u578b\uff0c\u9700\u8981\u5ba1\u67e5\u7684\u6587\u672c", usage="llm(text,text)", example="llm(WORK_INFO_CONTENT_EQUALS,\u5f85\u5ba1\u67e5\u6587\u672c)\uff0c\u8fd4\u56de\u503ctrue or false", returnType="boolean", order=999)
public class LLMFunction
extends AbstractVariadicFunction {
    private static final String NAME = "llmRule";
    private static final String PROMPT = "content";
    private static final String UID = "uid";
    private static final String STREAM = "stream";
    private static final boolean STREAM_FLAG = false;
    private static final String TEMPERATURE = "temperature";
    @Value(value="${idp.llm.url:''}")
    private String LLM_URL;

    public AviatorObject variadicCall(Map<String, Object> map, AviatorObject ... aviatorObjects) throws RuleExecuteExption {
        List<String> params = this.aviatorObjectGetParams(map, aviatorObjects);
        LLMPromptEnum llmPromptEnum = this.getPromptType(params);
        String prompt = this.generatePrompt(llmPromptEnum, params);
        if (ObjectUtils.isEmpty((Object)prompt)) {
            throw new RuleExecuteExption("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570");
        }
        if (ObjectUtils.isEmpty((Object)((Object)llmPromptEnum))) {
            return AviatorRuntimeJavaType.valueOf((Object)(((String)RequestHTTPUtil.requestPost((String)this.LLM_URL, (Object)this.initRequestBody(prompt), String.class)).indexOf("true") > 0 ? 1 : 0));
        }
        return AviatorRuntimeJavaType.valueOf((Object)llmPromptEnum.parseResult((String)RequestHTTPUtil.requestPost((String)this.LLM_URL, (Object)this.initRequestBody(prompt), String.class)));
    }

    private JSONObject initRequestBody(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(PROMPT, (Object)prompt);
        jsonObject.put(UID, (Object)String.valueOf(System.currentTimeMillis()));
        jsonObject.put(STREAM, (Object)false);
        jsonObject.put(TEMPERATURE, (Object)0);
        return jsonObject;
    }

    private LLMPromptEnum getPromptType(List<String> params) {
        if (!ObjectUtils.isEmpty(params)) {
            try {
                return LLMPromptEnum.valueOf(params.get(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String generatePrompt(LLMPromptEnum llmPromptEnum, List<String> params) {
        if (!ObjectUtils.isEmpty(params)) {
            if (!ObjectUtils.isEmpty((Object)((Object)llmPromptEnum))) {
                params.remove(0);
                return PromptUtils.replaceParam(llmPromptEnum.getPrompt(), params);
            }
            String prompt = params.get(0);
            params.remove(0);
            return PromptUtils.replaceParam(prompt, params);
        }
        return null;
    }

    private List<String> aviatorObjectGetParams(Map<String, Object> map, AviatorObject ... aviatorObjects) {
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < aviatorObjects.length; ++i) {
            String param = String.valueOf(RuleFunctionUtils.getParamValue(map, aviatorObjects[i]));
            if ("null".equals(param)) {
                params.add("");
                continue;
            }
            params.add(param);
        }
        return params;
    }

    public String getName() {
        return NAME;
    }
}

