/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.formula.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.googlecode.aviator.Expression;
import com.jxdinfo.idp.rule.api.vo.FormulaExecuteVo;
import com.jxdinfo.idp.rule.formula.RuleEvaluatorInstance;
import com.jxdinfo.idp.rule.formula.exception.RuleExecuteExption;
import com.jxdinfo.idp.rule.formula.exception.RuleExecuteParamException;
import com.jxdinfo.idp.rule.formula.service.IRuleFormula;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RuleFormulaService
implements IRuleFormula {
    private static final Logger log = LoggerFactory.getLogger(RuleFormulaService.class);

    @Override
    public Object executeFormula(FormulaExecuteVo formulaExecuteVo) {
        try {
            Expression compiledExp = RuleEvaluatorInstance.compile(formulaExecuteVo.getExpression());
            if (CollectionUtils.isNotEmpty((Map)formulaExecuteVo.getExtractedData())) {
                return compiledExp.execute(formulaExecuteVo.getExtractedData());
            }
            return compiledExp.execute();
        }
        catch (RuleExecuteParamException pe) {
            log.error("\u516c\u5f0f\u5165\u53c2\u9519\u8bef\uff0c\u3010{}\u3011", (Object)pe.getMessage());
            throw new RuleExecuteExption("\u89c4\u5219\u6267\u884c\u5f02\u5e38\uff0c\u975e\u6cd5\u5165\u53c2");
        }
        catch (Exception re) {
            throw new RuleExecuteExption(formulaExecuteVo.getExpression() + "\uff0c\u89c4\u5219\u6267\u884c\u5f02\u5e38\uff1a" + re.getMessage());
        }
    }

    @Override
    public Object execute(String expression) {
        try {
            if (StringUtils.isBlank((CharSequence)expression)) {
                throw new RuleExecuteExption("\u5f85\u8ba1\u7b97\u7684\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Expression compiledExp = RuleEvaluatorInstance.compile(expression);
            return compiledExp.execute();
        }
        catch (RuleExecuteParamException pe) {
            log.error("\u516c\u5f0f\u5165\u53c2\u9519\u8bef\uff0c\u3010{}\u3011", (Object)pe.getMessage());
            throw new RuleExecuteExption("\u89c4\u5219\u6267\u884c\u5f02\u5e38\uff0c\u975e\u6cd5\u5165\u53c2");
        }
        catch (Exception re) {
            throw new RuleExecuteExption(expression + "\uff0c\u89c4\u5219\u6267\u884c\u5f02\u5e38\uff1a" + re.getMessage());
        }
    }
}

