/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.formula.util;

import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import com.jxdinfo.idp.common.exception.BusinessException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;

public class SimHashUtil {
    private String topicName;
    private final BigInteger bigSimHash;
    private Integer hashCount = 64;
    private static final Integer WORD_MIN_LENGTH = 3;
    private static final BigInteger ILLEGAL_X = BigInteger.valueOf(-1L);

    public SimHashUtil(String topicName, Integer hashCount) {
        this.topicName = topicName;
        this.bigSimHash = this.simHash();
        this.hashCount = hashCount;
    }

    private BigInteger simHash() {
        this.topicName = this.clearSpecialCharacters(this.topicName);
        int[] hashArray = new int[this.hashCount.intValue()];
        List terms = StandardTokenizer.segment((String)this.topicName);
        HashMap<String, Integer> weightMap = new HashMap<String, Integer>(16, 0.75f);
        weightMap.put("n", 1);
        HashMap<String, String> stopMap = new HashMap<String, String>(16, 0.75f);
        stopMap.put("w", "");
        Integer overCount = 5;
        HashMap<String, Integer> wordMap = new HashMap<String, Integer>(16, 0.75f);
        for (Term term : terms) {
            String word = term.word;
            String nature = term.nature.toString();
            if (wordMap.containsKey(word)) {
                Integer count = (Integer)wordMap.get(word);
                if (count > overCount) continue;
                wordMap.put(word, count + 1);
            } else {
                wordMap.put(word, 1);
            }
            if (stopMap.containsKey(nature)) continue;
            BigInteger wordHash = this.getWordHash(word);
            for (int i = 0; i < this.hashCount; ++i) {
                BigInteger bitMask = BigInteger.valueOf(1L).shiftLeft(i);
                Integer weight = 1;
                if (weightMap.containsKey(nature)) {
                    weight = (Integer)weightMap.get(nature);
                }
                if (wordHash.and(bitMask).signum() != 0) {
                    int n = i;
                    hashArray[n] = hashArray[n] + weight;
                    continue;
                }
                int n = i;
                hashArray[n] = hashArray[n] - weight;
            }
        }
        BigInteger fingerPrint = BigInteger.valueOf(0L);
        for (int i = 0; i < this.hashCount; ++i) {
            if (hashArray[i] < 0) continue;
            fingerPrint = fingerPrint.add(BigInteger.valueOf(1L).shiftLeft(i));
        }
        return fingerPrint;
    }

    private BigInteger getWordHash(String word) {
        if (StringUtils.isEmpty((CharSequence)word)) {
            return BigInteger.valueOf(0L);
        }
        StringBuilder wordBuilder = new StringBuilder(word);
        while (wordBuilder.length() < WORD_MIN_LENGTH) {
            wordBuilder.append(wordBuilder.charAt(0));
        }
        word = wordBuilder.toString();
        char[] wordArray = word.toCharArray();
        BigInteger x = BigInteger.valueOf(wordArray[0] << 7);
        BigInteger m = BigInteger.valueOf(1000003L);
        BigInteger mask = BigInteger.valueOf(2L).pow(this.hashCount).subtract(BigInteger.valueOf(1L));
        for (char item : wordArray) {
            BigInteger temp = BigInteger.valueOf(item);
            x = x.multiply(m).xor(temp).and(mask);
        }
        if ((x = x.xor(new BigInteger(String.valueOf(word.length())))).equals(ILLEGAL_X)) {
            x = BigInteger.valueOf(-2L);
        }
        return x;
    }

    private String clearSpecialCharacters(String topicName) {
        String[] strings;
        topicName = StringUtils.lowerCase((String)topicName);
        topicName = Jsoup.parse((String)topicName.replace("&nbsp;", "")).body().text();
        for (String string : strings = new String[]{" ", "\n", "\r", "\t", "\\r", "\\n", "\\t", "&nbsp;", "&amp;", "&lt;", "&gt;", "&quot;", "&qpos;"}) {
            topicName = topicName.replaceAll(string, "");
        }
        return topicName;
    }

    private Double getSimilar(SimHashUtil simHashUtil) {
        Double hammingDistance = this.getHammingDistance(simHashUtil);
        Double scale = 1.0 - hammingDistance / (double)this.hashCount.intValue();
        return Double.parseDouble(String.format("%.4f", scale));
    }

    private int getHammingDistance(SimHashUtil simHashUtil) {
        BigInteger subtract = BigInteger.valueOf(1L).shiftLeft(this.hashCount).subtract(BigInteger.valueOf(1L));
        BigInteger xor = this.bigSimHash.xor(simHashUtil.bigSimHash).and(subtract);
        int total = 0;
        while (xor.signum() != 0) {
            ++total;
            xor = xor.and(xor.subtract(BigInteger.valueOf(1L)));
        }
        return total;
    }

    public static Double getSimhashSimlar(String sentence1, String sentence2) {
        try {
            SimHashUtil mySimHash1 = new SimHashUtil(sentence1, 64);
            SimHashUtil mySimHash2 = new SimHashUtil(sentence2, 64);
            return mySimHash1.getSimilar(mySimHash2);
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u76f8\u4f3c\u5ea6\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

