/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.formula.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.jxdinfo.idp.rule.formula.RuleEvaluatorInstance;
import com.jxdinfo.idp.rule.formula.exception.RuleExecuteParamException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RuleFunctionUtils {
    private static final Expression EQ = RuleEvaluatorInstance.compile("p1 == p2");
    private static final Expression GT = RuleEvaluatorInstance.compile("p1 > p2");
    private static final Expression LT = RuleEvaluatorInstance.compile("p1 < p2");
    private static final Expression BETWEEN = RuleEvaluatorInstance.compile("p1 >= p2 && p1 <= p3");
    private static final String COMPARE_TIP1 = "\u975e\u6cd5\u5165\u53c2\uff0c\u4ec5\u652f\u6301\u540c\u7c7b\u578b\u7684\u65e5\u671f\u6216\u8005\u6570\u503c\u8fdb\u884c\u6bd4\u8f83";

    private RuleFunctionUtils() {
    }

    public static boolean eq(Map<String, Object> env, AviatorObject p1, AviatorObject p2) {
        Object obj1 = RuleFunctionUtils.getParamValue(env, p1);
        Object obj2 = RuleFunctionUtils.getParamValue(env, p2);
        return RuleFunctionUtils.eq(obj1, obj2);
    }

    public static boolean eq(Object obj1, Object obj2) {
        return (Boolean)EQ.execute(EQ.newEnv(new Object[]{"p1", obj1, "p2", obj2}));
    }

    public static Object getParamValue(Map<String, Object> env, AviatorObject p1) {
        Object obj = null;
        if (Objects.equals(String.valueOf(p1.getAviatorType()), "JavaType")) {
            obj = FunctionUtils.getJavaObject((AviatorObject)p1, env);
        } else if (p1 instanceof AviatorString) {
            obj = FunctionUtils.getStringValue((AviatorObject)p1, env);
        } else if (p1 instanceof AviatorNumber) {
            obj = FunctionUtils.getNumberValue((AviatorObject)p1, env);
        }
        return obj;
    }

    public static boolean gt(Object obj1, Object obj2) {
        return (Boolean)GT.execute(GT.newEnv(new Object[]{"p1", obj1, "p2", obj2}));
    }

    public static boolean lt(Object obj1, Object obj2) {
        return (Boolean)LT.execute(LT.newEnv(new Object[]{"p1", obj1, "p2", obj2}));
    }

    public static boolean between(Map<String, Object> env, AviatorObject p1, AviatorObject p2, AviatorObject p3) {
        Object obj1 = RuleFunctionUtils.getParamValue(env, p1);
        Object obj2 = RuleFunctionUtils.getParamValue(env, p2);
        Object obj3 = RuleFunctionUtils.getParamValue(env, p3);
        if (obj1 == null || obj2 == null || obj3 == null) {
            return false;
        }
        if (obj1 instanceof Number && (!(obj2 instanceof Number) || !(obj3 instanceof Number)) || obj1 instanceof Date || obj1 instanceof LocalDate || obj1 instanceof LocalDateTime && (!(obj2 instanceof Date) && !(obj2 instanceof LocalDate) && !(obj2 instanceof LocalDateTime) || !(obj3 instanceof Date) && !(obj3 instanceof LocalDate) && !(obj3 instanceof LocalDateTime))) {
            throw new RuleExecuteParamException(COMPARE_TIP1);
        }
        return (Boolean)BETWEEN.execute(BETWEEN.newEnv(new Object[]{"p1", obj1, "p2", obj2, "p3", obj3}));
    }

    public static LocalDate dateParse(Map<String, Object> env, AviatorObject p1) {
        Object p = RuleFunctionUtils.getParamValue(env, p1);
        if (p == null) {
            return null;
        }
        if (p instanceof LocalDateTime) {
            return ((LocalDateTime)p).toLocalDate();
        }
        if (p instanceof LocalDate) {
            return (LocalDate)p;
        }
        if (p instanceof Date) {
            Instant instant = ((Date)p).toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            return instant.atZone(zoneId).toLocalDate();
        }
        if (p instanceof String) {
            if (StringUtils.isEmpty((CharSequence)String.valueOf(p))) {
                throw new RuleExecuteParamException("\u516c\u5f0f\u5165\u53c2\u5f02\u5e38\uff0c\u9700\u8981\u7684\u662f\u65e5\u671f\u683c\u5f0f\u6570\u636e\uff0c\u4f20\u5165\u7684\u662f\u7a7a\u5b57\u7b26\u4e32");
            }
            String dateStr = String.valueOf(p).replace(" ", "");
            try {
                DateTime t = DateUtil.parse((String)dateStr);
                Instant instant = t.toInstant();
                ZoneId zoneId = ZoneId.systemDefault();
                return instant.atZone(zoneId).toLocalDate();
            }
            catch (Exception e) {
                throw new RuleExecuteParamException("\u516c\u5f0f\u5165\u53c2\u5f02\u5e38\uff0c\u9700\u8981\u7684\u662f\u65e5\u671f\u683c\u5f0f\u6570\u636e\uff0c\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u8f6c\u6362\u4e3a\u65e5\u671f\u683c\u5f0f");
            }
        }
        throw new RuleExecuteParamException("\u975e\u6cd5\u5165\u53c2\uff0c\u671f\u671b\u5165\u53c2\u4e3a\u65e5\u671f\u7c7b\u578b\u6570\u636e\u6216\u8005\u65e5\u671f\u683c\u5f0f\u5b57\u7b26\u4e32");
    }
}

