/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.formula;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.FunctionMissing;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.jxdinfo.idp.rule.formula.entity.RuleFormula;
import com.jxdinfo.idp.rule.formula.functions.RuleFunctionMiss;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public final class RuleEvaluatorInstance {
    private static final Map<String, List<RuleFormula>> FUNCTIONS = new HashMap<String, List<RuleFormula>>();
    private static final AviatorEvaluatorInstance INSTANCE;

    private RuleEvaluatorInstance() {
    }

    public static Expression compile(String expression) {
        return INSTANCE.compile(expression);
    }

    public static void addFunctions(String typeName, RuleFormula ruleFormula, AviatorFunction function) {
        if (ObjectUtils.isNotEmpty((Object)typeName)) {
            List formulas = FUNCTIONS.computeIfAbsent(typeName, k -> new ArrayList());
            formulas.add(ruleFormula);
        }
        INSTANCE.addFunction(function);
    }

    public static Map<String, List<RuleFormula>> getFunctions() {
        return FUNCTIONS;
    }

    public static void functionSort() {
        for (Map.Entry<String, List<RuleFormula>> formula : FUNCTIONS.entrySet()) {
            formula.getValue().sort(Comparator.comparingInt(RuleFormula::getOrder));
        }
    }

    private static void removeDefaultFunction() {
        INSTANCE.removeFunction("%");
        INSTANCE.removeFunction("!");
        INSTANCE.removeFunction("&");
        INSTANCE.removeFunction("*");
        INSTANCE.removeFunction("+");
        INSTANCE.removeFunction("/");
        INSTANCE.removeFunction("**");
        INSTANCE.removeFunction("-neg");
        INSTANCE.removeFunction("-sub");
        INSTANCE.removeFunction("^");
        INSTANCE.removeFunction("__catch_handler");
        INSTANCE.removeFunction("__if_callcc");
        INSTANCE.removeFunction("__new");
        INSTANCE.removeFunction("__reducer_break");
        INSTANCE.removeFunction("__reducer_callcc");
        INSTANCE.removeFunction("__reducer_cont");
        INSTANCE.removeFunction("__reducer_return");
        INSTANCE.removeFunction("__throw");
        INSTANCE.removeFunction("__try");
        INSTANCE.removeFunction("__use");
        INSTANCE.removeFunction("assert");
        INSTANCE.removeFunction("bigint");
        INSTANCE.removeFunction("boolean");
        INSTANCE.removeFunction("cmp");
        INSTANCE.removeFunction("comparator");
        INSTANCE.removeFunction("concat");
        INSTANCE.removeFunction("constantly");
        INSTANCE.removeFunction("count");
        INSTANCE.removeFunction("date_to_string");
        INSTANCE.removeFunction("decimal");
        INSTANCE.removeFunction("distinct");
        INSTANCE.removeFunction("double");
        INSTANCE.removeFunction("drop_while");
        INSTANCE.removeFunction("eval");
        INSTANCE.removeFunction("filter");
        INSTANCE.removeFunction("group_by");
        INSTANCE.removeFunction("math.asin");
        INSTANCE.removeFunction("type");
        INSTANCE.removeFunction("seq.raw");
        INSTANCE.removeFunction("rand");
        INSTANCE.removeFunction("is_distinct");
        INSTANCE.removeFunction("seq.put");
        INSTANCE.removeFunction("seq.nil");
        INSTANCE.removeFunction("reduce");
        INSTANCE.removeFunction("printStackTrace");
        INSTANCE.removeFunction("string.indexOf");
        INSTANCE.removeFunction("require");
        INSTANCE.removeFunction("string.substring");
        INSTANCE.removeFunction("math.sin");
        INSTANCE.removeFunction("seq.exists");
        INSTANCE.removeFunction("seq.vals");
        INSTANCE.removeFunction("str");
        INSTANCE.removeFunction("math.atan");
        INSTANCE.removeFunction("seq.true");
        INSTANCE.removeFunction("string.replace_all");
        INSTANCE.removeFunction("meta");
        INSTANCE.removeFunction("partial");
        INSTANCE.removeFunction("seq.max");
        INSTANCE.removeFunction("seq.list");
        INSTANCE.removeFunction("seq.set");
        INSTANCE.removeFunction("range");
        INSTANCE.removeFunction("seq.array");
        INSTANCE.removeFunction("long");
        INSTANCE.removeFunction("tuple");
        INSTANCE.removeFunction("into");
        INSTANCE.removeFunction("string.endsWith");
        INSTANCE.removeFunction("math.abs");
        INSTANCE.removeFunction("min");
        INSTANCE.removeFunction("seq.get");
        INSTANCE.removeFunction("seq.entry");
        INSTANCE.removeFunction("identity");
        INSTANCE.removeFunction("seq.min");
        INSTANCE.removeFunction("seq.map");
        INSTANCE.removeFunction("math.acos");
        INSTANCE.removeFunction("map");
        INSTANCE.removeFunction("seq");
        INSTANCE.removeFunction("is_empty");
        INSTANCE.removeFunction("include");
        INSTANCE.removeFunction("string.split");
        INSTANCE.removeFunction("max");
        INSTANCE.removeFunction("math.tan");
        INSTANCE.removeFunction("undef");
        INSTANCE.removeFunction("seq.le");
        INSTANCE.removeFunction("reverse");
        INSTANCE.removeFunction("p");
        INSTANCE.removeFunction("string_to_date");
        INSTANCE.removeFunction("seq.lt");
        INSTANCE.removeFunction("take_while");
        INSTANCE.removeFunction("|");
        INSTANCE.removeFunction("~");
        INSTANCE.removeFunction("math.cos");
        INSTANCE.removeFunction("math.log");
        INSTANCE.removeFunction("seq.array_of");
        INSTANCE.removeFunction("seq.contains_key");
        INSTANCE.removeFunction("seq.add");
        INSTANCE.removeFunction("string.startsWith");
        INSTANCE.removeFunction("sysdate");
        INSTANCE.removeFunction("math.round");
        INSTANCE.removeFunction("math.log10");
        INSTANCE.removeFunction("seq.add_all");
        INSTANCE.removeFunction("seq.eq");
        INSTANCE.removeFunction("seq.neq");
        INSTANCE.removeFunction("repeatedly");
        INSTANCE.removeFunction("string.join");
        INSTANCE.removeFunction("seq.keys");
        INSTANCE.removeFunction("seq.false");
        INSTANCE.removeFunction("sort");
        INSTANCE.removeFunction("math.pow");
        INSTANCE.removeFunction("without_meta");
        INSTANCE.removeFunction("seq.some");
        INSTANCE.removeFunction("zipmap");
        INSTANCE.removeFunction("math.floor");
        INSTANCE.removeFunction("seq.every");
        INSTANCE.removeFunction("seq.not_any");
        INSTANCE.removeFunction("math.sqrt");
        INSTANCE.removeFunction("is_a");
        INSTANCE.removeFunction("with_meta");
        INSTANCE.removeFunction("string.contains");
        INSTANCE.removeFunction("seq.ge");
        INSTANCE.removeFunction("pst");
        INSTANCE.removeFunction("println");
        INSTANCE.removeFunction("seq.or");
        INSTANCE.removeFunction("load");
        INSTANCE.removeFunction("now");
        INSTANCE.removeFunction("repeat");
        INSTANCE.removeFunction("string.length");
        INSTANCE.removeFunction("seq.gt");
        INSTANCE.removeFunction("seq.and");
        INSTANCE.removeFunction("string.replace_first");
        INSTANCE.removeFunction("math.ceil");
        INSTANCE.removeFunction("is_def");
        INSTANCE.removeFunction("seq.collector");
        INSTANCE.removeFunction("print");
        INSTANCE.removeFunction("seq.remove");
    }

    static {
        FUNCTIONS.put("text", new ArrayList());
        FUNCTIONS.put("date", new ArrayList());
        FUNCTIONS.put("seal", new ArrayList());
        FUNCTIONS.put("sign", new ArrayList());
        FUNCTIONS.put("number", new ArrayList());
        INSTANCE = AviatorEvaluator.newInstance();
        INSTANCE.setOption(Options.OPTIMIZE_LEVEL, (Object)0);
        INSTANCE.setFunctionMissing((FunctionMissing)new RuleFunctionMiss());
        RuleEvaluatorInstance.removeDefaultFunction();
    }
}

