/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.model.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import com.jxdinfo.idp.model.base.po.Attribute;
import com.jxdinfo.idp.model.base.po.Category;
import com.jxdinfo.idp.model.base.query.CategoryQuery;
import com.jxdinfo.idp.model.mapper.CategoryMapper;
import com.jxdinfo.idp.model.service.ICategoryService;
import com.jxdinfo.idp.model.service.IIDPAttributeService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ICategoryServiceImpl
extends ServiceImpl<CategoryMapper, Category>
implements ICategoryService {
    @Autowired
    private IIDPAttributeService attributeService;
    @Autowired
    private CategoryMapper mapper;

    @PostConstruct
    private void init() {
        this.delDefault();
    }

    @Override
    public List<CategoryDto> getDtoList(CategoryQuery query) {
        return this.mapper.getDtoList(query);
    }

    @Override
    public CategoryDto getDto(Long id) {
        Category category = (Category)this.getById(id);
        CategoryDto categoryDto = new CategoryDto();
        BeanUtils.copyProperties((Object)category, (Object)categoryDto);
        List<Attribute> attributes = this.attributeService.getListByCategoryId(id);
        categoryDto.setAttributeList(attributes);
        return categoryDto;
    }

    @Override
    public Long add(CategoryDto categoryDto) {
        categoryDto.setId(categoryDto.getId() == null ? SnowFlakeUtil.getFlowIdInstance().nextId() : categoryDto.getId().longValue());
        categoryDto.setCreateTime(LocalDateTime.now());
        this.save(categoryDto);
        List<Attribute> attributeList = categoryDto.getAttributeList();
        if (CollUtil.isNotEmpty(attributeList)) {
            attributeList.forEach(attribute -> attribute.setCategoryId(categoryDto.getId()));
            this.attributeService.saveBatch(attributeList);
        }
        return categoryDto.getId();
    }

    @Override
    public void delDefault() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Category::getType, (Object)"0");
        List list = this.list((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<Long> ids = list.stream().map(Category::getId).collect(Collectors.toList());
            this.del(ids);
        }
    }

    @Override
    public void del(List<Long> ids) {
        this.removeByIds(ids);
        this.attributeService.delByCategoryId(ids);
    }
}

