/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.model.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import com.jxdinfo.idp.model.base.dto.CategoryGroupDto;
import com.jxdinfo.idp.model.base.po.Attribute;
import com.jxdinfo.idp.model.base.po.Category;
import com.jxdinfo.idp.model.base.po.CategoryGroup;
import com.jxdinfo.idp.model.base.query.CategoryGroupQuery;
import com.jxdinfo.idp.model.base.query.CategoryQuery;
import com.jxdinfo.idp.model.enums.CategoryGroupEnum;
import com.jxdinfo.idp.model.enums.CategoryTypeEnum;
import com.jxdinfo.idp.model.service.IAttributeService;
import com.jxdinfo.idp.model.service.ICategoryGroupService;
import com.jxdinfo.idp.model.service.ICategoryService;
import com.jxdinfo.idp.model.service.IDataModelService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataModelServiceImpl
implements IDataModelService {
    @Autowired
    private ICategoryGroupService categoryGroupService;
    @Autowired
    private ICategoryService categoryService;
    @Autowired
    private IAttributeService attributeService;

    @Override
    public List<CategoryGroupDto> groupList(CategoryGroupQuery query) {
        return this.categoryGroupService.getDtoList(query);
    }

    @Override
    public List<CategoryGroup> groups() {
        return this.categoryGroupService.list();
    }

    @Override
    public List<CategoryDto> getDtoList(CategoryQuery query) {
        return this.categoryService.getDtoList(query);
    }

    @Override
    public List<Category> commonList(CategoryQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Category::getType, (Object)"1");
        wrapper.like(StringUtils.isNotEmpty((CharSequence)query.getName()), Category::getName, (Object)query.getName());
        return this.categoryService.list((Wrapper)wrapper);
    }

    @Override
    public Long addGroup(CategoryGroup categoryGroup) {
        categoryGroup.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        categoryGroup.setCreateTime(LocalDateTime.now());
        this.categoryGroupService.save(categoryGroup);
        return categoryGroup.getId();
    }

    @Override
    public void editGroup(CategoryGroup categoryGroup) {
        this.categoryGroupService.updateById(categoryGroup);
    }

    @Override
    public void delGroups(List<Long> ids) {
        this.categoryGroupService.removeByIds(ids);
    }

    @Override
    public Long add(CategoryDto categoryDto) {
        return this.categoryService.add(categoryDto);
    }

    @Override
    public void edit(CategoryDto categoryDto) {
        this.categoryService.updateById(categoryDto);
        List<Attribute> attributeList = categoryDto.getAttributeList();
        this.attributeService.delByCategoryId(categoryDto.getId());
        if (CollUtil.isNotEmpty(attributeList)) {
            attributeList.forEach(attribute -> attribute.setCategoryId(categoryDto.getId()));
            this.attributeService.saveBatch(attributeList);
        }
    }

    @Override
    public void del(List<Long> ids) {
        this.categoryService.del(ids);
    }

    @Override
    public CategoryDto getDetail(Long id) {
        return this.categoryService.getDto(id);
    }

    @Override
    public List<Map<String, String>> getGroups() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (CategoryGroupEnum value : CategoryGroupEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", value.getName());
            map.put("code", value.getCode());
            result.add(map);
        }
        return result;
    }

    @Override
    public List<Map<String, String>> getTypes() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (CategoryTypeEnum value : CategoryTypeEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", value.getName());
            map.put("code", value.getCode());
            result.add(map);
        }
        return result;
    }
}

