/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.model.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import com.jxdinfo.idp.model.base.dto.CategoryGroupDto;
import com.jxdinfo.idp.model.base.po.Category;
import com.jxdinfo.idp.model.base.po.CategoryGroup;
import com.jxdinfo.idp.model.base.query.CategoryGroupQuery;
import com.jxdinfo.idp.model.base.query.CategoryQuery;
import com.jxdinfo.idp.model.service.IDataModelService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/modelManage"})
public class DataModelController {
    @Autowired
    private IDataModelService service;

    @PostMapping(value={"/getGroupList"})
    ApiResponse<List<CategoryGroupDto>> getGroupList(@RequestBody CategoryGroupQuery query) {
        return ApiResponse.success(this.service.groupList(query));
    }

    @GetMapping(value={"/groups"})
    ApiResponse<List<CategoryGroup>> groups() {
        return ApiResponse.success(this.service.groups());
    }

    @PostMapping(value={"/addGroup"})
    ApiResponse<Long> addGroup(@RequestBody CategoryGroup categoryGroup) {
        return ApiResponse.success((Object)this.service.addGroup(categoryGroup));
    }

    @PostMapping(value={"/editGroup"})
    ApiResponse<Void> editGroup(@RequestBody CategoryGroup categoryGroup) {
        this.service.editGroup(categoryGroup);
        return ApiResponse.success();
    }

    @PostMapping(value={"/delGroups"})
    ApiResponse<Void> delGroups(@RequestBody List<Long> ids) {
        this.service.delGroups(ids);
        return ApiResponse.success();
    }

    @PostMapping(value={"/getDtoList"})
    public ApiResponse<List<CategoryDto>> getDtoList(@RequestBody CategoryQuery query) {
        return ApiResponse.success(this.service.getDtoList(query));
    }

    @PostMapping(value={"/commonList"})
    public ApiResponse<List<Category>> commonList(@RequestBody CategoryQuery query) {
        return ApiResponse.success(this.service.commonList(query));
    }

    @PostMapping(value={"/add"})
    ApiResponse<Long> add(@RequestBody CategoryDto categoryDto) {
        return ApiResponse.success((Object)this.service.add(categoryDto));
    }

    @PostMapping(value={"/edit"})
    ApiResponse<Void> edit(@RequestBody CategoryDto categoryDto) {
        this.service.edit(categoryDto);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getDetail"})
    ApiResponse<CategoryDto> getDetail(@RequestParam(value="id") Long id) {
        return ApiResponse.success((Object)this.service.getDetail(id));
    }

    @PostMapping(value={"/del"})
    ApiResponse<Void> del(@RequestBody List<Long> ids) {
        this.service.del(ids);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getGroups"})
    ApiResponse<List<Map<String, String>>> getGroups() {
        return ApiResponse.success(this.service.getGroups());
    }

    @GetMapping(value={"/getTypes"})
    ApiResponse<List<Map<String, String>>> getTypes() {
        return ApiResponse.success(this.service.getTypes());
    }
}

