/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.spi.spring;

import com.jxdinfo.hutool.core.annotation.AnnotationUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.annotation.LiteflowCmpDefine;
import com.jxdinfo.liteflow.annotation.LiteflowComponent;
import com.jxdinfo.liteflow.annotation.LiteflowFact;
import com.jxdinfo.liteflow.annotation.LiteflowMethod;
import com.jxdinfo.liteflow.annotation.LiteflowRetry;
import com.jxdinfo.liteflow.annotation.util.AnnoUtil;
import com.jxdinfo.liteflow.core.proxy.DeclWarpBean;
import com.jxdinfo.liteflow.core.proxy.MethodWrapBean;
import com.jxdinfo.liteflow.core.proxy.ParameterWrapBean;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.exception.CmpDefinitionException;
import com.jxdinfo.liteflow.spi.DeclComponentParser;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.stereotype.Component;

public class SpringDeclComponentParser
implements DeclComponentParser {
    public List<DeclWarpBean> parseDeclBean(Class<?> clazz) {
        return this.parseDeclBean(clazz, null, null);
    }

    public List<DeclWarpBean> parseDeclBean(Class<?> clazz, String nodeId, String nodeName) {
        Map<String, List<DeclInfo>> definitionMap = Arrays.stream(clazz.getMethods()).filter(method -> AnnotationUtil.getAnnotation((AnnotatedElement)method, LiteflowMethod.class) != null).map(method -> {
            LiteflowMethod liteflowMethod = (LiteflowMethod)AnnotationUtil.getAnnotation((AnnotatedElement)method, LiteflowMethod.class);
            LiteflowRetry liteflowRetry = (LiteflowRetry)AnnotationUtil.getAnnotation((AnnotatedElement)method, LiteflowRetry.class);
            String currNodeId = null;
            String currNodeName = null;
            if (nodeId == null) {
                if (StrUtil.isBlank((CharSequence)liteflowMethod.nodeId())) {
                    LiteflowComponent liteflowComponent = (LiteflowComponent)AnnoUtil.getAnnotation((AnnotatedElement)clazz, LiteflowComponent.class);
                    Component component = (Component)AnnoUtil.getAnnotation((AnnotatedElement)clazz, Component.class);
                    if (liteflowComponent != null) {
                        currNodeId = liteflowComponent.value();
                        currNodeName = liteflowComponent.name();
                    } else if (component != null) {
                        currNodeId = component.value();
                    } else {
                        currNodeName = "";
                        currNodeId = "";
                    }
                } else {
                    currNodeId = liteflowMethod.nodeId();
                    currNodeName = liteflowMethod.nodeName();
                }
            } else {
                currNodeId = nodeId;
                currNodeName = nodeName;
            }
            LiteflowCmpDefine liteflowCmpDefine = (LiteflowCmpDefine)AnnotationUtil.getAnnotation(method.getDeclaringClass(), LiteflowCmpDefine.class);
            NodeTypeEnum nodeType = liteflowCmpDefine != null ? liteflowCmpDefine.value() : liteflowMethod.nodeType();
            Parameter[] parameters = method.getParameters();
            List parameterList = IntStream.range(0, parameters.length).boxed().map(index -> {
                Parameter parameter = parameters[index];
                return new ParameterWrapBean(parameter.getType(), (LiteflowFact)AnnotationUtil.getAnnotation((AnnotatedElement)parameter, LiteflowFact.class), index.intValue());
            }).collect(Collectors.toList());
            return new DeclInfo(currNodeId, currNodeName, nodeType, method.getDeclaringClass(), new MethodWrapBean(method, liteflowMethod, liteflowRetry, parameterList));
        }).filter(declInfo -> StrUtil.isNotBlank((CharSequence)declInfo.getNodeId())).collect(Collectors.groupingBy(DeclInfo::getNodeId));
        return definitionMap.entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            List declInfos = (List)entry.getValue();
            DeclWarpBean declWarpBean = new DeclWarpBean();
            declWarpBean.setNodeId(key);
            DeclInfo processMethodDeclInfo = declInfos.stream().filter(declInfo -> declInfo.getMethodWrapBean().getLiteflowMethod().value().isMainMethod()).findFirst().orElse(null);
            if (processMethodDeclInfo == null) {
                throw new CmpDefinitionException(StrUtil.format((CharSequence)"Component [{}] does not define the process method", (Object[])new Object[]{key}));
            }
            declWarpBean.setNodeName(processMethodDeclInfo.getNodeName());
            declWarpBean.setRawClazz(processMethodDeclInfo.getRawClazz());
            declWarpBean.setNodeType(processMethodDeclInfo.getNodeType());
            RootBeanDefinition rawClassDefinition = new RootBeanDefinition(clazz);
            rawClassDefinition.setScope("singleton");
            declWarpBean.setRawBean((Object)rawClassDefinition);
            declWarpBean.setMethodWrapBeanList(declInfos.stream().map(DeclInfo::getMethodWrapBean).collect(Collectors.toList()));
            return declWarpBean;
        }).collect(Collectors.toList());
    }

    public int priority() {
        return 1;
    }

    public static class DeclInfo {
        private String nodeId;
        private String nodeName;
        private NodeTypeEnum nodeType;
        private Class<?> rawClazz;
        private MethodWrapBean methodWrapBean;

        public DeclInfo(String nodeId, String nodeName, NodeTypeEnum nodeType, Class<?> rawClazz, MethodWrapBean methodWrapBean) {
            this.nodeId = nodeId;
            this.nodeName = nodeName;
            this.nodeType = nodeType;
            this.rawClazz = rawClazz;
            this.methodWrapBean = methodWrapBean;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public Class<?> getRawClazz() {
            return this.rawClazz;
        }

        public void setRawClazz(Class<?> rawClazz) {
            this.rawClazz = rawClazz;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public MethodWrapBean getMethodWrapBean() {
            return this.methodWrapBean;
        }

        public void setMethodWrapBean(MethodWrapBean methodWrapBean) {
            this.methodWrapBean = methodWrapBean;
        }

        public NodeTypeEnum getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(NodeTypeEnum nodeType) {
            this.nodeType = nodeType;
        }
    }
}

