/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.spring;

import com.jxdinfo.hutool.core.annotation.AnnotationUtil;
import com.jxdinfo.hutool.core.collection.CollStreamUtil;
import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.annotation.util.AnnoUtil;
import com.jxdinfo.liteflow.aop.ICmpAroundAspect;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.core.proxy.DeclWarpBean;
import com.jxdinfo.liteflow.core.proxy.LiteFlowProxyUtil;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.script.ScriptBeanManager;
import com.jxdinfo.liteflow.script.annotation.ScriptBean;
import com.jxdinfo.liteflow.script.annotation.ScriptMethod;
import com.jxdinfo.liteflow.script.proxy.ScriptBeanProxy;
import com.jxdinfo.liteflow.script.proxy.ScriptMethodProxy;
import com.jxdinfo.liteflow.util.LOGOPrinter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ComponentScanner
implements BeanPostProcessor {
    private static final String REFRESH_SCOPE_ANN_BEAN_PREFIX = "scopedTarget.";
    private static final String REFRESH_SCOPE_ANN_CLASS_PATH = "org.springframework.cloud.context.config.annotation.RefreshScope";
    private static final Logger LOG = LoggerFactory.getLogger(ComponentScanner.class);
    public static Set<String> nodeComponentSet = new HashSet<String>();
    private LiteflowConfig liteflowConfig;
    public static ICmpAroundAspect cmpAroundAspect;

    public ComponentScanner() {
        LOGOPrinter.print();
    }

    public ComponentScanner(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        if (liteflowConfig.getPrintBanner().booleanValue()) {
            LOGOPrinter.print();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class clazz = LiteFlowProxyUtil.getUserClass(bean.getClass());
        if (bean instanceof DeclWarpBean) {
            NodeComponent nodeComponent = LiteFlowProxyUtil.proxy2NodeComponent((DeclWarpBean)((DeclWarpBean)bean));
            String nodeId = StrUtil.isEmpty((CharSequence)nodeComponent.getNodeId()) ? this.getRealBeanName(clazz, beanName) : nodeComponent.getNodeId();
            nodeComponentSet.add(nodeId);
            LOG.info("proxy component[{}] has been found", (Object)beanName);
            return nodeComponent;
        }
        if (NodeComponent.class.isAssignableFrom(clazz)) {
            LOG.info("component[{}] has been found", (Object)beanName);
            NodeComponent nodeComponent = (NodeComponent)bean;
            nodeComponentSet.add(this.getRealBeanName(clazz, beanName));
            return nodeComponent;
        }
        if (ICmpAroundAspect.class.isAssignableFrom(clazz)) {
            LOG.info("component aspect implement[{}] has been found", (Object)beanName);
            cmpAroundAspect = (ICmpAroundAspect)bean;
            return cmpAroundAspect;
        }
        ScriptBean scriptBean = (ScriptBean)AnnoUtil.getAnnotation((AnnotatedElement)clazz, ScriptBean.class);
        if (ObjectUtil.isNotNull((Object)scriptBean)) {
            ScriptBeanProxy proxy = new ScriptBeanProxy(bean, clazz, scriptBean);
            ScriptBeanManager.addScriptBean((String)scriptBean.value(), (Object)proxy.getProxyScriptBean());
            return bean;
        }
        List scriptMethods = Arrays.stream(clazz.getMethods()).filter(method -> {
            ScriptMethod scriptMethod = (ScriptMethod)AnnoUtil.getAnnotation((AnnotatedElement)method, ScriptMethod.class);
            return ObjectUtil.isNotNull((Object)scriptMethod) && StrUtil.isNotEmpty((CharSequence)scriptMethod.value());
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(scriptMethods)) {
            Map scriptMethodsGroupByValue = CollStreamUtil.groupBy(scriptMethods, method -> {
                ScriptMethod scriptMethod = (ScriptMethod)AnnoUtil.getAnnotation((AnnotatedElement)method, ScriptMethod.class);
                return scriptMethod.value();
            }, Collectors.toList());
            for (Map.Entry entry : scriptMethodsGroupByValue.entrySet()) {
                String key = (String)entry.getKey();
                List methods = (List)entry.getValue();
                ScriptMethodProxy proxy = new ScriptMethodProxy(bean, clazz, methods);
                ScriptBeanManager.addScriptBean((String)key, (Object)proxy.getProxyScriptMethod());
            }
            return bean;
        }
        return bean;
    }

    public static void cleanCache() {
        nodeComponentSet.clear();
    }

    private String getRealBeanName(Class<?> clazz, String beanName) {
        if (beanName.startsWith(REFRESH_SCOPE_ANN_BEAN_PREFIX)) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = AnnotationUtil.getAnnotations(clazz, (boolean)true)) {
                String name = annotation.annotationType().getName();
                if (!REFRESH_SCOPE_ANN_CLASS_PATH.equals(name)) continue;
                return beanName.replace(REFRESH_SCOPE_ANN_BEAN_PREFIX, "");
            }
        }
        return beanName;
    }
}

