/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.springboot.config;

import com.jxdinfo.liteflow.core.FlowExecutor;
import com.jxdinfo.liteflow.monitor.MonitorBus;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.spi.spring.SpringAware;
import com.jxdinfo.liteflow.spring.ComponentScanner;
import com.jxdinfo.liteflow.spring.DeclBeanDefinition;
import com.jxdinfo.liteflow.spring.LiteflowSpiInit;
import com.jxdinfo.liteflow.springboot.LiteflowExecutorInit;
import com.jxdinfo.liteflow.springboot.config.LiteflowPropertyAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureAfter(value={LiteflowPropertyAutoConfiguration.class})
@ConditionalOnBean(value={LiteflowConfig.class})
@ConditionalOnProperty(prefix="liteflow", name={"enable"}, havingValue="true")
@Import(value={SpringAware.class})
public class LiteflowMainAutoConfiguration {
    @Bean
    public DeclBeanDefinition declBeanDefinition() {
        return new DeclBeanDefinition();
    }

    @Bean
    public ComponentScanner componentScanner(LiteflowConfig liteflowConfig, SpringAware springAware) {
        return new ComponentScanner(liteflowConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public FlowExecutor flowExecutor(LiteflowConfig liteflowConfig, SpringAware springAware) {
        FlowExecutor flowExecutor = new FlowExecutor();
        flowExecutor.setLiteflowConfig(liteflowConfig);
        return flowExecutor;
    }

    @Bean
    @ConditionalOnProperty(prefix="liteflow", name={"parse-mode"}, havingValue="PARSE_ALL_ON_START")
    public LiteflowExecutorInit liteflowExecutorInit1(FlowExecutor flowExecutor) {
        return new LiteflowExecutorInit(flowExecutor);
    }

    @Bean
    @ConditionalOnProperty(prefix="liteflow", name={"parse-mode"}, havingValue="PARSE_ONE_ON_FIRST_EXEC")
    public LiteflowExecutorInit liteflowExecutorInit2(FlowExecutor flowExecutor) {
        return new LiteflowExecutorInit(flowExecutor);
    }

    @Bean(value={"monitorBus"})
    @ConditionalOnProperty(prefix="liteflow", name={"monitor.enable-log"}, havingValue="true")
    public MonitorBus monitorBus(LiteflowConfig liteflowConfig, SpringAware springAware) {
        return new MonitorBus(liteflowConfig);
    }

    @Bean
    public LiteflowSpiInit liteflowSpiInit() {
        return new LiteflowSpiInit();
    }
}

