/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.domain.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.flow.config.model.IdpFlowChain;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.idp.flow.config.service.IdpFlowChainService;
import com.jxdinfo.idp.flow.config.service.IdpFlowLinkService;
import com.jxdinfo.idp.flow.config.service.IdpFlowTagService;
import com.jxdinfo.idp.flow.domain.service.IdpFlowChainViewService;
import com.jxdinfo.idp.flow.domain.view.FlowChainView;
import com.jxdinfo.idp.flow.engine.FlowTaskContext;
import com.jxdinfo.idp.flow.rule.FlowChainUtils;
import com.jxdinfo.idp.flow.rule.FlowELUtils;
import com.jxdinfo.liteflow.builder.el.LiteFlowChainELBuilder;
import com.jxdinfo.liteflow.common.entity.ValidationResp;
import com.jxdinfo.liteflow.flow.FlowBus;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IdpFlowChainViewServiceImpl
implements IdpFlowChainViewService {
    @Resource
    private IdpFlowTagService idpFlowTagService;
    @Resource
    private IdpFlowLinkService idpFlowLinkService;
    @Resource
    private IdpFlowChainService idpFlowChainService;

    public IdpFlowChainViewServiceImpl() {
        IdpFlowChainViewServiceImpl a;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateFlowChain(FlowChainView a) {
        IdpFlowChainViewServiceImpl a2;
        IdpFlowChain idpFlowChain;
        IdpFlowChain idpFlowChain2 = idpFlowChain = new IdpFlowChain();
        FlowChainView flowChainView = a;
        IdpFlowChain idpFlowChain3 = idpFlowChain;
        idpFlowChain3.setId(a.getId());
        idpFlowChain3.setChainName(FlowChainUtils.getChainName(idpFlowChain3.getId()));
        idpFlowChain.setChainDesc(flowChainView.getName());
        idpFlowChain2.setElData(flowChainView.getEl());
        idpFlowChain2.setViewData(a.getView());
        ValidationResp validationResp = LiteFlowChainELBuilder.validateWithEx((String)idpFlowChain2.getElData());
        if (!validationResp.isSuccess()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = validationResp.getCause();
            throw new BusinessException(StrUtil.format((CharSequence)FlowELUtils.void("\u63ca\u53e1\u6d58\u7a3f\u9a8d\u8bed\u5904\u8d3d\uff12\u5902\u8d32\u53a5\u56ff\uff28cH"), (Object[])objectArray));
        }
        idpFlowChain.setUpdateTime(new Date());
        a2.idpFlowChainService.updateById(idpFlowChain);
        FlowBus.reloadChain((String)idpFlowChain.getChainName(), (String)idpFlowChain.getElData());
        a2.idpFlowTagService.updateFlowTags(idpFlowChain.getId(), a.getTags());
        a2.idpFlowLinkService.updateFlowLinks(idpFlowChain.getId(), a.getLinks());
        return idpFlowChain.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createFlowChain(FlowChainView a) {
        IdpFlowChainViewServiceImpl a2;
        IdpFlowChain idpFlowChain;
        IdpFlowChain idpFlowChain2 = new IdpFlowChain();
        if (a.getId() == null) {
            IdpFlowChain idpFlowChain3 = idpFlowChain2;
            idpFlowChain = idpFlowChain3;
            idpFlowChain3.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        } else {
            IdpFlowChain idpFlowChain4 = idpFlowChain2;
            idpFlowChain = idpFlowChain4;
            idpFlowChain4.setId(a.getId());
        }
        idpFlowChain.setApplicationName(FlowELUtils.void("{WuZ"));
        IdpFlowChain idpFlowChain5 = idpFlowChain2;
        FlowChainView flowChainView = a;
        IdpFlowChain idpFlowChain6 = idpFlowChain2;
        idpFlowChain6.setChainName(FlowChainUtils.getChainName(idpFlowChain6.getId()));
        idpFlowChain6.setChainDesc(a.getName());
        idpFlowChain2.setElData(flowChainView.getEl());
        idpFlowChain5.setViewData(flowChainView.getView());
        idpFlowChain5.setCategoryId(a.getCategoryId());
        ValidationResp validationResp = LiteFlowChainELBuilder.validateWithEx((String)idpFlowChain5.getElData());
        if (!validationResp.isSuccess()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = validationResp.getCause();
            throw new BusinessException(StrUtil.format((CharSequence)FlowTaskContext.while("\u639d\u53bc\u6d13\u7a7e\u9ad4\u8bbe\u596f\u8d5c\uff7e\u5964\u8d73\u53ee\u56ab\uff76,\r"), (Object[])objectArray));
        }
        idpFlowChain2.setCreateTime(new Date());
        a2.idpFlowChainService.save(idpFlowChain2);
        FlowBus.reloadChain((String)idpFlowChain2.getChainName(), (String)idpFlowChain2.getElData());
        a2.idpFlowTagService.createFlowTags(idpFlowChain2.getId(), a.getTags());
        a2.idpFlowLinkService.createFlowLinks(idpFlowChain2.getId(), a.getLinks());
        return idpFlowChain2.getId();
    }

    public Long saveOrUpdate(FlowChainView a) {
        IdpFlowChainViewServiceImpl a2;
        if (a.getId() == null) {
            return a2.createFlowChain(a);
        }
        if (ObjectUtil.isNull((Object)((IdpFlowChain)a2.idpFlowChainService.getById(a.getId())))) {
            return a2.createFlowChain(a);
        }
        return a2.updateFlowChain(a);
    }

    public FlowChainView getById(Long a) {
        FlowChainView flowChainView;
        IdpFlowChainViewServiceImpl a2;
        IdpFlowChain idpFlowChain = (IdpFlowChain)a2.idpFlowChainService.getById((Serializable)a);
        if (ObjectUtil.isNull((Object)idpFlowChain)) {
            throw new BusinessException(FlowELUtils.void("\u6d63\u7a34\u4e1f\u5b4a\u5717"));
        }
        if (ObjectUtil.isNull((Object)FlowBus.getChain((String)idpFlowChain.getChainName()))) {
            Object[] objectArray = new Object[1];
            objectArray[0] = idpFlowChain.getChainDesc();
            throw new BusinessException(StrUtil.format((CharSequence)FlowTaskContext.while("\u6d14\u7a5d\n6\u4e61\u5b0f\u5758"), (Object[])objectArray));
        }
        FlowChainView flowChainView2 = flowChainView = new FlowChainView();
        IdpFlowChain idpFlowChain2 = idpFlowChain;
        flowChainView.setId(idpFlowChain.getId());
        flowChainView.setName(idpFlowChain2.getChainDesc());
        flowChainView2.setEl(idpFlowChain2.getElData());
        flowChainView2.setView(idpFlowChain.getViewData());
        List<IdpFlowTag> list = a2.idpFlowTagService.selectByChainId((Long)a);
        if (CollectionUtils.isEmpty(list)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = idpFlowChain.getChainDesc();
            throw new BusinessException(StrUtil.format((CharSequence)FlowELUtils.void("\u6d52\u7a35YTID\u828d\u709b\u654f\u637c\u7f28\u590e"), (Object[])objectArray));
        }
        flowChainView.setTags(list);
        a = a2.idpFlowLinkService.selectByChainId((Long)a);
        if (list.size() > 1 && CollectionUtils.isEmpty((Collection)a)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = idpFlowChain.getChainDesc();
            throw new BusinessException(StrUtil.format((CharSequence)FlowTaskContext.while("\u6d19\u7a74\u0005\u0002\u000f\b\u8f88\u63d4\u653b\u6302\u7f6d\u5941"), (Object[])objectArray));
        }
        FlowChainView flowChainView3 = flowChainView;
        flowChainView3.setLinks((List)a);
        return flowChainView3;
    }

    /*
     * WARNING - void declaration
     */
    public List<IdpFlowTag> getTagByChainId(Long l) {
        void a;
        IdpFlowChainViewServiceImpl a2;
        return a2.idpFlowTagService.selectByChainId((Long)a);
    }
}

