/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.domain.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.flow.convert.VueFlowConvert;
import com.jxdinfo.idp.flow.convert.bean.CmpProperty;
import com.jxdinfo.idp.flow.convert.bean.ELInfo;
import com.jxdinfo.idp.flow.convert.generator.ExpressGenerator;
import com.jxdinfo.idp.flow.engine.FlowTaskContext;
import com.jxdinfo.idp.flow.parser.entity.FlowData;
import com.jxdinfo.idp.flow.parser.graph.Graph;
import com.jxdinfo.idp.flow.rule.FlowELUtils;
import com.jxdinfo.liteflow.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/idp/flow/el"})
@RestController
public class GenerateELController {
    @Autowired
    private ExpressGenerator expressGenerator;
    private static final Logger log = LoggerFactory.getLogger(GenerateELController.class);

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/elToJson"})
    public JSONObject elToJson(@RequestBody ELInfo eLInfo) {
        void elInfo;
        return new VueFlowConvert().elToJson((ELInfo)elInfo);
    }

    @PostMapping(value={"verifyELExpression"})
    public ApiResponse<Boolean> verifyELExpression(@Nullable @RequestBody CmpProperty jsonEl) {
        log.info(FlowTaskContext.while("81\u001d0\u0000.\u001c,+\u0018S\u6561\u5240\u6527\u631edY2\u0013"), (Object)JsonUtil.toJsonString((Object)jsonEl));
        try {
            return ApiResponse.success((Object)this.expressGenerator.verifyELExpression(jsonEl));
        }
        catch (Exception a) {
            log.error(FlowELUtils.void("\u001f4\u00195\u0018"), (Throwable)a);
            return ApiResponse.success((Object)false);
        }
    }

    @PostMapping(value={"/generateJsonEL"})
    @ResponseBody
    public CmpProperty generateJsonEL(@Nullable @RequestBody ELInfo elInfo) {
        log.info(FlowTaskContext.while(">\u0012>\u001d-5\u000708<\u0007'+\u0018S\u6561\u5240\u6527\u631edY2\u0013"), (Object)JsonUtil.toJsonString((Object)elInfo));
        CmpProperty a = new CmpProperty();
        try {
            a = this.expressGenerator.generateJsonEL(elInfo);
        }
        catch (Exception a2) {
            log.error(FlowELUtils.void("\u0018\u001e3\u0017:"), (Throwable)a2);
        }
        log.info(FlowTaskContext.while(">\u0012>\u001d-5\u000708<\u0007'+\u0018S\u7548\u6260\u6527\u631edY2\u0013"), (Object)JsonUtil.toJsonString((Object)a));
        return a;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/generateEL"})
    @ResponseBody
    public ELInfo generateEL(@Nullable @RequestBody CmpProperty cmpProperty) {
        void jsonEl;
        log.info(FlowELUtils.void("[vP}GrJal[\u001a\u6534\u521f\u6563\u6350\t>Aj"), (Object)JsonUtil.toJsonString((Object)jsonEl));
        ELInfo a = new ELInfo();
        try {
            a = this.expressGenerator.generateEL((CmpProperty)jsonEl);
        }
        catch (Exception a2) {
            log.error(FlowTaskContext.while("]sTdC"), (Throwable)a2);
        }
        log.info(FlowELUtils.void("[vP}GrJal[\u001a\u751d\u623f\u6563\u6350\t>Aj"), (Object)JsonUtil.toJsonString((Object)a));
        return a;
    }

    @PostMapping(value={"/jsonToEL"})
    public String jsonToEL(@RequestBody FlowData data) {
        try {
            Graph a = new Graph(data);
            return a.toELInfo().toString();
        }
        catch (Exception a) {
            log.error(FlowTaskContext.while("]sTdC"), (Throwable)a);
            return a.getMessage();
        }
    }
}

