/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.rule;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.ThenCondition;
import com.jxdinfo.liteflow.flow.element.condition.WhenCondition;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FlowELUtils {
    public static List<IdpFlowTag> buildFlowTags(List<Condition> conditions) {
        ArrayList<IdpFlowTag> flowTags = new ArrayList<IdpFlowTag>();
        for (Condition condition : conditions) {
            FlowELUtils.buildFlowTag((Executable)condition, flowTags);
        }
        return flowTags;
    }

    private static void buildFlowTag(Executable executable, List<IdpFlowTag> flowTags) {
        Node node;
        if (executable instanceof ThenCondition) {
            ThenCondition thenCondition = (ThenCondition)executable;
            List executableList = thenCondition.getExecutableList();
            for (Executable subExecutable : executableList) {
                FlowELUtils.buildFlowTag(subExecutable, flowTags);
            }
        } else if (executable instanceof WhenCondition) {
            WhenCondition whenCondition = (WhenCondition)executable;
            List executableList = whenCondition.getExecutableList();
            for (Executable subExecutable : executableList) {
                FlowELUtils.buildFlowTag(subExecutable, flowTags);
            }
        } else if (executable instanceof Node && (node = (Node)executable).getTag() != null) {
            IdpFlowTag flowTag = new IdpFlowTag();
            flowTag.setId(node.getTag());
            if (StringUtils.isNotBlank((CharSequence)node.getCmpData())) {
                flowTag.setConfigParams(node.getCmpData());
            } else {
                flowTag.setConfigParams(new JSONObject().toString());
            }
            flowTags.add(flowTag);
        }
    }
}

