/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.engine;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.flow.common.FlowStateEnum;
import com.jxdinfo.idp.flow.config.model.IdpFlowChain;
import com.jxdinfo.idp.flow.config.model.IdpFlowLink;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.idp.flow.config.service.IdpFlowChainService;
import com.jxdinfo.idp.flow.config.service.IdpFlowLinkService;
import com.jxdinfo.idp.flow.config.service.IdpFlowTagService;
import com.jxdinfo.idp.flow.engine.FlowTaskContext;
import com.jxdinfo.idp.flow.engine.IdpFlowExecutor;
import com.jxdinfo.idp.flow.engine.model.IdpFlowInstance;
import com.jxdinfo.idp.flow.engine.service.IdpFlowInstanceService;
import com.jxdinfo.idp.flow.engine.service.IdpFlowTaskService;
import com.jxdinfo.idp.flow.rule.FlowChainUtils;
import com.jxdinfo.liteflow.core.FlowExecutor;
import com.jxdinfo.liteflow.flow.LiteflowResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class IdpFlowExecutorImpl
implements IdpFlowExecutor {
    @Resource
    private IdpFlowChainService idpFlowChainService;
    @Resource
    private IdpFlowTagService idpFlowTagService;
    @Resource
    private IdpFlowLinkService idpFlowLinkService;
    @Resource
    private IdpFlowInstanceService idpFlowInstanceService;
    @Resource
    private IdpFlowTaskService idpFlowTaskService;
    @Resource
    private FlowExecutor flowExecutor;

    public IdpFlowInstance execute(Long chainId, Object contextBean) {
        IdpFlowChain flowChain = (IdpFlowChain)this.idpFlowChainService.getById(chainId);
        if (ObjectUtil.isNull((Object)flowChain)) {
            throw new BusinessException("\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        FlowTaskContext flowTaskContext = new FlowTaskContext();
        List<IdpFlowTag> flowTags = this.idpFlowTagService.selectByChainId(chainId);
        if (CollectionUtil.isEmpty(flowTags)) {
            throw new BusinessException("\u6d41\u7a0b\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        for (IdpFlowTag flowTag : flowTags) {
            flowTaskContext.flowTagMap.put(flowTag.getId(), flowTag);
        }
        List<IdpFlowLink> flowLinks = this.idpFlowLinkService.selectByChainId(chainId);
        if (flowTags.size() > 1 && CollectionUtil.isEmpty(flowLinks)) {
            throw new BusinessException("\u6d41\u7a0b\u8fde\u63a5\u4e0d\u5b58\u5728");
        }
        flowTaskContext.flowLinkList = flowLinks;
        IdpFlowInstance instance = new IdpFlowInstance();
        instance.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        instance.setChainId(chainId);
        instance.setElData(flowChain.getElData());
        instance.setStartTime(new Date());
        this.idpFlowInstanceService.save(instance);
        LiteflowResponse response = this.flowExecutor.execute2RespWithRid(FlowChainUtils.getChainName(chainId), (Object)instance.getId(), instance.getId().toString(), new Object[]{flowTaskContext, contextBean});
        if (response.isSuccess()) {
            instance.setState(FlowStateEnum.success.getCode());
        } else {
            instance.setState(FlowStateEnum.error.getCode());
            instance.setError(response.getCause().getMessage());
        }
        List<JSONObject> lastValue = null;
        for (Map.Entry<String, List<JSONObject>> entry : flowTaskContext.flowTaskResultMap.entrySet()) {
            lastValue = entry.getValue();
        }
        if (lastValue != null) {
            instance.setResult(lastValue.toString());
        }
        instance.setEndTime(new Date());
        instance.setDuration(Long.valueOf(instance.getEndTime().getTime() - instance.getStartTime().getTime()));
        this.idpFlowInstanceService.updateById(instance);
        instance.setTasks(this.idpFlowTaskService.selectByInstanceId(instance.getId()));
        return instance;
    }
}

