/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.domain.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.flow.config.model.IdpFlowChain;
import com.jxdinfo.idp.flow.config.model.IdpFlowLink;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.idp.flow.config.service.IdpFlowChainService;
import com.jxdinfo.idp.flow.config.service.IdpFlowLinkService;
import com.jxdinfo.idp.flow.config.service.IdpFlowTagService;
import com.jxdinfo.idp.flow.domain.service.IdpFlowChainViewService;
import com.jxdinfo.idp.flow.domain.view.FlowChainView;
import com.jxdinfo.idp.flow.rule.FlowChainUtils;
import com.jxdinfo.liteflow.builder.el.LiteFlowChainELBuilder;
import com.jxdinfo.liteflow.common.entity.ValidationResp;
import com.jxdinfo.liteflow.flow.FlowBus;
import com.jxdinfo.liteflow.flow.element.Chain;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IdpFlowChainViewServiceImpl
implements IdpFlowChainViewService {
    @Resource
    private IdpFlowChainService idpFlowChainService;
    @Resource
    private IdpFlowTagService idpFlowTagService;
    @Resource
    private IdpFlowLinkService idpFlowLinkService;

    public FlowChainView getById(Long id) {
        IdpFlowChain flowChain = (IdpFlowChain)this.idpFlowChainService.getById(id);
        if (ObjectUtil.isNull((Object)flowChain)) {
            throw new BusinessException("\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        Chain chain = FlowBus.getChain((String)flowChain.getChainName());
        if (ObjectUtil.isNull((Object)chain)) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u6d41\u7a0b{}\u4e0d\u5b58\u5728", (Object[])new Object[]{flowChain.getChainDesc()}));
        }
        FlowChainView flowChainView = new FlowChainView();
        flowChainView.setId(flowChain.getId());
        flowChainView.setName(flowChain.getChainDesc());
        flowChainView.setEl(flowChain.getElData());
        flowChainView.setView(flowChain.getViewData());
        List<IdpFlowTag> idpFlowTags = this.idpFlowTagService.selectByChainId(id);
        if (CollectionUtils.isEmpty(idpFlowTags)) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u6d41\u7a0b[{}]\u8282\u70b9\u6570\u636e\u7f3a\u5931", (Object[])new Object[]{flowChain.getChainDesc()}));
        }
        flowChainView.setTags(idpFlowTags);
        List<IdpFlowLink> idpFlowLinks = this.idpFlowLinkService.selectByChainId(id);
        if (idpFlowTags.size() > 1 && CollectionUtils.isEmpty(idpFlowLinks)) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u6d41\u7a0b[{}]\u8fde\u63a5\u6570\u636e\u7f3a\u5931", (Object[])new Object[]{flowChain.getChainDesc()}));
        }
        flowChainView.setLinks(idpFlowLinks);
        return flowChainView;
    }

    public List<IdpFlowTag> getTagByChainId(Long id) {
        return this.idpFlowTagService.selectByChainId(id);
    }

    public Long saveOrUpdate(FlowChainView flowChainView) {
        if (flowChainView.getId() == null) {
            return this.createFlowChain(flowChainView);
        }
        IdpFlowChain flowChain = (IdpFlowChain)this.idpFlowChainService.getById(flowChainView.getId());
        if (ObjectUtil.isNull((Object)flowChain)) {
            return this.createFlowChain(flowChainView);
        }
        return this.updateFlowChain(flowChainView);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createFlowChain(FlowChainView flowChainView) {
        IdpFlowChain idpFlowChain = new IdpFlowChain();
        if (flowChainView.getId() == null) {
            idpFlowChain.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        } else {
            idpFlowChain.setId(flowChainView.getId());
        }
        idpFlowChain.setApplicationName("demo");
        idpFlowChain.setChainName(FlowChainUtils.getChainName(idpFlowChain.getId()));
        idpFlowChain.setChainDesc(flowChainView.getName());
        idpFlowChain.setElData(flowChainView.getEl());
        idpFlowChain.setViewData(flowChainView.getView());
        idpFlowChain.setCategoryId(flowChainView.getCategoryId());
        ValidationResp validationResp = LiteFlowChainELBuilder.validateWithEx((String)idpFlowChain.getElData());
        if (!validationResp.isSuccess()) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u63d0\u53d6\u6d41\u7a0b\u9a8c\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object[])new Object[]{validationResp.getCause()}));
        }
        idpFlowChain.setCreateTime(new Date());
        this.idpFlowChainService.save(idpFlowChain);
        FlowBus.reloadChain((String)idpFlowChain.getChainName(), (String)idpFlowChain.getElData());
        this.idpFlowTagService.createFlowTags(idpFlowChain.getId(), flowChainView.getTags());
        this.idpFlowLinkService.createFlowLinks(idpFlowChain.getId(), flowChainView.getLinks());
        return idpFlowChain.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateFlowChain(FlowChainView flowChainView) {
        IdpFlowChain idpFlowChain = new IdpFlowChain();
        idpFlowChain.setId(flowChainView.getId());
        idpFlowChain.setChainName(FlowChainUtils.getChainName(idpFlowChain.getId()));
        idpFlowChain.setChainDesc(flowChainView.getName());
        idpFlowChain.setElData(flowChainView.getEl());
        idpFlowChain.setViewData(flowChainView.getView());
        ValidationResp validationResp = LiteFlowChainELBuilder.validateWithEx((String)idpFlowChain.getElData());
        if (!validationResp.isSuccess()) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u63d0\u53d6\u6d41\u7a0b\u9a8c\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object[])new Object[]{validationResp.getCause()}));
        }
        idpFlowChain.setUpdateTime(new Date());
        this.idpFlowChainService.updateById(idpFlowChain);
        FlowBus.reloadChain((String)idpFlowChain.getChainName(), (String)idpFlowChain.getElData());
        this.idpFlowTagService.updateFlowTags(idpFlowChain.getId(), flowChainView.getTags());
        this.idpFlowLinkService.updateFlowLinks(idpFlowChain.getId(), flowChainView.getLinks());
        return idpFlowChain.getId();
    }
}

