/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.flow.config.model.IdpFlowLink;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.idp.flow.config.service.IdpFlowTagService;
import com.jxdinfo.idp.flow.engine.FlowTaskContext;
import com.jxdinfo.idp.flow.engine.service.IdpFlowTaskService;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;

public abstract class SimpleNodeComponent
extends NodeComponent {
    private final LFLog logger = LFLoggerManager.getLogger(SimpleNodeComponent.class);
    @Resource
    private IdpFlowTagService idpFlowTagService;
    @Resource
    private IdpFlowTaskService idpFlowTaskService;

    public void process() throws Exception {
        String tagId = this.getTagId();
        FlowTaskContext flowTaskContext = (FlowTaskContext)this.getContextBean(FlowTaskContext.class);
        if (flowTaskContext == null) {
            throw new BusinessException("\u6d41\u7a0b\u6570\u636e\u4e0a\u4e0b\u6587\u4e3a\u7a7a");
        }
        IdpFlowTag idpFlowTag = (IdpFlowTag)this.idpFlowTagService.getById((Serializable)((Object)tagId));
        if (idpFlowTag == null) {
            throw new BusinessException("\u6d41\u7a0b\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        flowTaskContext.flowTagMap.put(tagId, idpFlowTag);
        JSONObject configParams = idpFlowTag.getConfigParamsJSON();
        if (configParams == null) {
            throw new BusinessException("\u914d\u7f6e\u53c2\u6570\u4e3a\u7a7a");
        }
        flowTaskContext.flowTaskConfigMap.put(tagId, configParams);
        List<Object> inputParams = this.getObjectInput();
        if (inputParams == null) {
            throw new BusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        flowTaskContext.flowTaskInputParamsMap.put(tagId, inputParams);
        List<Object> output = this.executeOrCache();
        flowTaskContext.flowTaskOutputParamsMap.put(tagId, output);
        flowTaskContext.flowTaskResultMap.putIfAbsent(tagId, output);
    }

    public abstract List<Object> getObjectInput();

    public abstract Map<String, List<JSONObject>> getJsonInput();

    public abstract List<Object> executeProcess();

    protected List<IdpFlowTag> getParents() {
        List parentLinks;
        if (this.getTagId() == null) {
            throw new BusinessException("\u6d41\u7a0b\u8282\u70b9id\u4e3a\u7a7a");
        }
        List<Object> tags = new ArrayList<IdpFlowTag>();
        FlowTaskContext flowTaskContext = (FlowTaskContext)this.getContextBean(FlowTaskContext.class);
        if (flowTaskContext == null) {
            throw new BusinessException("\u6d41\u7a0b\u6570\u636e\u4e0a\u4e0b\u6587\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty(flowTaskContext.flowLinkList) && CollectionUtils.isNotEmpty(parentLinks = flowTaskContext.flowLinkList.stream().filter(link -> Objects.equals(this.getTagId(), link.getTargetId())).collect(Collectors.toList()))) {
            List parentIds = parentLinks.stream().map(IdpFlowLink::getSourceId).collect(Collectors.toList());
            tags = this.idpFlowTagService.listByIds(parentIds);
        }
        return tags;
    }

    private List<Object> executeOrCache() {
        String tagId = this.getTagId();
        FlowTaskContext flowTaskContext = (FlowTaskContext)this.getContextBean(FlowTaskContext.class);
        String resultByMd5 = this.idpFlowTaskService.getResultByMd5(flowTaskContext.flowTaskConfigMap.get(tagId).toString(), JSONArray.parseArray((String)JSON.toJSONString(flowTaskContext.flowTaskInputParamsMap.get(tagId))).toString());
        List<Object> output = this.executeProcess();
        return output;
    }

    public String getTagId() {
        return this.getTag();
    }

    public Long getInstanceId() {
        return Long.parseLong((String)this.getRequestData());
    }

    public IdpFlowTag getIdpFlowTag() {
        String tagId = this.getTagId();
        FlowTaskContext flowTaskContext = (FlowTaskContext)this.getContextBean(FlowTaskContext.class);
        return flowTaskContext.flowTagMap.get(tagId);
    }

    public JSONObject getConfigParams() {
        String tagId = this.getTagId();
        FlowTaskContext flowTaskContext = (FlowTaskContext)this.getContextBean(FlowTaskContext.class);
        return flowTaskContext.flowTaskConfigMap.get(tagId);
    }
}

