/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.engine;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hutool.crypto.SecureUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.flow.common.FlowStateEnum;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.idp.flow.config.service.IdpFlowTagService;
import com.jxdinfo.idp.flow.engine.FlowTaskContext;
import com.jxdinfo.idp.flow.engine.model.IdpFlowTask;
import com.jxdinfo.idp.flow.engine.service.IdpFlowTaskService;
import com.jxdinfo.idp.flow.rule.FlowChainUtils;
import com.jxdinfo.liteflow.aop.ICmpAroundAspect;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class FLowExecutorAspect
implements ICmpAroundAspect {
    private final LFLog logger = LFLoggerManager.getLogger(FLowExecutorAspect.class);
    @Resource
    private IdpFlowTaskService idpFlowTaskService;
    @Resource
    private IdpFlowTagService idpFlowTagService;

    public void beforeProcess(NodeComponent cmp) {
        String tagId = cmp.getTag();
        FlowTaskContext flowTaskContext = (FlowTaskContext)cmp.getContextBean(FlowTaskContext.class);
        IdpFlowTag idpFlowTag = this.getIdpFlowTag(tagId, flowTaskContext);
        IdpFlowTask idpFlowTask = new IdpFlowTask();
        idpFlowTask.setTagId(tagId);
        idpFlowTask.setChainId(FlowChainUtils.getChainId(cmp.getChainId()));
        idpFlowTask.setInstanceId((Long)cmp.getRequestData());
        idpFlowTask.setConfigParams(idpFlowTag.getConfigParams());
        idpFlowTask.setConfigParamsMd5(SecureUtil.md5((String)idpFlowTask.getConfigParams()));
        idpFlowTask.setStartTime(new Date());
        this.idpFlowTaskService.save(idpFlowTask);
        flowTaskContext.flowTaskMap.put(tagId, idpFlowTask);
    }

    public void afterProcess(NodeComponent cmp) {
    }

    public void onSuccess(NodeComponent cmp) {
        IdpFlowTask idpFlowTask = this.getDefaultIdpFlowTask(cmp);
        idpFlowTask.setState(FlowStateEnum.success.getCode());
        this.idpFlowTaskService.updateByUnique(idpFlowTask);
    }

    public void onError(NodeComponent cmp, Exception e) {
        IdpFlowTask idpFlowTask = this.getDefaultIdpFlowTask(cmp);
        idpFlowTask.setState(FlowStateEnum.error.getCode());
        idpFlowTask.setError(e.getMessage());
        this.logger.error(StrUtil.format((CharSequence)"\u6d41\u7a0b[{}]\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6d41\u7a0b\u6807\u7b7e[{}]", (Object[])new Object[]{cmp.getName(), idpFlowTask.getTagId()}));
        this.logger.error(e.getMessage(), (Throwable)e);
        this.idpFlowTaskService.updateByUnique(idpFlowTask);
    }

    private IdpFlowTask getDefaultIdpFlowTask(NodeComponent cmp) {
        Object o;
        String tagId = cmp.getTag();
        FlowTaskContext flowTaskContext = (FlowTaskContext)cmp.getContextBean(FlowTaskContext.class);
        IdpFlowTask idpFlowTask = (IdpFlowTask)flowTaskContext.flowTaskMap.get(tagId);
        IdpFlowTag idpFlowTag = this.getIdpFlowTag(tagId, flowTaskContext);
        idpFlowTask.setConfigParams(idpFlowTag.getConfigParams());
        idpFlowTask.setConfigParamsMd5(SecureUtil.md5((String)idpFlowTask.getConfigParams()));
        List inputParams = (List)flowTaskContext.flowTaskInputParamsMap.get(tagId);
        if (inputParams != null) {
            idpFlowTask.setIntputParams(JSONArray.parseArray((String)JSON.toJSONString((Object)inputParams)).toString());
            idpFlowTask.setIntputParamsMd5(SecureUtil.md5((String)idpFlowTask.getIntputParams()));
        }
        if ((o = flowTaskContext.flowTaskOutputParamsMap.get(tagId)) != null) {
            idpFlowTask.setOutputParams(JSON.toJSONString(o));
        } else {
            idpFlowTask.setOutputParams("{}");
        }
        List<JSONObject> results = flowTaskContext.flowTaskResultMap.get(tagId);
        if (results != null) {
            idpFlowTask.setResult(JSONArray.parseArray((String)JSON.toJSONString(results)).toString());
        } else {
            idpFlowTask.setResult("[{}]");
        }
        idpFlowTask.setResultCategoryId(idpFlowTag.getCategoryId());
        idpFlowTask.setEndTime(new Date());
        idpFlowTask.setDuration(Long.valueOf(idpFlowTask.getEndTime().getTime() - idpFlowTask.getStartTime().getTime()));
        Boolean isCache = (Boolean)flowTaskContext.flowTaskFromCache.get(tagId);
        if (isCache != null && isCache.booleanValue()) {
            idpFlowTask.setCache(FlowStateEnum.success.getCode());
        }
        return idpFlowTask;
    }

    private IdpFlowTag getIdpFlowTag(String tagId, FlowTaskContext flowTaskContext) {
        IdpFlowTag idpFlowTag = flowTaskContext.flowTagMap.get(tagId);
        if (idpFlowTag == null) {
            idpFlowTag = (IdpFlowTag)this.idpFlowTagService.getById((Serializable)((Object)tagId));
        }
        if (idpFlowTag == null) {
            throw new BusinessException("\u6d41\u7a0b\u6807\u7b7e[" + tagId + "]\u672a\u627e\u5230");
        }
        return idpFlowTag;
    }
}

