/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.domain.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.flow.convert.VueFlowConvert;
import com.jxdinfo.idp.flow.convert.bean.CmpProperty;
import com.jxdinfo.idp.flow.convert.bean.ELInfo;
import com.jxdinfo.idp.flow.convert.generator.ExpressGenerator;
import com.jxdinfo.idp.flow.parser.entity.FlowData;
import com.jxdinfo.idp.flow.parser.graph.Graph;
import com.jxdinfo.idp.flow.parser.graph.GraphInfo;
import com.jxdinfo.liteflow.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/idp/flow/el"})
@RestController
public class GenerateELController {
    private static final Logger log = LoggerFactory.getLogger(GenerateELController.class);
    @Autowired
    private ExpressGenerator expressGenerator;

    @PostMapping(value={"/generateJsonEL"})
    @ResponseBody
    public CmpProperty generateJsonEL(@Nullable @RequestBody ELInfo elInfo) {
        log.info("generateJsonEL \u6536\u5230\u6570\u636e: {}", (Object)JsonUtil.toJsonString((Object)elInfo));
        CmpProperty vo = new CmpProperty();
        try {
            vo = this.expressGenerator.generateJsonEL(elInfo);
        }
        catch (Exception ex) {
            log.error("-----", (Throwable)ex);
        }
        log.info("generateJsonEL \u751f\u6210\u6570\u636e: {}", (Object)JsonUtil.toJsonString((Object)vo));
        return vo;
    }

    @PostMapping(value={"/generateEL"})
    @ResponseBody
    public ELInfo generateEL(@Nullable @RequestBody CmpProperty jsonEl) {
        log.info("generateEL \u6536\u5230\u6570\u636e: {}", (Object)JsonUtil.toJsonString((Object)jsonEl));
        ELInfo vo = new ELInfo();
        try {
            vo = this.expressGenerator.generateEL(jsonEl);
        }
        catch (Exception ex) {
            log.error("-----", (Throwable)ex);
        }
        log.info("generateEL \u751f\u6210\u6570\u636e: {}", (Object)JsonUtil.toJsonString((Object)vo));
        return vo;
    }

    @PostMapping(value={"verifyELExpression"})
    public ApiResponse<Boolean> verifyELExpression(@Nullable @RequestBody CmpProperty jsonEl) {
        log.info("generateEL \u6536\u5230\u6570\u636e: {}", (Object)JsonUtil.toJsonString((Object)jsonEl));
        try {
            return ApiResponse.success((Object)this.expressGenerator.verifyELExpression(jsonEl));
        }
        catch (Exception e) {
            log.error("-----", (Throwable)e);
            return ApiResponse.success((Object)false);
        }
    }

    @PostMapping(value={"/jsonToEL"})
    public String jsonToEL(@RequestBody FlowData data) {
        try {
            Graph graph = new Graph(data);
            GraphInfo graphInfo = graph.toELInfo();
            return graphInfo.toString();
        }
        catch (Exception e) {
            log.error("-----", (Throwable)e);
            return e.getMessage();
        }
    }

    @PostMapping(value={"/elToJson"})
    public JSONObject elToJson(@RequestBody ELInfo elInfo) {
        VueFlowConvert convert = new VueFlowConvert();
        return convert.elToJson(elInfo);
    }
}

