/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.sql.util;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.thread.NamedThreadFactory;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.hutool.core.util.XmlUtil;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.parser.constant.ReadType;
import com.jxdinfo.liteflow.parser.sql.exception.ELSQLException;
import com.jxdinfo.liteflow.parser.sql.read.SqlReadFactory;
import com.jxdinfo.liteflow.parser.sql.read.vo.ScriptVO;
import com.jxdinfo.liteflow.parser.sql.vo.SQLParserVO;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JDBCHelper {
    private SQLParserVO sqlParserVO;
    private static final int CORE_POOL_SIZE = 2;
    private static LFLog LOG = LFLoggerManager.getLogger(JDBCHelper.class);
    private static ScheduledThreadPoolExecutor pollExecutor;
    private static JDBCHelper INSTANCE;

    public JDBCHelper() {
        JDBCHelper a;
    }

    public String getContent() {
        Object object = SqlReadFactory.getSqlRead(ReadType.CHAIN);
        Object object2 = SqlReadFactory.getSqlRead(ReadType.SCRIPT);
        object = object.read();
        Object object3 = new ArrayList();
        object.forEach(a2 -> {
            Object[] objectArray = new Object[4];
            objectArray[0] = XmlUtil.escape((String)a2.getChainId());
            objectArray[1] = StrUtil.emptyIfNull((CharSequence)a2.getNamespace());
            objectArray[2] = StrUtil.emptyIfNull((CharSequence)a2.getRoute());
            objectArray[3] = a2.getBody();
            object3.add(StrUtil.format((CharSequence)"<chain id=\"{}\" namespace=\"{}\"><route><![CDATA[{}]]></route><body><![CDATA[{}]]></body></chain>", (Object[])objectArray));
        });
        object3 = CollUtil.join(object3, (CharSequence)"");
        object2 = object2.read();
        Object object4 = new ArrayList();
        object2.forEach(a2 -> {
            ScriptVO scriptVO = a2;
            a2 = scriptVO.getNodeId();
            String string = scriptVO.getName();
            String string2 = scriptVO.getType();
            String string3 = scriptVO.getLanguage();
            String string4 = scriptVO.getScript();
            if (StringUtils.isNotBlank((String)scriptVO.getLanguage())) {
                Object[] objectArray = new Object[5];
                objectArray[0] = XmlUtil.escape((String)a2);
                objectArray[1] = XmlUtil.escape((String)string);
                objectArray[2] = string2;
                objectArray[3] = string3;
                objectArray[4] = string4;
                object4.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\" language=\"{}\"><![CDATA[{}]]></node>", (Object[])objectArray));
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = XmlUtil.escape((String)a2);
            objectArray[1] = XmlUtil.escape((String)string);
            objectArray[2] = string2;
            objectArray[3] = string4;
            object4.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>", (Object[])objectArray));
        });
        Object[] objectArray = new Object[1];
        objectArray[0] = CollUtil.join(object4, (CharSequence)"");
        object4 = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])objectArray);
        SqlReadFactory.getSqlReadPollTask(ReadType.CHAIN).initData(object);
        SqlReadFactory.getSqlReadPollTask(ReadType.SCRIPT).initData(object2);
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = object4;
        objectArray2[1] = object3;
        return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])objectArray2);
    }

    public static void setPollExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        ScheduledThreadPoolExecutor a;
        pollExecutor = a;
    }

    private /* synthetic */ void continue(SQLParserVO a) {
        a.sqlParserVO = a;
    }

    public static ScheduledThreadPoolExecutor getPollExecutor() {
        return pollExecutor;
    }

    public void listenSQL() {
        JDBCHelper a;
        pollExecutor.scheduleAtFixedRate(() -> {
            try {
                SqlReadFactory.getSqlReadPollTask(ReadType.SCRIPT).execute();
                SqlReadFactory.getSqlReadPollTask(ReadType.CHAIN).execute();
                return;
            }
            catch (Exception exception) {
                LOG.error(ScriptVO.while("\u0017U\fPFD\u0015L\u001eT@N\u0013W\b"), (Throwable)exception);
                return;
            }
        }, a.sqlParserVO.getPollingStartSeconds().longValue(), a.sqlParserVO.getPollingIntervalSeconds().longValue(), TimeUnit.SECONDS);
    }

    public static JDBCHelper getInstance() {
        return INSTANCE;
    }

    public static void init(SQLParserVO a) {
        try {
            INSTANCE = new JDBCHelper();
            if (StrUtil.isNotBlank((CharSequence)a.getDriverClassName())) {
                Class.forName(a.getDriverClassName());
            }
            INSTANCE.continue(a);
            if (a.getPollingEnabled().booleanValue() && ObjectUtil.isNull((Object)JDBCHelper.getPollExecutor())) {
                NamedThreadFactory namedThreadFactory = new NamedThreadFactory(ScriptVO.while("x pKw\u0012L\u0016N\u0013]M"), false);
                JDBCHelper.setPollExecutor(new ScheduledThreadPoolExecutor(2, (ThreadFactory)namedThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy()));
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ELSQLException(classNotFoundException);
        }
    }
}

