/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.sql.read;

import com.jxdinfo.liteflow.parser.constant.ReadType;
import com.jxdinfo.liteflow.parser.sql.polling.SqlReadPollTask;
import com.jxdinfo.liteflow.parser.sql.polling.impl.ChainReadPollTask;
import com.jxdinfo.liteflow.parser.sql.polling.impl.ScriptReadPollTask;
import com.jxdinfo.liteflow.parser.sql.read.SqlRead;
import com.jxdinfo.liteflow.parser.sql.read.impl.ChainRead;
import com.jxdinfo.liteflow.parser.sql.read.impl.ScriptRead;
import com.jxdinfo.liteflow.parser.sql.vo.SQLParserVO;
import java.util.HashMap;
import java.util.Map;

public class SqlReadFactory {
    private static final Map<ReadType, SqlRead<?>> READ_MAP = new HashMap();
    private static final Map<ReadType, SqlReadPollTask<?>> POLL_TASK_MAP = new HashMap();

    public static void registerSqlReadPollTask(ReadType a) {
        SqlRead sqlRead = SqlReadFactory.getSqlRead(a);
        if (ReadType.CHAIN.equals((Object)a)) {
            POLL_TASK_MAP.put(ReadType.CHAIN, new ChainReadPollTask((ChainRead)sqlRead));
            return;
        }
        if (ReadType.SCRIPT.equals((Object)a)) {
            POLL_TASK_MAP.put(ReadType.SCRIPT, new ScriptReadPollTask((ScriptRead)sqlRead));
        }
    }

    public static void registerRead(SQLParserVO sQLParserVO) {
        SQLParserVO a;
        READ_MAP.put(ReadType.CHAIN, new ChainRead(a));
        READ_MAP.put(ReadType.SCRIPT, new ScriptRead(a));
    }

    public static <T> SqlRead<T> getSqlRead(ReadType a) {
        return READ_MAP.get((Object)a);
    }

    public static <T> SqlReadPollTask<T> getSqlReadPollTask(ReadType a) {
        return POLL_TASK_MAP.get((Object)a);
    }

    public SqlReadFactory() {
        SqlReadFactory a;
    }
}

