/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.sql.read;

import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.parser.constant.SqlReadConstant;
import com.jxdinfo.liteflow.parser.sql.exception.ELSQLException;
import com.jxdinfo.liteflow.parser.sql.read.SqlRead;
import com.jxdinfo.liteflow.parser.sql.read.vo.ScriptVO;
import com.jxdinfo.liteflow.parser.sql.util.LiteFlowJdbcUtil;
import com.jxdinfo.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractSqlRead<T>
implements SqlRead<T> {
    private static LFLog LOG = LFLoggerManager.getLogger(AbstractSqlRead.class);
    public final SQLParserVO config;

    public boolean needRead() {
        return true;
    }

    public abstract boolean hasEnableFiled();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> read() {
        AbstractSqlRead a;
        if (!a.needRead()) {
            return new ArrayList();
        }
        AbstractSqlRead abstractSqlRead = a;
        abstractSqlRead.checkConfig();
        String string = abstractSqlRead.buildQuerySql();
        abstractSqlRead.synchronized(string);
        ArrayList<T> arrayList = new ArrayList<T>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = LiteFlowJdbcUtil.getConn(a.config);
            preparedStatement = connection.prepareStatement(string, 1003, 1007);
            PreparedStatement preparedStatement2 = preparedStatement;
            preparedStatement2.setFetchSize(SqlReadConstant.FETCH_SIZE_MAX);
            preparedStatement2.setString(1, a.config.getApplicationName());
            resultSet = preparedStatement2.executeQuery();
            block5: while (true) {
                ResultSet resultSet2 = resultSet;
                while (resultSet2.next()) {
                    boolean bl;
                    if (a.hasEnableFiled() && !(bl = a.getEnableFiledValue(resultSet))) {
                        resultSet2 = resultSet;
                        continue;
                    }
                    arrayList.add(a.parse(resultSet));
                    continue block5;
                }
                break;
            }
        }
        catch (Exception exception) {
            try {
                throw new ELSQLException(exception);
            }
            catch (Throwable throwable) {
                LiteFlowJdbcUtil.close(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        LiteFlowJdbcUtil.close(connection, preparedStatement, resultSet);
        return arrayList;
    }

    public abstract String buildQuerySql();

    public String getStringFromRs(ResultSet a, String a2) throws SQLException {
        return a.getString(a2);
    }

    public abstract void checkConfig();

    private /* synthetic */ void synchronized(String a) {
        AbstractSqlRead a2;
        if (!a2.config.getSqlLogEnabled().booleanValue()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(ScriptVO.while("\nU\u001fU\u0004\u0014\u001dZ\u001d\u0010P"));
        if (a2.config.hasEnableField()) {
            String string = StrUtil.replaceFirst((CharSequence)StrUtil.replaceFirst((CharSequence)a, (CharSequence)ScriptVO.while("O"), (CharSequence)new StringBuilder().insert(0, ScriptVO.while("W")).append(a2.config.getApplicationName()).append(ScriptVO.while("W")).toString()), (CharSequence)ScriptVO.while("O"), (CharSequence)Boolean.TRUE.toString());
            stringBuilder.append(string);
        } else {
            stringBuilder.append(a.replace(ScriptVO.while("O"), new StringBuilder().insert(0, ScriptVO.while("W")).append(a2.config.getApplicationName()).append(ScriptVO.while("W")).toString()));
        }
        LOG.debug(stringBuilder.toString());
    }

    public abstract boolean getEnableFiledValue(ResultSet var1) throws SQLException;

    public String getStringFromRsWithCheck(ResultSet a, String a2) throws SQLException {
        AbstractSqlRead a3;
        if (StrUtil.isBlank((CharSequence)(a = a3.getStringFromRs((ResultSet)a, a2)))) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            throw new ELSQLException(StrUtil.format((CharSequence)ScriptVO.while("E\u0010y*Y<b>z]L\u0001J\thwO\u000f\u000b\u0014@\u0007Q\u0006"), (Object[])objectArray));
        }
        return a;
    }

    public AbstractSqlRead(SQLParserVO a) {
        AbstractSqlRead a2;
        a2.config = a;
    }

    protected abstract T parse(ResultSet var1) throws SQLException;
}

