/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.sql;

import com.jxdinfo.hutool.core.bean.BeanUtil;
import com.jxdinfo.hutool.core.bean.copier.CopyOptions;
import com.jxdinfo.hutool.core.map.MapUtil;
import com.jxdinfo.hutool.core.text.StrFormatter;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.core.FlowInitHook;
import com.jxdinfo.liteflow.parser.constant.ReadType;
import com.jxdinfo.liteflow.parser.el.ClassXmlFlowELParser;
import com.jxdinfo.liteflow.parser.sql.exception.ELSQLException;
import com.jxdinfo.liteflow.parser.sql.read.SqlReadFactory;
import com.jxdinfo.liteflow.parser.sql.util.JDBCHelper;
import com.jxdinfo.liteflow.parser.sql.vo.SQLParserVO;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.property.LiteflowConfigGetter;
import com.jxdinfo.liteflow.util.JsonUtil;
import java.util.Map;
import java.util.Objects;

public class SQLXmlELParser
extends ClassXmlFlowELParser {
    private static SQLParserVO sqlParserVO;
    private static final String ERROR_MSG_PATTERN = "rule-source-ext-data {} is blank";
    private static final String ERROR_COMMON_MSG = "rule-source-ext-data is empty";

    public SQLXmlELParser() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        try {
            if (MapUtil.isNotEmpty((Map)liteflowConfig.getRuleSourceExtDataMap())) {
                sqlParserVO = (SQLParserVO)BeanUtil.toBean((Object)liteflowConfig.getRuleSourceExtDataMap(), SQLParserVO.class, (CopyOptions)CopyOptions.create());
            } else if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getRuleSourceExtData())) {
                sqlParserVO = (SQLParserVO)JsonUtil.parseObject((String)liteflowConfig.getRuleSourceExtData(), SQLParserVO.class);
            }
            if (Objects.isNull(sqlParserVO)) {
                throw new ELSQLException(ERROR_COMMON_MSG);
            }
            this.checkParserVO(sqlParserVO);
            JDBCHelper.init(sqlParserVO);
            SqlReadFactory.registerRead(sqlParserVO);
            SqlReadFactory.registerSqlReadPollTask(ReadType.CHAIN);
            SqlReadFactory.registerSqlReadPollTask(ReadType.SCRIPT);
        }
        catch (ELSQLException elsqlException) {
            throw elsqlException;
        }
        catch (Exception ex) {
            throw new ELSQLException(ex);
        }
    }

    public String parseCustom() {
        try {
            JDBCHelper jdbcHelper = JDBCHelper.getInstance();
            String content = jdbcHelper.getContent();
            if (sqlParserVO.getPollingEnabled().booleanValue()) {
                FlowInitHook.addHook(() -> {
                    jdbcHelper.listenSQL();
                    return true;
                });
            }
            return content;
        }
        catch (Exception ex) {
            throw new ELSQLException(ex);
        }
    }

    private void checkParserVO(SQLParserVO sqlParserVO) {
        if (sqlParserVO.isDefaultDataSource()) {
            return;
        }
        if (StrUtil.isEmpty((CharSequence)sqlParserVO.getUrl())) {
            throw new ELSQLException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"url"}));
        }
        if (StrUtil.isEmpty((CharSequence)sqlParserVO.getDriverClassName())) {
            throw new ELSQLException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"driverClassName"}));
        }
        if (Objects.isNull(sqlParserVO.getUsername())) {
            throw new ELSQLException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"username"}));
        }
        if (Objects.isNull(sqlParserVO.getPassword())) {
            throw new ELSQLException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"password"}));
        }
    }
}

