/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.sql.polling.impl;

import com.jxdinfo.liteflow.builder.LiteFlowNodeBuilder;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.flow.FlowBus;
import com.jxdinfo.liteflow.parser.constant.ReadType;
import com.jxdinfo.liteflow.parser.sql.polling.AbstractSqlReadPollTask;
import com.jxdinfo.liteflow.parser.sql.read.SqlRead;
import com.jxdinfo.liteflow.parser.sql.read.vo.ScriptVO;
import java.util.List;

public class ScriptReadPollTask
extends AbstractSqlReadPollTask<ScriptVO> {
    public ScriptReadPollTask(SqlRead<ScriptVO> read) {
        super(read);
    }

    @Override
    public void doSave(List<ScriptVO> saveElementList) {
        saveElementList.forEach(scriptVO -> LiteFlowNodeBuilder.createScriptNode().setId(scriptVO.getNodeId()).setType(NodeTypeEnum.getEnumByCode((String)scriptVO.getType())).setName(scriptVO.getName()).setScript(scriptVO.getScript()).setLanguage(scriptVO.getLanguage()).build());
    }

    @Override
    public void doDelete(List<String> deleteElementId) {
        for (String id : deleteElementId) {
            FlowBus.unloadScriptNode((String)id);
        }
    }

    @Override
    protected String getKey(ScriptVO scriptVO) {
        return scriptVO.getNodeId();
    }

    @Override
    protected String getValue(ScriptVO scriptVO) {
        return scriptVO.getScript();
    }

    @Override
    protected String getExtValue(ScriptVO scriptVO) {
        return "";
    }

    @Override
    public ReadType type() {
        return ReadType.SCRIPT;
    }
}

