/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.sql.util;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.thread.NamedThreadFactory;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.hutool.core.util.XmlUtil;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.parser.constant.ReadType;
import com.jxdinfo.liteflow.parser.sql.exception.ELSQLException;
import com.jxdinfo.liteflow.parser.sql.polling.SqlReadPollTask;
import com.jxdinfo.liteflow.parser.sql.read.SqlRead;
import com.jxdinfo.liteflow.parser.sql.read.SqlReadFactory;
import com.jxdinfo.liteflow.parser.sql.read.vo.ChainVO;
import com.jxdinfo.liteflow.parser.sql.read.vo.ScriptVO;
import com.jxdinfo.liteflow.parser.sql.vo.SQLParserVO;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class JDBCHelper {
    private SQLParserVO sqlParserVO;
    private static JDBCHelper INSTANCE;
    private static final int CORE_POOL_SIZE = 2;
    private static ScheduledThreadPoolExecutor pollExecutor;
    private static LFLog LOG;

    public static void init(SQLParserVO sqlParserVO) {
        try {
            INSTANCE = new JDBCHelper();
            if (StrUtil.isNotBlank((CharSequence)sqlParserVO.getDriverClassName())) {
                Class.forName(sqlParserVO.getDriverClassName());
            }
            INSTANCE.setSqlParserVO(sqlParserVO);
            if (sqlParserVO.getPollingEnabled().booleanValue() && ObjectUtil.isNull((Object)JDBCHelper.getPollExecutor())) {
                NamedThreadFactory namedThreadFactory = new NamedThreadFactory("SQL-Polling-", false);
                ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)namedThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
                JDBCHelper.setPollExecutor(threadPoolExecutor);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ELSQLException(e);
        }
    }

    public static JDBCHelper getInstance() {
        return INSTANCE;
    }

    public String getContent() {
        SqlRead chainRead = SqlReadFactory.getSqlRead(ReadType.CHAIN);
        SqlRead scriptRead = SqlReadFactory.getSqlRead(ReadType.SCRIPT);
        List<ChainVO> chainVOList = chainRead.read();
        ArrayList chainList = new ArrayList();
        chainVOList.forEach(chainVO -> chainList.add(StrUtil.format((CharSequence)"<chain id=\"{}\" namespace=\"{}\"><route><![CDATA[{}]]></route><body><![CDATA[{}]]></body></chain>", (Object[])new Object[]{XmlUtil.escape((String)chainVO.getChainId()), StrUtil.emptyIfNull((CharSequence)chainVO.getNamespace()), StrUtil.emptyIfNull((CharSequence)chainVO.getRoute()), chainVO.getBody()})));
        String chainsContent = CollUtil.join(chainList, (CharSequence)"");
        List<ScriptVO> scriptVOList = scriptRead.read();
        ArrayList scriptList = new ArrayList();
        scriptVOList.forEach(scriptVO -> {
            String id = scriptVO.getNodeId();
            String name = scriptVO.getName();
            String type = scriptVO.getType();
            String language = scriptVO.getLanguage();
            String elData = scriptVO.getScript();
            if (StringUtils.isNotBlank((String)scriptVO.getLanguage())) {
                scriptList.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\" language=\"{}\"><![CDATA[{}]]></node>", (Object[])new Object[]{XmlUtil.escape((String)id), XmlUtil.escape((String)name), type, language, elData}));
            } else {
                scriptList.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>", (Object[])new Object[]{XmlUtil.escape((String)id), XmlUtil.escape((String)name), type, elData}));
            }
        });
        String nodesContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptList, (CharSequence)"")});
        SqlReadPollTask<ChainVO> sqlReadPollTask4Chain = SqlReadFactory.getSqlReadPollTask(ReadType.CHAIN);
        sqlReadPollTask4Chain.initData(chainVOList);
        SqlReadPollTask<ScriptVO> sqlReadPollTask4Script = SqlReadFactory.getSqlReadPollTask(ReadType.SCRIPT);
        sqlReadPollTask4Script.initData(scriptVOList);
        return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{nodesContent, chainsContent});
    }

    public void listenSQL() {
        pollExecutor.scheduleAtFixedRate(() -> {
            try {
                SqlReadFactory.getSqlReadPollTask(ReadType.SCRIPT).execute();
                SqlReadFactory.getSqlReadPollTask(ReadType.CHAIN).execute();
            }
            catch (Exception ex) {
                LOG.error("poll chain fail", (Throwable)ex);
            }
        }, this.sqlParserVO.getPollingStartSeconds().longValue(), this.sqlParserVO.getPollingIntervalSeconds().longValue(), TimeUnit.SECONDS);
    }

    private void setSqlParserVO(SQLParserVO sqlParserVO) {
        this.sqlParserVO = sqlParserVO;
    }

    public static ScheduledThreadPoolExecutor getPollExecutor() {
        return pollExecutor;
    }

    public static void setPollExecutor(ScheduledThreadPoolExecutor pollExecutor) {
        JDBCHelper.pollExecutor = pollExecutor;
    }

    static {
        LOG = LFLoggerManager.getLogger(JDBCHelper.class);
    }
}

