/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.convert.factory;

import com.jxdinfo.idp.flow.convert.base.ExpressParser;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataLoop;
import com.jxdinfo.idp.flow.parser.entity.style.NodeStyle;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ExpressParserFactory {
    private static final Logger log = LoggerFactory.getLogger(ExpressParserFactory.class);
    public static final Map<String, ExpressParser> PARSER_MAP = new ConcurrentHashMap<String, ExpressParser>();

    public ExpressParserFactory() {
        ExpressParserFactory a;
    }

    @Autowired(required=false)
    public void setParsers(List<ExpressParser> a) {
        if (CollectionUtils.isNotEmpty(a)) {
            ExpressParserFactory a2;
            a.forEach(a2::register);
        }
    }

    public void register(ExpressParser a) {
        if (a.parserType() == null) {
            return;
        }
        Assert.notNull((Object)a, (String)NodeStyle.const("Q4l<{*z\u001f~=l\tN}}/l<z+)#k\t^}c0{hz6# k)y"));
        PARSER_MAP.put(a.parserType().getType(), a);
        log.info(NodeDataLoop.strictfp("t\u0019W\u0005B\u0004w\u0004T\u0017U\u0013U,J\u001c{Vz#FEU\u0002E\u001e\u001b\rI\u0003C\u0019"), (Object)a.parserType());
    }
}

