/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.convert.el;

import com.jxdinfo.hutool.core.collection.CollectionUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.flow.convert.base.AbstractExpressParser;
import com.jxdinfo.idp.flow.convert.bean.CmpProperty;
import com.jxdinfo.idp.flow.convert.bean.Properties;
import com.jxdinfo.idp.flow.convert.enums.ExpressParserEnum;
import com.jxdinfo.liteflow.enums.ConditionTypeEnum;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.IfCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class IfConditionParser
extends AbstractExpressParser {
    private final BiPredicate<String, String> caseMatcher = StringUtils::equals;

    @Override
    public ConditionTypeEnum parserType() {
        return ConditionTypeEnum.TYPE_IF;
    }

    @Override
    public CmpProperty builderCondition(Condition condition) {
        IfCondition ifCondition = (IfCondition)condition;
        Executable ifItem = ifCondition.getIfItem();
        CmpProperty vo = null;
        if (ifItem instanceof Condition) {
            vo = this.builderChildVO((Condition)ifItem);
        } else if (ifItem instanceof Node) {
            vo = Optional.of((Node)ifItem).map(this.nodeMapper).orElse(new CmpProperty());
        }
        return vo;
    }

    @Override
    public List<CmpProperty> builderChildren(Condition condition) {
        ArrayList<CmpProperty> children = new ArrayList<CmpProperty>();
        IfCondition ifCondition = (IfCondition)condition;
        Executable trueCaseExecutableItem = ifCondition.getTrueCaseExecutableItem();
        this.addChildList(trueCaseExecutableItem, children);
        Executable falseCaseExecutableItem = ifCondition.getFalseCaseExecutableItem();
        this.addChildList(falseCaseExecutableItem, children);
        return children;
    }

    private void addChildList(Executable item, List<CmpProperty> children) {
        if (ObjectUtil.isNull((Object)item)) {
            return;
        }
        if (ObjectUtil.isNotNull((Object)item)) {
            CmpProperty vo = null;
            if (item instanceof Condition) {
                vo = this.builderChildVO((Condition)item);
            } else if (item instanceof Node) {
                vo = Optional.of((Node)item).map(this.nodeMapper).orElse(new CmpProperty());
            }
            children.add(vo);
        }
    }

    @Override
    public String generateELMethod(CmpProperty jsonEl) {
        return "IF({},{})";
    }

    @Override
    public String generateCondition(CmpProperty jsonEl, String elExpress) {
        if (Objects.isNull(jsonEl.getCondition())) {
            return elExpress;
        }
        CmpProperty condition = jsonEl.getCondition();
        String nodeComponentId = "";
        nodeComponentId = StringUtils.equals((CharSequence)NodeTypeEnum.BOOLEAN.getMappingClazz().getSimpleName(), (CharSequence)condition.getType()) ? condition.getId() : this.generateNodeComponent(condition, nodeComponentId);
        return StrUtil.replaceFirst((CharSequence)elExpress, (CharSequence)"{}", (CharSequence)nodeComponentId);
    }

    @Override
    public String generateCmp(CmpProperty jsonEl, String elExpress) {
        if (CollectionUtil.isEmpty(jsonEl.getChildren()) || jsonEl.getChildren().isEmpty()) {
            return elExpress;
        }
        List<CmpProperty> children = jsonEl.getChildren();
        String caseNodeComponentId = "";
        if (1 == children.size()) {
            CmpProperty trueCaseVO = children.get(0);
            caseNodeComponentId = this.generateNodeComponent(trueCaseVO, caseNodeComponentId);
        } else if (2 == children.size()) {
            for (CmpProperty caseVO : children) {
                caseNodeComponentId = this.generateNodeComponent(caseVO, caseNodeComponentId);
                caseNodeComponentId = StrUtil.appendIfMissing((CharSequence)caseNodeComponentId, (CharSequence)",", (CharSequence[])new CharSequence[0]);
            }
            caseNodeComponentId = StringUtils.substringBeforeLast((String)caseNodeComponentId, (String)",");
        }
        return StrUtil.format((CharSequence)elExpress, (Object[])new Object[]{caseNodeComponentId});
    }

    @Override
    public String generateIdAndTag(CmpProperty jsonEl, String elExpress) {
        Properties properties = jsonEl.getProperties();
        if (Objects.isNull(properties)) {
            return elExpress;
        }
        String expressIdAndTag = "";
        if (StringUtils.isNotEmpty((CharSequence)properties.getId())) {
            expressIdAndTag = StrUtil.format((CharSequence)".id(\"{}\")", (Object[])new Object[]{properties.getId()});
        }
        if (StringUtils.isNotEmpty((CharSequence)properties.getTag())) {
            expressIdAndTag = expressIdAndTag + StrUtil.format((CharSequence)".tag(\"{}\")", (Object[])new Object[]{properties.getTag()});
        }
        return StrUtil.appendIfMissing((CharSequence)elExpress, (CharSequence)expressIdAndTag, (CharSequence[])new CharSequence[0]);
    }

    private CmpProperty andMapper(List<CmpProperty> voList) {
        return voList.stream().filter(vo -> this.caseMatcher.test(vo.getType(), "AND")).findFirst().orElse(null);
    }

    @Override
    public ExpressParserEnum getExpressType(Condition condition) {
        return ExpressParserEnum.IF;
    }
}

