/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.builder.el;

import com.jxdinfo.hutool.core.collection.CollectionUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.flow.builder.el.ELBus;
import com.jxdinfo.idp.flow.builder.el.ELWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParELWrapper
extends ELWrapper {
    private boolean any;
    private boolean ignoreError;
    private String customThreadExecutor;
    private final List<String> mustExecuteList;

    public ParELWrapper(ELWrapper ... elWrappers) {
        this.addWrapper(elWrappers);
        this.mustExecuteList = new ArrayList<String>();
    }

    public ParELWrapper par(Object ... objects) {
        ELWrapper[] elWrappers = ELBus.convertToNonBooleanOpt(objects);
        this.addWrapper(elWrappers);
        return this;
    }

    public ParELWrapper any(boolean any) {
        this.any = any;
        return this;
    }

    public ParELWrapper ignoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    public ParELWrapper customThreadExecutor(String customThreadExecutor) {
        this.customThreadExecutor = customThreadExecutor;
        return this;
    }

    public ParELWrapper must(String ... mustExecuteWrappers) {
        this.mustExecuteList.addAll(Arrays.asList(mustExecuteWrappers));
        return this;
    }

    @Override
    public ParELWrapper tag(String tag) {
        this.setTag(tag);
        return this;
    }

    @Override
    public ParELWrapper id(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public ParELWrapper maxWaitSeconds(Integer maxWaitSeconds) {
        this.setMaxWaitSeconds(maxWaitSeconds);
        return this;
    }

    public ParELWrapper retry(Integer count) {
        super.retry(count);
        return this;
    }

    public ParELWrapper retry(Integer count, String ... exceptions) {
        super.retry(count, exceptions);
        return this;
    }

    @Override
    protected String toEL(Integer depth, StringBuilder paramContext) {
        int i;
        Integer sonDepth = depth == null ? null : Integer.valueOf(depth + 1);
        StringBuilder sb = new StringBuilder();
        this.processWrapperTabs(sb, depth);
        sb.append("PAR(");
        this.processWrapperNewLine(sb, depth);
        for (i = 0; i < this.getElWrapperList().size(); ++i) {
            if (i > 0) {
                sb.append(",");
                this.processWrapperNewLine(sb, depth);
            }
            sb.append(this.getElWrapperList().get(i).toEL(sonDepth, paramContext));
        }
        this.processWrapperNewLine(sb, depth);
        this.processWrapperTabs(sb, depth);
        sb.append(")");
        if (this.any) {
            sb.append(".any(true)");
        }
        if (this.ignoreError) {
            sb.append(".ignoreError(true)");
        }
        if (StrUtil.isNotBlank((CharSequence)this.customThreadExecutor)) {
            sb.append(StrUtil.format((CharSequence)".threadPool(\"{}\")", (Object[])new Object[]{this.customThreadExecutor}));
        }
        if (CollectionUtil.isNotEmpty(this.mustExecuteList)) {
            if (this.any) {
                throw new IllegalArgumentException("'.must()' and '.any()' can use in when component at the same time!");
            }
            sb.append(".must(");
            for (i = 0; i < this.mustExecuteList.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(StrUtil.format((CharSequence)"\"{}\"", (Object[])new Object[]{this.mustExecuteList.get(i)}));
            }
            sb.append(")");
        }
        this.processWrapperProperty(sb, paramContext);
        return sb.toString();
    }
}

