/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.parser.enums.core;

import com.jxdinfo.idp.flow.parser.enums.core.DictItemBean;
import com.jxdinfo.idp.flow.parser.enums.core.StaticDictPool;

public interface IDictItem {
    public static <T extends IDictItem> T getByValue(Class<T> enumClass, String value) {
        if (enumClass == null) {
            return null;
        }
        for (IDictItem each : (IDictItem[])enumClass.getEnumConstants()) {
            if (!value.equals(each.value())) continue;
            return (T)each;
        }
        return null;
    }

    public static <T extends IDictItem> T getByLabel(Class<T> enumClass, String label) {
        if (enumClass == null) {
            return null;
        }
        for (IDictItem each : (IDictItem[])enumClass.getEnumConstants()) {
            if (!label.trim().equals(each.label())) continue;
            return (T)each;
        }
        return null;
    }

    public static <T extends IDictItem> String getLabelByValue(Class<T> enumClass, String value) {
        if (value == null) {
            return "";
        }
        T byValue = IDictItem.getByValue(enumClass, value);
        if (null == byValue) {
            return value;
        }
        return byValue.label();
    }

    public static <T extends IDictItem> String getValueByLabel(Class<T> enumClass, String label) {
        if (label == null) {
            return "";
        }
        T byValue = IDictItem.getByLabel(enumClass, label = label.trim());
        if (null == byValue) {
            return label;
        }
        return byValue.value();
    }

    public String name();

    default public String value() {
        return this.getItemBean().getValue();
    }

    default public Integer intValue() {
        return Integer.valueOf(this.getItemBean().getValue());
    }

    default public int toInt() {
        return Integer.parseInt(this.getItemBean().getValue());
    }

    default public boolean equalsVal(Object val) {
        String value = this.getItemBean().getValue();
        if (val instanceof String) {
            return value.equals(val.toString());
        }
        if (val instanceof Integer) {
            return Integer.parseInt(value) == (Integer)val;
        }
        return false;
    }

    default public String label() {
        return this.getItemBean().getLabel();
    }

    default public String reserve() {
        return this.getItemBean().getReserve();
    }

    default public DictItemBean getItemBean() {
        return StaticDictPool.getDictItem(this);
    }

    default public boolean isValue(String value) {
        return IDictItem.isNotEmpty(value) && value.endsWith(this.value());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !IDictItem.isEmpty(str);
    }
}

