/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.convert.el;

import com.jxdinfo.hutool.core.collection.CollectionUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.flow.convert.base.AbstractLoopExpressParser;
import com.jxdinfo.idp.flow.convert.bean.CmpProperty;
import com.jxdinfo.idp.flow.convert.bean.Properties;
import com.jxdinfo.idp.flow.convert.enums.ExpressParserEnum;
import com.jxdinfo.liteflow.enums.ConditionTypeEnum;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.WhileCondition;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class WhileConditionParser
extends AbstractLoopExpressParser {
    @Override
    public ConditionTypeEnum parserType() {
        return ConditionTypeEnum.TYPE_WHILE;
    }

    @Override
    public CmpProperty builderCondition(Condition condition) {
        WhileCondition whileCondition = (WhileCondition)condition;
        Executable whileItem = whileCondition.getWhileItem();
        CmpProperty vo = null;
        if (whileItem instanceof Condition) {
            vo = this.builderChildVO((Condition)whileItem);
        } else if (whileItem instanceof Node) {
            vo = Optional.of((Node)whileItem).map(this.nodeMapper).orElse(new CmpProperty());
        }
        return vo;
    }

    @Override
    public String generateELMethod(CmpProperty jsonEl) {
        return "WHILE({}).DO({})";
    }

    @Override
    public String generateCondition(CmpProperty jsonEl, String elExpress) {
        if (Objects.isNull(jsonEl.getCondition())) {
            return elExpress;
        }
        CmpProperty condition = jsonEl.getCondition();
        String nodeComponentId = "";
        nodeComponentId = StringUtils.equals((CharSequence)NodeTypeEnum.BOOLEAN.getMappingClazz().getSimpleName(), (CharSequence)condition.getType()) ? condition.getId() : this.generateNodeComponent(condition, nodeComponentId);
        return StrUtil.replaceFirst((CharSequence)elExpress, (CharSequence)"{}", (CharSequence)nodeComponentId);
    }

    @Override
    public String generateCmp(CmpProperty jsonEl, String elExpress) {
        if (CollectionUtil.isEmpty(jsonEl.getChildren())) {
            return elExpress;
        }
        CmpProperty doExpressVO = this.nonBreakMapper(jsonEl.getChildren());
        String doEL = this.generateDoEL(doExpressVO);
        return StrUtil.format((CharSequence)elExpress, (Object[])new Object[]{doEL});
    }

    @Override
    public String generateIdAndTag(CmpProperty jsonEl, String elExpress) {
        Properties properties = jsonEl.getProperties();
        if (Objects.isNull(properties)) {
            return elExpress;
        }
        String expressIdAndTag = "";
        if (StringUtils.isNotEmpty((CharSequence)properties.getId())) {
            expressIdAndTag = StrUtil.format((CharSequence)".id(\"{}\")", (Object[])new Object[]{properties.getId()});
        }
        if (StringUtils.isNotEmpty((CharSequence)properties.getTag())) {
            expressIdAndTag = expressIdAndTag + StrUtil.format((CharSequence)".tag(\"{}\")", (Object[])new Object[]{properties.getTag()});
        }
        return StrUtil.appendIfMissing((CharSequence)elExpress, (CharSequence)expressIdAndTag, (CharSequence[])new CharSequence[0]);
    }

    @Override
    public String generateBreak(CmpProperty jsonEl, String elExpress) {
        if (Objects.isNull(jsonEl.getChildren()) || jsonEl.getChildren().isEmpty()) {
            return elExpress;
        }
        CmpProperty breakVO = this.breakMapper(jsonEl.getChildren());
        if (Objects.isNull(breakVO)) {
            return elExpress;
        }
        CmpProperty breakNode = this.foundBreakNode(breakVO.getChildren());
        if (Objects.isNull(breakNode)) {
            return elExpress;
        }
        if (StringUtils.equals((CharSequence)NodeTypeEnum.BOOLEAN.getMappingClazz().getSimpleName(), (CharSequence)breakNode.getType())) {
            String breakEL = StrUtil.format((CharSequence)".BREAK({})", (Object[])new Object[]{breakNode.getId()});
            elExpress = elExpress + breakEL;
        }
        return elExpress;
    }

    @Override
    public ExpressParserEnum getExpressType(Condition condition) {
        return ExpressParserEnum.WHILE;
    }
}

