/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.parser.graph;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.flow.parser.entity.edge.Edge;
import com.jxdinfo.idp.flow.parser.entity.node.Node;
import com.jxdinfo.idp.flow.parser.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GraphUtil {
    public static List<List<Node>> getProcessSegments(List<List<Node>> allPaths, List<Node> segmentationPoints) {
        ArrayList<List<Node>> segments = new ArrayList<List<Node>>();
        try {
            LinkedHashSet<String> segmentPointsSet = new LinkedHashSet<String>();
            for (Node node2 : segmentationPoints) {
                segmentPointsSet.add(node2.id);
            }
            Map<String, Node> segmentationPointsMap = segmentationPoints.stream().collect(Collectors.toMap(Node::getId, node -> node));
            LinkedHashMap segmentsAfterSegmentPoint = new LinkedHashMap();
            LinkedHashMap segmentsBeforeSegmentPoint = new LinkedHashMap();
            for (Node point : segmentationPoints) {
                segmentsAfterSegmentPoint.put(point.id, new ArrayList());
            }
            Node firstNode = segmentationPoints.get(0);
            LinkedHashSet<Node> prevNodeSet = new LinkedHashSet<Node>();
            for (List<Node> path : allPaths) {
                String lastSegmentPointId = null;
                boolean flag = true;
                for (Node currentNode : path) {
                    if (flag && !currentNode.id.equals(firstNode.id)) {
                        prevNodeSet.add(currentNode);
                    }
                    if (currentNode.id.equals(firstNode.id)) {
                        flag = false;
                    }
                    if (segmentPointsSet.contains(currentNode.id)) {
                        lastSegmentPointId = currentNode.id;
                        continue;
                    }
                    if (lastSegmentPointId == null || ((List)segmentsAfterSegmentPoint.get(lastSegmentPointId)).contains(currentNode)) continue;
                    ((List)segmentsAfterSegmentPoint.get(lastSegmentPointId)).add(currentNode);
                }
            }
            if (!prevNodeSet.isEmpty()) {
                segments.add(new ArrayList(prevNodeSet));
            }
            for (String segmentPointId : segmentsAfterSegmentPoint.keySet()) {
                Node currNode = segmentationPointsMap.get(segmentPointId);
                segments.add(Collections.singletonList(currNode));
                List segmentNodes = (List)segmentsAfterSegmentPoint.get(segmentPointId);
                if (segmentNodes.isEmpty()) continue;
                segments.add(segmentNodes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return segments;
    }

    public static List<List<Node>> mergeSingleElementSegments(List<List<Node>> segments) {
        ArrayList<List<Node>> mergedSegments = new ArrayList<List<Node>>();
        if (segments == null || segments.isEmpty()) {
            return mergedSegments;
        }
        ArrayList<Node> currentSegment = new ArrayList<Node>();
        for (List<Node> segment : segments) {
            if (segment.size() == 1) {
                currentSegment.addAll(segment);
                continue;
            }
            if (!currentSegment.isEmpty()) {
                mergedSegments.add(new ArrayList(currentSegment));
                currentSegment.clear();
            }
            mergedSegments.add(new ArrayList<Node>(segment));
        }
        if (!currentSegment.isEmpty()) {
            mergedSegments.add(currentSegment);
        }
        return mergedSegments;
    }

    public static List<Node> findSegmentationPoints(List<List<Node>> paths, Map<String, Node> nodes) {
        LinkedHashMap<String, Integer> nodeCount = new LinkedHashMap<String, Integer>();
        for (List<Node> path : paths) {
            LinkedHashSet<String> uniqueNodes = new LinkedHashSet<String>();
            for (Node node : path) {
                uniqueNodes.add(node.getId());
            }
            uniqueNodes.forEach(id -> nodeCount.put((String)id, nodeCount.getOrDefault(id, 0) + 1));
        }
        ArrayList<Node> segmentationPoints = new ArrayList<Node>();
        int totalPaths = paths.size();
        nodeCount.forEach((id, count) -> {
            if (count == totalPaths) {
                segmentationPoints.add((Node)nodes.get(id));
            }
        });
        return segmentationPoints;
    }

    public static void dfs(String nodeId, Set<String> visited, Map<String, List<String>> adjList) {
        visited.add(nodeId);
        List<String> neighbors = adjList.get(nodeId);
        if (neighbors != null) {
            for (String neighbor : neighbors) {
                if (visited.contains(neighbor)) continue;
                GraphUtil.dfs(neighbor, visited, adjList);
            }
        }
    }

    public static void findPathsRecursive(String current, String end, List<Node> path, List<List<Node>> paths, Set<String> visited, Map<String, List<String>> adjList, Map<String, Node> nodes) {
        path.add(nodes.get(current));
        visited.add(current);
        if (current.equals(end)) {
            paths.add(new ArrayList<Node>(path));
        } else if (adjList.containsKey(current)) {
            for (String neighbor : adjList.get(current)) {
                if (visited.contains(neighbor)) continue;
                GraphUtil.findPathsRecursive(neighbor, end, path, paths, visited, adjList, nodes);
            }
        }
        path.remove(path.size() - 1);
        visited.remove(current);
    }

    public static void findAllPathsHelper(Node node, List<Node> path, List<List<Node>> allPaths, Map<String, List<String>> adjList, Map<String, Node> nodes) {
        path.add(node);
        if (!adjList.containsKey(node.getId()) || adjList.get(node.getId()).isEmpty()) {
            allPaths.add(new ArrayList<Node>(path));
        } else {
            for (String neighborId : adjList.get(node.getId())) {
                Node neighbor = nodes.get(neighborId);
                if (path.contains(neighbor)) continue;
                GraphUtil.findAllPathsHelper(neighbor, new ArrayList<Node>(path), allPaths, adjList, nodes);
            }
        }
        path.remove(node);
    }

    public static List<Node> getStartNodes(Set<String> targets, List<Node> nodes) {
        ArrayList<Node> startNodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (targets.contains(node.getId())) continue;
            startNodes.add(node);
        }
        if (startNodes.isEmpty()) {
            startNodes.addAll(nodes);
        }
        return startNodes;
    }

    public static List<Node> getEndNodes(Set<String> sources, List<Node> nodes) {
        ArrayList<Node> endNodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (sources.contains(node.getId())) continue;
            endNodes.add(node);
        }
        return endNodes;
    }

    public static boolean isSingle(Node node, List<Edge> edges) {
        for (Edge edge : edges) {
            if (!edge.getSource().equals(node.getId()) && !edge.getTarget().equals(node.getId())) continue;
            return false;
        }
        return true;
    }

    public static List<Node> startSameNode(List<List<Node>> allPaths) {
        ArrayList<Node> startNodes = new ArrayList<Node>();
        if (allPaths.isEmpty()) {
            return startNodes;
        }
        List<Node> firstPath = allPaths.get(0);
        for (Node node : firstPath) {
            boolean allContain = true;
            for (List<Node> path : allPaths) {
                if (path.contains(node)) continue;
                allContain = false;
                break;
            }
            if (!allContain) continue;
            startNodes.add(node);
        }
        return startNodes;
    }

    public static List<Node> excludeSameNode(List<List<Node>> allPaths, List<Node> excludeNodes) {
        List nodeList = allPaths.stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(excludeNodes)) {
            nodeList = nodeList.stream().filter(node -> !excludeNodes.contains(node)).collect(Collectors.toList());
        }
        return new ArrayList<Node>(new LinkedHashSet(nodeList));
    }

    public static List<List<List<Node>>> groupPathsByIntersection(List<List<Node>> allPaths) {
        ArrayList<List<List<Node>>> groupedPaths = new ArrayList<List<List<Node>>>();
        HashMap nodeToPathIndices = new HashMap();
        for (int i = 0; i < allPaths.size(); ++i) {
            List<Node> path = allPaths.get(i);
            for (Node node : path) {
                nodeToPathIndices.putIfAbsent(node, new HashSet());
                ((Set)nodeToPathIndices.get(node)).add(i);
            }
        }
        HashSet<Integer> visitedPathIndices = new HashSet<Integer>();
        for (int i = 0; i < allPaths.size(); ++i) {
            if (visitedPathIndices.contains(i)) continue;
            ArrayList group = new ArrayList();
            HashSet<Integer> currentGroupIndices = new HashSet<Integer>();
            currentGroupIndices.add(i);
            group.add(new ArrayList(allPaths.get(i)));
            visitedPathIndices.add(i);
            for (Node node : allPaths.get(i)) {
                if (!nodeToPathIndices.containsKey(node)) continue;
                for (Integer index : (Set)nodeToPathIndices.get(node)) {
                    if (visitedPathIndices.contains(index)) continue;
                    currentGroupIndices.add(index);
                    group.add(new ArrayList(allPaths.get(index)));
                    visitedPathIndices.add(index);
                }
            }
            groupedPaths.add(group);
        }
        return groupedPaths;
    }

    public static List<List<Node>> findAllPathByNodes(List<Node> nodes, Graph graph) {
        HashSet<Node> nodeSet = new HashSet<Node>(nodes);
        ArrayList<List<Node>> filteredPaths = new ArrayList<List<Node>>();
        HashSet<String> seenPaths = new HashSet<String>();
        Graph newGraph = new Graph(nodes, graph.getEdges(nodes));
        for (List<Node> originalPath : newGraph.getAllPaths()) {
            ArrayList<Node> path = new ArrayList<Node>();
            for (Node node : originalPath) {
                if (!nodeSet.contains(node)) continue;
                path.add(node);
            }
            String pathKey = path.stream().map(Node::getId).reduce("", (acc, id) -> acc + "-" + id);
            if (path.isEmpty() || !seenPaths.add(pathKey)) continue;
            filteredPaths.add(path);
        }
        return filteredPaths;
    }

    public static boolean isSingleNode(List<List<Node>> paths) {
        List list = paths.stream().flatMap(Collection::stream).collect(Collectors.toList());
        return CollUtil.isNotEmpty(list) && list.size() == 1;
    }

    public static Node getSingleNode(List<List<Node>> paths) {
        List list = paths.stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(list) && list.size() == 1) {
            return (Node)list.get(0);
        }
        return null;
    }
}

