/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.parser.graph;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.flow.builder.el.ELWrapper;
import com.jxdinfo.idp.flow.parser.entity.FlowData;
import com.jxdinfo.idp.flow.parser.entity.edge.Edge;
import com.jxdinfo.idp.flow.parser.entity.node.Node;
import com.jxdinfo.idp.flow.parser.enums.IvyEnums;
import com.jxdinfo.idp.flow.parser.execption.FlowELException;
import com.jxdinfo.idp.flow.parser.graph.GraphInfo;
import com.jxdinfo.idp.flow.parser.graph.GraphToEL;
import com.jxdinfo.idp.flow.parser.graph.GraphUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Graph {
    Map<String, List<String>> adjList = new LinkedHashMap<String, List<String>>();
    Map<String, List<String>> reverseAdjList = new LinkedHashMap<String, List<String>>();
    private String flowName;
    List<Node> allNodes = new ArrayList<Node>();
    List<Edge> allEdges = new ArrayList<Edge>();
    Map<String, Node> nodes = new LinkedHashMap<String, Node>();
    Set<String> sources = new LinkedHashSet<String>();
    Set<String> targets = new LinkedHashSet<String>();
    Set<String> sourceTargets = new LinkedHashSet<String>();
    Set<String> singleNodes = new LinkedHashSet<String>();
    List<Node> specialNodes = new ArrayList<Node>();
    Map<Node, List<Node>> specialNodeMap = new LinkedHashMap<Node, List<Node>>();
    List<Node> whenNodes;
    List<Node> startNodes;
    List<Node> endNodes;
    List<List<Node>> allPaths;
    List<List<List<Node>>> groupPaths;
    private FlowData data;

    public Graph() {
    }

    public Graph(FlowData data) {
        this.data = data;
        this.init(this.data);
    }

    public Graph(List<Node> nodes, List<Edge> edges) {
        this.allNodes = nodes;
        this.allEdges = edges;
        this.init(new FlowData(this.allNodes, this.allEdges));
    }

    public Graph(String flowName, List<Node> nodes, List<Edge> edges) {
        this.allNodes = nodes;
        this.allEdges = edges;
        this.flowName = flowName;
        this.init(new FlowData(this.allNodes, this.allEdges));
    }

    private boolean isFlowNode(Node node) {
        switch (node.getType()) {
            case "note": {
                return false;
            }
            case "context": {
                return false;
            }
        }
        return true;
    }

    private boolean isFlowEdge(Edge edge) {
        if (edge != null && edge.getData() != null) {
            switch (edge.getData().getType()) {
                case "note": {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    public void init(FlowData data) {
        this.allNodes = data.getNodes().stream().filter(this::isFlowNode).collect(Collectors.toList());
        this.allEdges = data.getEdges().stream().filter(this::isFlowEdge).collect(Collectors.toList());
        this.whenNodes = this.allNodes.stream().filter(m -> "when".equals(m.getType())).collect(Collectors.toList());
        this.allNodes.forEach(this::addNode);
        this.allEdges.forEach(this::addEdge);
        this.sources = this.allEdges.stream().map(Edge::getSource).collect(Collectors.toSet());
        this.targets = this.allEdges.stream().map(Edge::getTarget).collect(Collectors.toSet());
        this.sourceTargets = this.allEdges.stream().map(Edge::getSource).filter(this.allEdges.stream().map(Edge::getTarget).collect(Collectors.toSet())::contains).collect(Collectors.toSet());
        this.singleNodes = this.allNodes.stream().filter(this::isSingle).map(Node::getId).collect(Collectors.toSet());
        this.startNodes = this.getStartNodes();
        this.endNodes = this.getEndNodes();
        this.allPaths = this.findAllPaths();
        this.groupPaths = this.groupPathsByIntersection(this.allPaths);
        this.specialNodes = this.getSpecialNodes();
    }

    public void addNode(Node node) {
        this.adjList.putIfAbsent(node.getId(), new ArrayList());
        this.reverseAdjList.putIfAbsent(node.getId(), new ArrayList());
        this.nodes.put(node.getId(), node);
    }

    public void addEdge(Edge edge) {
        this.adjList.get(edge.getSource()).add(edge.getTarget());
        this.reverseAdjList.get(edge.getTarget()).add(edge.getSource());
    }

    public boolean isSingle(Node node) {
        return GraphUtil.isSingle(node, this.allEdges);
    }

    public List<Node> getNeighbors(Node node) {
        ArrayList<Node> neighbors = new ArrayList<Node>();
        List<String> neighborIds = this.adjList.get(node.getId());
        if (neighborIds != null) {
            for (String id : neighborIds) {
                neighbors.add(this.nodes.get(id));
            }
        }
        return neighbors;
    }

    public boolean isNeighbor(Node node1, Node node2) {
        List<String> neighbors = this.adjList.get(node1.getId());
        return neighbors != null && neighbors.contains(node2.getId());
    }

    public List<Node> getPrev(Node node) {
        ArrayList<Node> neighbors = new ArrayList<Node>();
        List<String> neighborIds = this.reverseAdjList.get(node.getId());
        if (neighborIds != null) {
            for (String id : neighborIds) {
                neighbors.add(this.nodes.get(id));
            }
        }
        return neighbors;
    }

    public boolean hasNextNode(Node node) {
        return CollUtil.isNotEmpty((Collection)this.adjList.get(node.getId()));
    }

    public List<Node> getStartNodes() {
        return GraphUtil.getStartNodes(this.targets, this.allNodes);
    }

    public List<Node> getEndNodes() {
        return GraphUtil.getEndNodes(this.sources, this.allNodes);
    }

    public List<Node> getSpecialNodes() {
        List edges = this.allEdges.stream().filter(m -> m.getData().isSpecialPath()).collect(Collectors.toList());
        Set targetNodeIdSet = edges.stream().map(Edge::getTarget).collect(Collectors.toSet());
        List nodes = this.allNodes.stream().filter(m -> targetNodeIdSet.contains(m.getId())).collect(Collectors.toList());
        HashSet nodeSet = new HashSet();
        for (Node node : nodes) {
            List<List<Node>> paths = this.findAllPaths(node);
            List nodeList = paths.stream().flatMap(Collection::stream).collect(Collectors.toList());
            nodeSet.addAll(nodeList);
        }
        return new ArrayList<Node>(nodeSet);
    }

    public List<List<List<Node>>> groupPathsByIntersection(List<List<Node>> allPaths) {
        return GraphUtil.groupPathsByIntersection(allPaths);
    }

    private List<Node> findAllPathsNodes(List<Node> startNodes) {
        List<List<Node>> paths = this.findAllPaths(startNodes);
        return paths.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<List<Node>> findAllPaths() {
        ArrayList<List<Node>> allPaths = new ArrayList<List<Node>>();
        List<Node> startNodes = this.getStartNodes();
        for (Node startNode : startNodes) {
            ArrayList<Node> visited = new ArrayList<Node>();
            GraphUtil.findAllPathsHelper(startNode, visited, allPaths, this.adjList, this.nodes);
        }
        return allPaths;
    }

    public List<List<Node>> findAllPaths(List<Node> startNodes) {
        ArrayList<List<Node>> allPaths = new ArrayList<List<Node>>();
        for (Node startNode : startNodes) {
            ArrayList<Node> visited = new ArrayList<Node>();
            GraphUtil.findAllPathsHelper(startNode, visited, allPaths, this.adjList, this.nodes);
        }
        return allPaths;
    }

    public List<List<Node>> findAllPaths(Node startNode) {
        ArrayList<List<Node>> allPaths = new ArrayList<List<Node>>();
        ArrayList<Node> visited = new ArrayList<Node>();
        GraphUtil.findAllPathsHelper(startNode, visited, allPaths, this.adjList, this.nodes);
        return allPaths;
    }

    public List<List<Node>> findAllPaths(Node startNode, boolean excludeStartNode) {
        List<List<Node>> allPaths = new ArrayList<List<Node>>();
        ArrayList<Node> visited = new ArrayList<Node>();
        GraphUtil.findAllPathsHelper(startNode, visited, allPaths, this.adjList, this.nodes);
        if (excludeStartNode) {
            allPaths = allPaths.stream().map(m -> m.stream().filter(n -> n != startNode).collect(Collectors.toList())).collect(Collectors.toList());
        }
        return allPaths;
    }

    public List<List<Node>> findAllPaths(Node startNode, Node endNode, boolean excludeStartNode, boolean excludeEndNode) {
        List<List<Node>> allPaths = this.findAllPaths(startNode.getId(), endNode.getId());
        if (excludeStartNode) {
            allPaths = allPaths.stream().map(m -> m.stream().filter(n -> n != startNode).collect(Collectors.toList())).collect(Collectors.toList());
        }
        if (excludeEndNode) {
            allPaths = allPaths.stream().map(m -> m.stream().filter(n -> n != endNode).collect(Collectors.toList())).collect(Collectors.toList());
        }
        return allPaths;
    }

    public List<List<Node>> findAllPaths(String startId, String endId) {
        ArrayList<List<Node>> paths = new ArrayList<List<Node>>();
        HashSet<String> visited = new HashSet<String>();
        GraphUtil.findPathsRecursive(startId, endId, new ArrayList<Node>(), paths, visited, this.adjList, this.nodes);
        return paths;
    }

    public List<List<Node>> getProcessSegments(String startId, String endId) {
        List<Node> segmentationPoints = GraphUtil.findSegmentationPoints(this.findAllPaths(startId, endId), this.nodes);
        HashSet<String> segmentPointsSet = new HashSet<String>();
        for (Node node : segmentationPoints) {
            segmentPointsSet.add(node.id);
        }
        segmentPointsSet.add(endId);
        HashMap<String, Node> visited = new HashMap<String, Node>();
        ArrayList<List<Node>> segments = new ArrayList<List<Node>>();
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.offer(this.nodes.get(startId));
        ArrayList<Node> currentSegment = new ArrayList<Node>();
        boolean isSegmentStart = true;
        while (!queue.isEmpty()) {
            List<String> neighbors;
            Node currentNode = (Node)queue.poll();
            if (visited.containsKey(currentNode.id)) continue;
            visited.put(currentNode.id, currentNode);
            if (segmentPointsSet.contains(currentNode.id)) {
                if (!currentSegment.isEmpty()) {
                    segments.add(new ArrayList(currentSegment));
                    currentSegment.clear();
                }
                segments.add(Collections.singletonList(currentNode));
                isSegmentStart = true;
            } else {
                if (isSegmentStart) {
                    isSegmentStart = false;
                    currentSegment = new ArrayList();
                }
                currentSegment.add(currentNode);
            }
            if ((neighbors = this.adjList.get(currentNode.id)) == null) continue;
            for (String neighbor : neighbors) {
                if (visited.containsKey(neighbor)) continue;
                queue.offer(this.nodes.get(neighbor));
            }
        }
        if (!currentSegment.isEmpty()) {
            segments.add(currentSegment);
        }
        return segments;
    }

    public ELWrapper toELWrapper() throws FlowELException {
        return GraphToEL.toEL(this);
    }

    public String toEL(boolean format) throws FlowELException {
        if (this.getAllNodes().isEmpty()) {
            return "";
        }
        return GraphToEL.toEL(this).toEL(format);
    }

    public Node findJoinNode(List<Node> startNodes) {
        if (startNodes == null || startNodes.isEmpty()) {
            return null;
        }
        HashMap<String, HashSet<String>> allPaths = new HashMap<String, HashSet<String>>();
        for (Node startNode : startNodes) {
            HashSet<String> visited = new HashSet<String>();
            GraphUtil.dfs(startNode.getId(), visited, this.adjList);
            allPaths.put(startNode.getId(), visited);
        }
        HashSet commonNodes = new HashSet((Collection)allPaths.values().iterator().next());
        for (Set path : allPaths.values()) {
            commonNodes.retainAll(path);
        }
        Iterator<Object> iterator = commonNodes.iterator();
        if (iterator.hasNext()) {
            String nodeId = (String)iterator.next();
            return this.nodes.get(nodeId);
        }
        return null;
    }

    public Node findJoinNode(Node startNode) {
        List<List<Node>> allPaths = this.findAllPaths(startNode);
        if (allPaths.size() > 1) {
            List<Node> segmentationPoints = GraphUtil.findSegmentationPoints(allPaths, this.getNodes());
            segmentationPoints.remove(startNode);
            return CollUtil.isNotEmpty(segmentationPoints) ? segmentationPoints.get(0) : null;
        }
        return null;
    }

    public List<Node> getNodes(String type) {
        return this.data.getNodes().stream().filter(m -> m.getType().equals(type)).collect(Collectors.toList());
    }

    public Edge getEdge(Node sourceNode, Node targetNode) {
        return this.getAllEdges().stream().filter(m -> m.getSource().equals(sourceNode.getId()) && m.getTarget().equals(targetNode.getId())).findFirst().orElse(null);
    }

    public List<Edge> getEdges(Node node, IvyEnums.PATH_ENUM path) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        List<Node> neighbors = this.getNeighbors(node);
        for (Node next : neighbors) {
            Edge edge = this.getEdge(node, next);
            if (!edge.getData().isPath(path)) continue;
            edges.add(edge);
        }
        return edges;
    }

    public List<Edge> getEdges(List<Node> nodes) {
        Set idSet = nodes.stream().map(Node::getId).collect(Collectors.toSet());
        return this.allEdges.stream().filter(m -> idSet.contains(m.getSource()) && idSet.contains(m.getTarget())).collect(Collectors.toList());
    }

    public boolean isSpecialPath(Node node) {
        Edge edge;
        List<Node> prevList = this.getPrev(node);
        if (prevList.size() == 1 && (edge = this.getEdge(prevList.get(0), node)) != null) {
            return edge.getData().isSpecialPath();
        }
        return false;
    }

    public boolean isSpecialPath(Node sourceNode, Node targetNode, IvyEnums.PATH_ENUM pathEnum) {
        Edge edge = this.getEdge(sourceNode, targetNode);
        if (edge != null) {
            return edge.getData().isSpecialPath();
        }
        return false;
    }

    public boolean isPath(Node sourceNode, Node targetNode, IvyEnums.PATH_ENUM pathEnum) {
        Edge edge = this.getEdge(sourceNode, targetNode);
        if (edge != null) {
            return edge.getData().isPath(pathEnum);
        }
        return false;
    }

    public List<Node> getSpecialPathNodes(Node node, IvyEnums.PATH_ENUM pathEnum) {
        List<List<Node>> allPathNodes = this.findAllPaths(node);
        LinkedHashSet<Node> nodeSet = new LinkedHashSet<Node>();
        for (List<Node> pathNodes : allPathNodes) {
            if (pathNodes.size() <= 1 || !this.isPath(pathNodes.get(0), pathNodes.get(1), pathEnum)) continue;
            nodeSet.addAll(pathNodes);
        }
        nodeSet.remove(node);
        return new ArrayList<Node>(nodeSet);
    }

    public Node getNode(String nodeId) {
        return this.getAllNodes().stream().filter(m -> m.getId().equals(nodeId)).findFirst().orElse(null);
    }

    public Graph getGraph() {
        HashSet<Node> nodeSet = new HashSet<Node>();
        ArrayList typeList = CollUtil.toList((Object[])new String[]{"subflow", "subvar", "router"});
        for (List<Node> list : this.allPaths) {
            if (typeList.contains(list.get(0).getType())) continue;
            nodeSet.addAll(list);
        }
        ArrayList<Node> nodeList = new ArrayList<Node>(nodeSet);
        return new Graph(nodeList, this.getEdges(nodeList));
    }

    public List<Graph> getSubFlowGraph() {
        LinkedHashMap<String, HashSet<Node>> nodeMap = new LinkedHashMap<String, HashSet<Node>>();
        for (List<Node> list : this.allPaths) {
            if (!"subflow".equals(list.get(0).getType())) continue;
            String chainName = list.get(0).getData().getNodeDataSubflow().getChainName();
            if (nodeMap.containsKey(chainName)) {
                ((Set)nodeMap.get(chainName)).addAll(new HashSet<Node>(list));
                continue;
            }
            nodeMap.put(chainName, new HashSet<Node>(list));
        }
        return nodeMap.entrySet().stream().map(m -> new Graph((String)m.getKey(), new ArrayList<Node>((Collection)m.getValue()), this.getEdges(new ArrayList<Node>((Collection)m.getValue())))).collect(Collectors.toList());
    }

    public List<Graph> getSubVarGraph() {
        LinkedHashMap<String, HashSet<Node>> nodeMap = new LinkedHashMap<String, HashSet<Node>>();
        for (List<Node> list : this.allPaths) {
            if (!"subvar".equals(list.get(0).getType())) continue;
            String varName = list.get(0).getData().getNodeDataSubvar().getVarName();
            if (nodeMap.containsKey(varName)) {
                ((Set)nodeMap.get(varName)).addAll(new HashSet<Node>(list));
                continue;
            }
            nodeMap.put(varName, new HashSet<Node>(list));
        }
        return nodeMap.entrySet().stream().map(m -> new Graph((String)m.getKey(), new ArrayList<Node>((Collection)m.getValue()), this.getEdges(new ArrayList<Node>((Collection)m.getValue())))).collect(Collectors.toList());
    }

    public Graph getRouterGraph() {
        LinkedHashMap<String, HashSet<Node>> nodeMap = new LinkedHashMap<String, HashSet<Node>>();
        for (List<Node> list : this.allPaths) {
            if (!"router".equals(list.get(0).getType())) continue;
            String namespace = list.get(0).getData().getNodeDataRouter().getNamespace();
            if (nodeMap.containsKey(namespace)) {
                ((Set)nodeMap.get(namespace)).addAll(new HashSet<Node>(list));
                continue;
            }
            nodeMap.put(namespace, new HashSet<Node>(list));
        }
        return nodeMap.entrySet().stream().map(m -> new Graph((String)m.getKey(), new ArrayList<Node>((Collection)m.getValue()), this.getEdges(new ArrayList<Node>((Collection)m.getValue())))).collect(Collectors.toList()).stream().findFirst().orElse(null);
    }

    public GraphInfo toELInfo() throws FlowELException {
        GraphInfo graphInfo = new GraphInfo();
        Graph mainGraph = this.getGraph();
        graphInfo.setMainGraph(mainGraph);
        graphInfo.setMainGraphELWrapper(mainGraph.toELWrapper());
        graphInfo.setMainELStr(mainGraph.toEL(this.data.getFormat()));
        List<Node> contextNode = this.getNodes("context");
        graphInfo.setContextList(contextNode.stream().map(m -> m.getData().getNodeDataContext()).collect(Collectors.toList()));
        List<Graph> subFlowGraphs = this.getSubFlowGraph();
        HashMap<String, ELWrapper> subFlowELWrapperMap = new HashMap<String, ELWrapper>();
        HashMap<String, String> subFlowELMap = new HashMap<String, String>();
        for (Graph subFlowGraph : subFlowGraphs) {
            subFlowELWrapperMap.put(subFlowGraph.getFlowName(), subFlowGraph.toELWrapper());
            subFlowELMap.put(subFlowGraph.getFlowName(), (this.data.getFormat() != false ? System.lineSeparator() : "") + subFlowGraph.toEL(this.data.getFormat()));
        }
        graphInfo.setSubFlowGraphs(subFlowGraphs);
        graphInfo.setSubFlowELWrapperMap(subFlowELWrapperMap);
        graphInfo.setSubFlowELMap(subFlowELMap);
        List<Graph> subVarGraphs = this.getSubVarGraph();
        HashMap<String, ELWrapper> subVarELWrapperMap = new HashMap<String, ELWrapper>();
        HashMap<String, String> subVarELMap = new HashMap<String, String>();
        for (Graph subVarGraph : subVarGraphs) {
            subVarELWrapperMap.put(subVarGraph.getFlowName(), subVarGraph.toELWrapper());
            subVarELMap.put(subVarGraph.getFlowName(), (this.data.getFormat() != false ? System.lineSeparator() : "") + subVarGraph.toEL(this.data.getFormat()));
        }
        graphInfo.setSubVarGraphs(subVarGraphs);
        graphInfo.setSubVarELWrapperMap(subVarELWrapperMap);
        graphInfo.setSubVarELMap(subVarELMap);
        Graph routerGraph = this.getRouterGraph();
        if (routerGraph != null) {
            graphInfo.setRouterGraph(routerGraph);
            graphInfo.setRouterELWrapper(routerGraph.toELWrapper());
            graphInfo.setRouterELStr(routerGraph.toEL(this.data.getFormat()));
            graphInfo.setRouterNamespace(routerGraph.getFlowName());
        }
        return graphInfo;
    }

    public Map<String, List<String>> getAdjList() {
        return this.adjList;
    }

    public Map<String, List<String>> getReverseAdjList() {
        return this.reverseAdjList;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public List<Node> getAllNodes() {
        return this.allNodes;
    }

    public List<Edge> getAllEdges() {
        return this.allEdges;
    }

    public Map<String, Node> getNodes() {
        return this.nodes;
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public Set<String> getSourceTargets() {
        return this.sourceTargets;
    }

    public Set<String> getSingleNodes() {
        return this.singleNodes;
    }

    public Map<Node, List<Node>> getSpecialNodeMap() {
        return this.specialNodeMap;
    }

    public List<Node> getWhenNodes() {
        return this.whenNodes;
    }

    public List<List<Node>> getAllPaths() {
        return this.allPaths;
    }

    public List<List<List<Node>>> getGroupPaths() {
        return this.groupPaths;
    }

    public FlowData getData() {
        return this.data;
    }

    public void setAdjList(Map<String, List<String>> adjList) {
        this.adjList = adjList;
    }

    public void setReverseAdjList(Map<String, List<String>> reverseAdjList) {
        this.reverseAdjList = reverseAdjList;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public void setAllNodes(List<Node> allNodes) {
        this.allNodes = allNodes;
    }

    public void setAllEdges(List<Edge> allEdges) {
        this.allEdges = allEdges;
    }

    public void setNodes(Map<String, Node> nodes) {
        this.nodes = nodes;
    }

    public void setSources(Set<String> sources) {
        this.sources = sources;
    }

    public void setTargets(Set<String> targets) {
        this.targets = targets;
    }

    public void setSourceTargets(Set<String> sourceTargets) {
        this.sourceTargets = sourceTargets;
    }

    public void setSingleNodes(Set<String> singleNodes) {
        this.singleNodes = singleNodes;
    }

    public void setSpecialNodes(List<Node> specialNodes) {
        this.specialNodes = specialNodes;
    }

    public void setSpecialNodeMap(Map<Node, List<Node>> specialNodeMap) {
        this.specialNodeMap = specialNodeMap;
    }

    public void setWhenNodes(List<Node> whenNodes) {
        this.whenNodes = whenNodes;
    }

    public void setStartNodes(List<Node> startNodes) {
        this.startNodes = startNodes;
    }

    public void setEndNodes(List<Node> endNodes) {
        this.endNodes = endNodes;
    }

    public void setAllPaths(List<List<Node>> allPaths) {
        this.allPaths = allPaths;
    }

    public void setGroupPaths(List<List<List<Node>>> groupPaths) {
        this.groupPaths = groupPaths;
    }

    public void setData(FlowData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Graph)) {
            return false;
        }
        Graph other = (Graph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<String>> this$adjList = this.getAdjList();
        Map<String, List<String>> other$adjList = other.getAdjList();
        if (this$adjList == null ? other$adjList != null : !((Object)this$adjList).equals(other$adjList)) {
            return false;
        }
        Map<String, List<String>> this$reverseAdjList = this.getReverseAdjList();
        Map<String, List<String>> other$reverseAdjList = other.getReverseAdjList();
        if (this$reverseAdjList == null ? other$reverseAdjList != null : !((Object)this$reverseAdjList).equals(other$reverseAdjList)) {
            return false;
        }
        String this$flowName = this.getFlowName();
        String other$flowName = other.getFlowName();
        if (this$flowName == null ? other$flowName != null : !this$flowName.equals(other$flowName)) {
            return false;
        }
        List<Node> this$allNodes = this.getAllNodes();
        List<Node> other$allNodes = other.getAllNodes();
        if (this$allNodes == null ? other$allNodes != null : !((Object)this$allNodes).equals(other$allNodes)) {
            return false;
        }
        List<Edge> this$allEdges = this.getAllEdges();
        List<Edge> other$allEdges = other.getAllEdges();
        if (this$allEdges == null ? other$allEdges != null : !((Object)this$allEdges).equals(other$allEdges)) {
            return false;
        }
        Map<String, Node> this$nodes = this.getNodes();
        Map<String, Node> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        Set<String> this$sources = this.getSources();
        Set<String> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        Set<String> this$targets = this.getTargets();
        Set<String> other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        Set<String> this$sourceTargets = this.getSourceTargets();
        Set<String> other$sourceTargets = other.getSourceTargets();
        if (this$sourceTargets == null ? other$sourceTargets != null : !((Object)this$sourceTargets).equals(other$sourceTargets)) {
            return false;
        }
        Set<String> this$singleNodes = this.getSingleNodes();
        Set<String> other$singleNodes = other.getSingleNodes();
        if (this$singleNodes == null ? other$singleNodes != null : !((Object)this$singleNodes).equals(other$singleNodes)) {
            return false;
        }
        List<Node> this$specialNodes = this.getSpecialNodes();
        List<Node> other$specialNodes = other.getSpecialNodes();
        if (this$specialNodes == null ? other$specialNodes != null : !((Object)this$specialNodes).equals(other$specialNodes)) {
            return false;
        }
        Map<Node, List<Node>> this$specialNodeMap = this.getSpecialNodeMap();
        Map<Node, List<Node>> other$specialNodeMap = other.getSpecialNodeMap();
        if (this$specialNodeMap == null ? other$specialNodeMap != null : !((Object)this$specialNodeMap).equals(other$specialNodeMap)) {
            return false;
        }
        List<Node> this$whenNodes = this.getWhenNodes();
        List<Node> other$whenNodes = other.getWhenNodes();
        if (this$whenNodes == null ? other$whenNodes != null : !((Object)this$whenNodes).equals(other$whenNodes)) {
            return false;
        }
        List<Node> this$startNodes = this.getStartNodes();
        List<Node> other$startNodes = other.getStartNodes();
        if (this$startNodes == null ? other$startNodes != null : !((Object)this$startNodes).equals(other$startNodes)) {
            return false;
        }
        List<Node> this$endNodes = this.getEndNodes();
        List<Node> other$endNodes = other.getEndNodes();
        if (this$endNodes == null ? other$endNodes != null : !((Object)this$endNodes).equals(other$endNodes)) {
            return false;
        }
        List<List<Node>> this$allPaths = this.getAllPaths();
        List<List<Node>> other$allPaths = other.getAllPaths();
        if (this$allPaths == null ? other$allPaths != null : !((Object)this$allPaths).equals(other$allPaths)) {
            return false;
        }
        List<List<List<Node>>> this$groupPaths = this.getGroupPaths();
        List<List<List<Node>>> other$groupPaths = other.getGroupPaths();
        if (this$groupPaths == null ? other$groupPaths != null : !((Object)this$groupPaths).equals(other$groupPaths)) {
            return false;
        }
        FlowData this$data = this.getData();
        FlowData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Graph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<String>> $adjList = this.getAdjList();
        result = result * 59 + ($adjList == null ? 43 : ((Object)$adjList).hashCode());
        Map<String, List<String>> $reverseAdjList = this.getReverseAdjList();
        result = result * 59 + ($reverseAdjList == null ? 43 : ((Object)$reverseAdjList).hashCode());
        String $flowName = this.getFlowName();
        result = result * 59 + ($flowName == null ? 43 : $flowName.hashCode());
        List<Node> $allNodes = this.getAllNodes();
        result = result * 59 + ($allNodes == null ? 43 : ((Object)$allNodes).hashCode());
        List<Edge> $allEdges = this.getAllEdges();
        result = result * 59 + ($allEdges == null ? 43 : ((Object)$allEdges).hashCode());
        Map<String, Node> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        Set<String> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        Set<String> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        Set<String> $sourceTargets = this.getSourceTargets();
        result = result * 59 + ($sourceTargets == null ? 43 : ((Object)$sourceTargets).hashCode());
        Set<String> $singleNodes = this.getSingleNodes();
        result = result * 59 + ($singleNodes == null ? 43 : ((Object)$singleNodes).hashCode());
        List<Node> $specialNodes = this.getSpecialNodes();
        result = result * 59 + ($specialNodes == null ? 43 : ((Object)$specialNodes).hashCode());
        Map<Node, List<Node>> $specialNodeMap = this.getSpecialNodeMap();
        result = result * 59 + ($specialNodeMap == null ? 43 : ((Object)$specialNodeMap).hashCode());
        List<Node> $whenNodes = this.getWhenNodes();
        result = result * 59 + ($whenNodes == null ? 43 : ((Object)$whenNodes).hashCode());
        List<Node> $startNodes = this.getStartNodes();
        result = result * 59 + ($startNodes == null ? 43 : ((Object)$startNodes).hashCode());
        List<Node> $endNodes = this.getEndNodes();
        result = result * 59 + ($endNodes == null ? 43 : ((Object)$endNodes).hashCode());
        List<List<Node>> $allPaths = this.getAllPaths();
        result = result * 59 + ($allPaths == null ? 43 : ((Object)$allPaths).hashCode());
        List<List<List<Node>>> $groupPaths = this.getGroupPaths();
        result = result * 59 + ($groupPaths == null ? 43 : ((Object)$groupPaths).hashCode());
        FlowData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "Graph(adjList=" + this.getAdjList() + ", reverseAdjList=" + this.getReverseAdjList() + ", flowName=" + this.getFlowName() + ", allNodes=" + this.getAllNodes() + ", allEdges=" + this.getAllEdges() + ", nodes=" + this.getNodes() + ", sources=" + this.getSources() + ", targets=" + this.getTargets() + ", sourceTargets=" + this.getSourceTargets() + ", singleNodes=" + this.getSingleNodes() + ", specialNodes=" + this.getSpecialNodes() + ", specialNodeMap=" + this.getSpecialNodeMap() + ", whenNodes=" + this.getWhenNodes() + ", startNodes=" + this.getStartNodes() + ", endNodes=" + this.getEndNodes() + ", allPaths=" + this.getAllPaths() + ", groupPaths=" + this.getGroupPaths() + ", data=" + this.getData() + ")";
    }
}

