/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.parser.bus;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.flow.builder.el.AndELWrapper;
import com.jxdinfo.idp.flow.builder.el.CatchELWrapper;
import com.jxdinfo.idp.flow.builder.el.ELWrapper;
import com.jxdinfo.idp.flow.builder.el.FinallyELWrapper;
import com.jxdinfo.idp.flow.builder.el.IfELWrapper;
import com.jxdinfo.idp.flow.builder.el.LoopELWrapper;
import com.jxdinfo.idp.flow.builder.el.NodeELWrapper;
import com.jxdinfo.idp.flow.builder.el.NotELWrapper;
import com.jxdinfo.idp.flow.builder.el.OrELWrapper;
import com.jxdinfo.idp.flow.builder.el.ParELWrapper;
import com.jxdinfo.idp.flow.builder.el.PreELWrapper;
import com.jxdinfo.idp.flow.builder.el.SerELWrapper;
import com.jxdinfo.idp.flow.builder.el.SwitchELWrapper;
import com.jxdinfo.idp.flow.builder.el.ThenELWrapper;
import com.jxdinfo.idp.flow.builder.el.WhenELWrapper;
import com.jxdinfo.idp.flow.parser.bus.ELBusIf;
import com.jxdinfo.idp.flow.parser.bus.ELBusNode;
import com.jxdinfo.idp.flow.parser.bus.ELBusSwitch;
import com.jxdinfo.idp.flow.parser.bus.ELBusThen;
import com.jxdinfo.idp.flow.parser.entity.node.Node;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataBase;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataLoop;
import com.jxdinfo.idp.flow.parser.execption.FlowELException;
import com.jxdinfo.idp.flow.parser.graph.Graph;
import com.jxdinfo.idp.flow.parser.wrapper.ELBusWrapper;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class BaseELBus {
    public static void eLWrapperConvert(ELWrapper eLWrapper, Node node) throws FlowELException {
        if (eLWrapper instanceof ThenELWrapper) {
            BaseELBus.eLWrapperConvert(eLWrapper, BaseELBus.buildNode(node), null);
        } else if (eLWrapper instanceof WhenELWrapper) {
            BaseELBus.eLWrapperConvert(eLWrapper, BaseELBus.buildNode(node), null);
        }
    }

    public static void eLWrapperConvert(ELWrapper eLWrapper, ELWrapper eLWrapper2, CatchELWrapper catchELWrapper) throws FlowELException {
        if (catchELWrapper != null) {
            if (eLWrapper instanceof ThenELWrapper) {
                ((ThenELWrapper)eLWrapper).then(catchELWrapper);
            } else if (eLWrapper instanceof WhenELWrapper) {
                ((WhenELWrapper)eLWrapper).when(catchELWrapper);
            }
        } else {
            if (eLWrapper2 == null) {
                throw new FlowELException("EL\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (eLWrapper instanceof ThenELWrapper) {
                ((ThenELWrapper)eLWrapper).then(eLWrapper2);
            } else if (eLWrapper instanceof WhenELWrapper) {
                ((WhenELWrapper)eLWrapper).when(eLWrapper2);
            }
        }
    }

    public static ELWrapper buildNode(Node node) throws FlowELException {
        String type;
        switch (type = node.getType()) {
            case "common": {
                return ELBusNode.node(node);
            }
            case "switch": {
                return ELBusSwitch.node(node);
            }
            case "if": {
                return ELBusIf.node(node);
            }
            case "chain": {
                return ELBusWrapper.chain(node);
            }
        }
        return ELBusThen.then();
    }

    public static ELWrapper buildELWrapper(Node node, Graph graph) throws FlowELException {
        boolean hasNextNode = graph.hasNextNode(node);
        if (hasNextNode || graph.getNodes().size() == 1 && "common".equals(node.getType())) {
            return ELBusThen.then();
        }
        return BaseELBus.buildNode(node);
    }

    protected static void setDoOpt(ELWrapper wrapper, Node node) {
    }

    protected static void setDoOpt(ELWrapper wrapper, Object doOpt) {
        if (wrapper instanceof CatchELWrapper) {
            CatchELWrapper elWrapper = (CatchELWrapper)wrapper;
            elWrapper.doOpt(doOpt);
        }
    }

    protected static void setId(ELWrapper wrapper, Node node) {
        NodeDataBase nodeDataBase = node.getData().getNodeDataBase();
        if (nodeDataBase != null && StrUtil.isNotEmpty((CharSequence)nodeDataBase.getId())) {
            BaseELBus.setId(wrapper, nodeDataBase.getId());
        }
    }

    protected static void setId(ELWrapper wrapper, String id) {
        if (StrUtil.isNotBlank((CharSequence)id)) {
            if (wrapper instanceof NodeELWrapper) {
                ((NodeELWrapper)wrapper).id(id);
            } else if (wrapper instanceof AndELWrapper) {
                ((AndELWrapper)wrapper).id(id);
            } else if (wrapper instanceof CatchELWrapper) {
                ((CatchELWrapper)wrapper).id(id);
            } else if (wrapper instanceof FinallyELWrapper) {
                ((FinallyELWrapper)wrapper).id(id);
            } else if (wrapper instanceof PreELWrapper) {
                ((PreELWrapper)wrapper).id(id);
            } else if (wrapper instanceof NotELWrapper) {
                ((NotELWrapper)wrapper).id(id);
            } else if (wrapper instanceof OrELWrapper) {
                ((OrELWrapper)wrapper).id(id);
            } else if (wrapper instanceof WhenELWrapper) {
                ((WhenELWrapper)wrapper).id(id);
            } else if (wrapper instanceof ThenELWrapper) {
                ((ThenELWrapper)wrapper).id(id);
            } else if (wrapper instanceof LoopELWrapper) {
                ((LoopELWrapper)wrapper).id(id);
            } else if (wrapper instanceof IfELWrapper) {
                ((IfELWrapper)wrapper).id(id);
            } else if (wrapper instanceof ParELWrapper) {
                ((ParELWrapper)wrapper).id(id);
            } else if (wrapper instanceof SerELWrapper) {
                ((SerELWrapper)wrapper).id(id);
            } else if (wrapper instanceof SwitchELWrapper) {
                ((SwitchELWrapper)wrapper).id(id);
            }
        }
    }

    protected static void setTag(ELWrapper wrapper, Node node) {
        NodeDataBase nodeDataBase = node.getData().getNodeDataBase();
        if (nodeDataBase != null && StrUtil.isNotEmpty((CharSequence)nodeDataBase.getTag())) {
            BaseELBus.setTag(wrapper, nodeDataBase.getTag());
        }
    }

    protected static void setTag(ELWrapper wrapper, String tag) {
        if (StrUtil.isNotBlank((CharSequence)tag)) {
            if (wrapper instanceof NodeELWrapper) {
                ((NodeELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof AndELWrapper) {
                ((AndELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof CatchELWrapper) {
                ((CatchELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof FinallyELWrapper) {
                ((FinallyELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof PreELWrapper) {
                ((PreELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof NotELWrapper) {
                ((NotELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof OrELWrapper) {
                ((OrELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof WhenELWrapper) {
                ((WhenELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof ThenELWrapper) {
                ((ThenELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof LoopELWrapper) {
                ((LoopELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof IfELWrapper) {
                ((IfELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof ParELWrapper) {
                ((ParELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof SerELWrapper) {
                ((SerELWrapper)wrapper).tag(tag);
            } else if (wrapper instanceof SwitchELWrapper) {
                ((SwitchELWrapper)wrapper).tag(tag);
            }
        }
    }

    protected static void setParallel(ELWrapper wrapper, Node node) {
        NodeDataLoop nodeDataLoop = node.getData().getNodeDataLoop();
        if (nodeDataLoop != null && nodeDataLoop.getParallel() != null) {
            BaseELBus.setParallel(wrapper, nodeDataLoop.getParallel());
        }
    }

    protected static void setParallel(ELWrapper wrapper, Boolean parallel) {
        if (wrapper instanceof LoopELWrapper) {
            ((LoopELWrapper)wrapper).parallel(parallel);
        }
    }

    protected static void setRetry(ELWrapper wrapper, Node node) {
        NodeDataBase nodeDataBase = node.getData().getNodeDataBase();
        if (nodeDataBase != null && nodeDataBase.getRetryCount() != null) {
            if (ArrayUtil.isNotEmpty((Object[])nodeDataBase.getRetryExceptions())) {
                BaseELBus.setRetry(wrapper, nodeDataBase.getRetryCount(), nodeDataBase.getRetryExceptions());
            } else {
                BaseELBus.setRetry(wrapper, nodeDataBase.getRetryCount());
            }
        }
    }

    protected static void setRetry(ELWrapper wrapper, Integer retryCount) {
        if (wrapper instanceof NodeELWrapper) {
            ((NodeELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof CatchELWrapper) {
            ((CatchELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof PreELWrapper) {
            ((PreELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof WhenELWrapper) {
            ((WhenELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof ThenELWrapper) {
            ((ThenELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof LoopELWrapper) {
            ((LoopELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof FinallyELWrapper) {
            ((FinallyELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof IfELWrapper) {
            ((IfELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof ParELWrapper) {
            ((ParELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof SerELWrapper) {
            ((SerELWrapper)wrapper).retry(retryCount);
        } else if (wrapper instanceof SwitchELWrapper) {
            ((SwitchELWrapper)wrapper).retry(retryCount);
        }
    }

    protected static void setRetry(ELWrapper wrapper, Integer retryCount, String[] retryExceptions) {
        if (wrapper instanceof NodeELWrapper) {
            ((NodeELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof CatchELWrapper) {
            ((CatchELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof PreELWrapper) {
            ((PreELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof WhenELWrapper) {
            ((WhenELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof ThenELWrapper) {
            ((ThenELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof LoopELWrapper) {
            ((LoopELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof FinallyELWrapper) {
            ((FinallyELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof IfELWrapper) {
            ((IfELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof ParELWrapper) {
            ((ParELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof SerELWrapper) {
            ((SerELWrapper)wrapper).retry(retryCount, retryExceptions);
        } else if (wrapper instanceof SwitchELWrapper) {
            ((SwitchELWrapper)wrapper).retry(retryCount, retryExceptions);
        }
    }

    protected static void setMaxWaitSeconds(ELWrapper wrapper, Node node) {
        NodeDataBase nodeDataBase = node.getData().getNodeDataBase();
        if (nodeDataBase != null && nodeDataBase.getMaxWaitSeconds() != null) {
            BaseELBus.setMaxWaitSeconds(wrapper, nodeDataBase.getMaxWaitSeconds());
        }
    }

    protected static void setMaxWaitSeconds(ELWrapper wrapper, Integer maxWaitSeconds) {
        if (wrapper instanceof NodeELWrapper) {
            ((NodeELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
        } else if (!(wrapper instanceof AndELWrapper)) {
            if (wrapper instanceof CatchELWrapper) {
                ((CatchELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
            } else if (wrapper instanceof PreELWrapper) {
                ((PreELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
            } else if (!(wrapper instanceof NotELWrapper) && !(wrapper instanceof OrELWrapper)) {
                if (wrapper instanceof WhenELWrapper) {
                    ((WhenELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
                } else if (wrapper instanceof ThenELWrapper) {
                    ((ThenELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
                } else if (wrapper instanceof LoopELWrapper) {
                    ((LoopELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
                } else if (wrapper instanceof IfELWrapper) {
                    ((IfELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
                } else if (wrapper instanceof ParELWrapper) {
                    ((ParELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
                } else if (wrapper instanceof SerELWrapper) {
                    ((SerELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
                } else if (wrapper instanceof SwitchELWrapper) {
                    ((SwitchELWrapper)wrapper).maxWaitSeconds(maxWaitSeconds);
                }
            }
        }
    }

    protected static void setData(NodeELWrapper wrapper, Node node) throws FlowELException {
        NodeDataBase nodeDataBase = node.getData().getNodeDataBase();
        if (nodeDataBase != null) {
            boolean dataNameIsBlank = StrUtil.isBlank((CharSequence)nodeDataBase.getDataName());
            boolean dataIsBlank = StrUtil.isBlank((CharSequence)nodeDataBase.getData());
            if (dataNameIsBlank && !dataIsBlank) {
                throw new FlowELException("\u7ec4\u4ef6\u53c2\u6570\u540d\u79f0\u672a\u8bbe\u7f6e\uff01");
            }
            if (!dataNameIsBlank && dataIsBlank) {
                throw new FlowELException("\u7ec4\u4ef6\u53c2\u6570\u6570\u636e\u672a\u8bbe\u7f6e\uff01");
            }
            if (!dataNameIsBlank) {
                BaseELBus.setData(wrapper, nodeDataBase.getDataName(), nodeDataBase.getData());
            }
        }
    }

    protected static void setData(NodeELWrapper wrapper, String dataName, String jsonData) throws FlowELException {
        if (StrUtil.isNotEmpty((CharSequence)jsonData)) {
            jsonData = jsonData.trim();
            try {
                if (jsonData.startsWith("{") && jsonData.endsWith("}")) {
                    Gson gson = new Gson();
                    Type type = new TypeToken<Map<String, Object>>(){}.getType();
                    Object object = gson.fromJson(jsonData, type);
                } else if (jsonData.startsWith("[") && jsonData.endsWith("]")) {
                    Gson gson = new Gson();
                    Type type = new TypeToken<List<Map<String, Object>>>(){}.getType();
                    Object object = gson.fromJson(jsonData, type);
                }
            }
            catch (Exception e) {
                System.err.println("ELBusNode: Invalid JSON format.");
                System.err.println("dataName: " + dataName);
                System.err.println("jsonData: " + jsonData);
                throw new FlowELException("ELBusNode: Invalid JSON format." + System.lineSeparator() + "dataName: " + dataName + System.lineSeparator() + "jsonData: " + jsonData);
            }
            wrapper.data(dataName, jsonData);
        }
    }

    protected static void setData(NodeELWrapper wrapper, String dataName, Object data) {
        if (data != null) {
            wrapper.data(dataName, data);
        }
    }

    protected static void setData(NodeELWrapper wrapper, String dataName, Map<String, Object> jsonMap) {
        if (CollUtil.isNotEmpty(jsonMap)) {
            wrapper.data(dataName, (Map)jsonMap);
        }
    }
}

