/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.parser.builder;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.flow.convert.bean.CmpProperty;
import com.jxdinfo.idp.flow.parser.builder.FlowBuilder;
import com.jxdinfo.idp.flow.parser.entity.FlowData;
import com.jxdinfo.idp.flow.parser.entity.Viewport;
import com.jxdinfo.idp.flow.parser.entity.edge.Edge;
import com.jxdinfo.idp.flow.parser.entity.edge.EdgeData;
import com.jxdinfo.idp.flow.parser.entity.node.Node;
import com.jxdinfo.idp.flow.parser.entity.node.NodeData;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataBase;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataIf;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataSwitch;
import com.jxdinfo.idp.flow.parser.entity.node.Position;
import com.jxdinfo.idp.flow.parser.entity.style.NodeStyle;
import com.jxdinfo.idp.flow.parser.entity.style.NodeStyleHandles;
import com.jxdinfo.idp.flow.parser.entity.style.NodeStyleToolbar;
import java.util.ArrayList;
import java.util.UUID;

public class VueFlowBuilder
implements FlowBuilder {
    private FlowData flowData = new FlowData();

    @Override
    public FlowBuilder defaultData() {
        this.flowData.setNodes(new ArrayList<Node>());
        this.flowData.setEdges(new ArrayList<Edge>());
        this.flowData.setPosition(CollUtil.toList((Object[])new Double[]{0.0, 0.0}));
        this.flowData.setZoom(1.0);
        this.flowData.setViewport(new Viewport(0.0, 0.0, 1.0));
        return this;
    }

    @Override
    public FlowBuilder addNode(Node node) {
        this.flowData.getNodes().add(node);
        return this;
    }

    @Override
    public FlowBuilder addEdge(Node sourceNode, Node targetNode) {
        this.flowData.getEdges().add(VueFlowBuilder.buildEdge(sourceNode, targetNode));
        return this;
    }

    @Override
    public FlowBuilder format(boolean format) {
        this.flowData.setFormat(format);
        return this;
    }

    @Override
    public JSONObject build() {
        return (JSONObject)JSONObject.toJSON((Object)this.flowData);
    }

    private static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static Node buildNode(CmpProperty property) {
        String nodeId = property.getId();
        Node node = new Node();
        node.setId(UUID.randomUUID().toString());
        node.setType("common");
        node.setLabel(nodeId);
        node.setPosition(new Position(0.0, 0.0));
        NodeData nodeData = new NodeData();
        nodeData.setId(nodeId);
        nodeData.setName(nodeId);
        nodeData.setType("common");
        nodeData.setMode("default");
        nodeData.setNodeDataBase(new NodeDataBase());
        nodeData.setNodeDataSwitch(new NodeDataSwitch());
        nodeData.setNodeDataIf(new NodeDataIf());
        NodeStyle nodeStyle = new NodeStyle();
        nodeStyle.setToolbar(new NodeStyleToolbar("top", false, 10));
        ArrayList<NodeStyleHandles> handles = new ArrayList<NodeStyleHandles>();
        handles.add(new NodeStyleHandles(UUID.randomUUID().toString(), "left", 1.0, "target", ""));
        handles.add(new NodeStyleHandles(UUID.randomUUID().toString(), "right", 1.0, "source", ""));
        handles.add(new NodeStyleHandles(UUID.randomUUID().toString(), "top", 0.0, "target", ""));
        handles.add(new NodeStyleHandles(UUID.randomUUID().toString(), "bottom", 0.0, "source", ""));
        nodeStyle.setHandles(handles);
        nodeStyle.setExtendHandles(new ArrayList<NodeStyleHandles>());
        nodeData.setStyle(nodeStyle);
        node.setData(nodeData);
        node.setParentNode(null);
        node.setInitialized(false);
        property.setNode(node);
        return node;
    }

    public static Edge buildEdge(CmpProperty source, CmpProperty target) {
        return VueFlowBuilder.buildEdge(source.getNode(), target.getNode());
    }

    public static Edge buildEdge(Node source, Node target) {
        Edge edge = new Edge();
        edge.setId(VueFlowBuilder.uuid());
        edge.setType("animation");
        edge.setSource(source.getId());
        edge.setTarget(target.getId());
        edge.setData(new EdgeData());
        edge.setLabel("");
        edge.setAnimated(true);
        edge.setUpdatable(true);
        edge.setMarkerEnd("arrowclosed");
        return edge;
    }
}

