/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.convert.selector;

import com.jxdinfo.idp.flow.convert.base.ExpressParser;
import com.jxdinfo.idp.flow.convert.factory.ExpressParserFactory;
import com.jxdinfo.liteflow.enums.ConditionTypeEnum;
import com.jxdinfo.liteflow.flow.element.Condition;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class ParserSelector {
    private static final Function<String, ExpressParser> expressParserMapper = parserType -> Optional.ofNullable(parserType).map(ExpressParserFactory.PARSER_MAP::get).orElse(null);
    private static final BiPredicate<String, String> keyMatcher = StringUtils::equals;
    private static final Predicate<String> andOrOptMatcher = key -> StringUtils.contains((CharSequence)ConditionTypeEnum.TYPE_AND_OR_OPT.getType(), (CharSequence)key);

    public static ExpressParser getParser(String type) {
        return ParserSelector.foundMatchParserType(type).map(expressParserMapper).orElseThrow(RuntimeException::new);
    }

    public static <T extends Condition> ExpressParser getParser(T condition) {
        return ParserSelector.foundMatchParserType(condition).map(expressParserMapper).orElseThrow(RuntimeException::new);
    }

    private static <T extends Condition> Optional<String> foundMatchParserType(T condition) {
        for (String key : ExpressParserFactory.PARSER_MAP.keySet()) {
            String parserType;
            if (keyMatcher.test(key, parserType = condition.getConditionType().getType())) {
                return Optional.of(key);
            }
            if (!andOrOptMatcher.test(parserType)) continue;
            return Optional.of(key);
        }
        return Optional.empty();
    }

    private static Optional<String> foundMatchParserType(String type) {
        for (String key : ExpressParserFactory.PARSER_MAP.keySet()) {
            if (keyMatcher.test(key, type)) {
                return Optional.of(key);
            }
            if (!andOrOptMatcher.test(type)) continue;
            return Optional.of(key);
        }
        return Optional.empty();
    }
}

