/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.convert.factory;

import com.jxdinfo.idp.flow.convert.base.ExpressParser;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ExpressParserFactory {
    private static final Logger log = LoggerFactory.getLogger(ExpressParserFactory.class);
    public static final Map<String, ExpressParser> PARSER_MAP = new ConcurrentHashMap<String, ExpressParser>();

    @Autowired(required=false)
    public void setParsers(List<ExpressParser> parsers) {
        if (CollectionUtils.isNotEmpty(parsers)) {
            parsers.forEach(this::register);
        }
    }

    public void register(ExpressParser parser) {
        if (parser.parserType() == null) {
            return;
        }
        Assert.notNull((Object)parser, (String)"ExpressParser parser must not be null");
        PARSER_MAP.put(parser.parserType().getType(), parser);
        log.info("ExpressParser[{}] has been found", (Object)parser.parserType());
    }
}

