/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.convert.base;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.flow.convert.base.AbstractExpressParser;
import com.jxdinfo.idp.flow.convert.bean.CmpProperty;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.LoopCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLoopExpressParser
extends AbstractExpressParser {
    private Map<String, List<Executable>> executableGroup = new HashMap<String, List<Executable>>();
    protected final BiPredicate<String, String> breakMatcher = StringUtils::equals;

    @Override
    public List<CmpProperty> builderChildren(Condition condition) {
        Executable breakItem;
        ArrayList<CmpProperty> children = new ArrayList<CmpProperty>();
        LoopCondition loopCondition = (LoopCondition)condition;
        this.executableGroup = loopCondition.getExecutableGroup();
        Executable executableItem = this.getDoExecutor();
        if (ObjectUtil.isNotNull((Object)executableItem) && executableItem instanceof Condition) {
            CmpProperty vo = this.builderChildVO((Condition)executableItem);
            children.add(vo);
        }
        if (ObjectUtil.isNotNull((Object)(breakItem = this.getBreakItem())) && breakItem instanceof Node) {
            CmpProperty breakVO = new CmpProperty();
            breakVO.setType("BREAK");
            ArrayList<CmpProperty> breakChildren = new ArrayList<CmpProperty>();
            CmpProperty vo = Optional.of((Node)breakItem).map(this.nodeMapper).orElse(new CmpProperty());
            breakChildren.add(vo);
            breakVO.setChildren(breakChildren);
            children.add(breakVO);
        }
        return children;
    }

    protected Executable getBreakItem() {
        return this.getExecutableOne("BREAK_KEY");
    }

    protected Executable getDoExecutor() {
        return this.getExecutableOne("DO_KEY");
    }

    protected Executable getExecutableOne(String groupKey) {
        List<Executable> list = this.getExecutableList(groupKey);
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    protected List<Executable> getExecutableList(String groupKey) {
        List<Executable> executableList = this.executableGroup.get(groupKey);
        if (CollUtil.isEmpty(executableList)) {
            executableList = new ArrayList<Executable>();
        }
        return executableList;
    }

    @Override
    public String generateELEnd(CmpProperty jsonEl, String elExpress) {
        elExpress = this.generateBreak(jsonEl, elExpress);
        return StrUtil.appendIfMissing((CharSequence)elExpress, (CharSequence)";", (CharSequence[])new CharSequence[0]);
    }

    protected String generateDoEL(CmpProperty doExpressVO) {
        return this.abstractGenerateEL(doExpressVO);
    }

    protected CmpProperty breakMapper(List<CmpProperty> voList) {
        return voList.stream().filter(vo -> this.breakMatcher.test(vo.getType(), "BREAK")).findFirst().orElse(null);
    }

    protected CmpProperty nonBreakMapper(List<CmpProperty> voList) {
        return voList.stream().filter(vo -> !this.breakMatcher.test(vo.getType(), "BREAK")).findFirst().orElse(null);
    }

    public abstract String generateBreak(CmpProperty var1, String var2);

    protected CmpProperty foundBreakNode(List<CmpProperty> children) {
        if (CollUtil.isEmpty(children)) {
            return null;
        }
        return children.get(0);
    }
}

