/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.parser.graph;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.flow.builder.el.AndELWrapper;
import com.jxdinfo.idp.flow.builder.el.CatchELWrapper;
import com.jxdinfo.idp.flow.builder.el.ELBus;
import com.jxdinfo.idp.flow.builder.el.ELWrapper;
import com.jxdinfo.idp.flow.builder.el.IfELWrapper;
import com.jxdinfo.idp.flow.builder.el.LoopELWrapper;
import com.jxdinfo.idp.flow.builder.el.OrELWrapper;
import com.jxdinfo.idp.flow.builder.el.SwitchELWrapper;
import com.jxdinfo.idp.flow.builder.el.ThenELWrapper;
import com.jxdinfo.idp.flow.builder.el.WhenELWrapper;
import com.jxdinfo.idp.flow.parser.bus.BaseELBus;
import com.jxdinfo.idp.flow.parser.bus.ELBusAnd;
import com.jxdinfo.idp.flow.parser.bus.ELBusCatch;
import com.jxdinfo.idp.flow.parser.bus.ELBusFor;
import com.jxdinfo.idp.flow.parser.bus.ELBusIf;
import com.jxdinfo.idp.flow.parser.bus.ELBusIterator;
import com.jxdinfo.idp.flow.parser.bus.ELBusNode;
import com.jxdinfo.idp.flow.parser.bus.ELBusNot;
import com.jxdinfo.idp.flow.parser.bus.ELBusSwitch;
import com.jxdinfo.idp.flow.parser.bus.ELBusThen;
import com.jxdinfo.idp.flow.parser.bus.ELBusWhile;
import com.jxdinfo.idp.flow.parser.entity.edge.Edge;
import com.jxdinfo.idp.flow.parser.entity.node.Node;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataThen;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataWhen;
import com.jxdinfo.idp.flow.parser.enums.IvyEnums;
import com.jxdinfo.idp.flow.parser.execption.FlowELException;
import com.jxdinfo.idp.flow.parser.graph.FlowInfo;
import com.jxdinfo.idp.flow.parser.graph.Graph;
import com.jxdinfo.idp.flow.parser.graph.GraphUtil;
import com.jxdinfo.idp.flow.parser.wrapper.ELBusWrapper;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GraphToEL {
    /*
     * WARNING - void declaration
     */
    public static ELWrapper toEL(Graph graph) throws FlowELException {
        List<List<List<Node>>> groupPaths;
        if (graph.getNodes().size() == 1) {
            void var4_7;
            Node node = graph.getAllNodes().get(0);
            String type = node.getType();
            String string = type;
            int n = -1;
            switch (string.hashCode()) {
                case -1354814997: {
                    if (!string.equals("common")) break;
                    boolean bl = false;
                    break;
                }
                case -889473228: {
                    if (!string.equals("switch")) break;
                    boolean bl = true;
                }
            }
            switch (var4_7) {
                case 0: {
                    return ELBusThen.node(node);
                }
                case 1: {
                    return ELBusSwitch.node(node);
                }
            }
        }
        if ((groupPaths = graph.getGroupPaths()).size() == 1) {
            ELWrapper elWrapper = BaseELBus.buildELWrapper(graph.getStartNodes().get(0), graph);
            elWrapper = GraphToEL.processSegments(elWrapper, graph, groupPaths.get(0), true);
            return elWrapper;
        }
        if (groupPaths.size() > 1) {
            WhenELWrapper whenELWrapper = ELBus.when(new ELWrapper[0]);
            for (List list : groupPaths) {
                ELWrapper elWrapper = BaseELBus.buildELWrapper((Node)((List)list.get(0)).get(0), graph);
                GraphToEL.processSegments(elWrapper, graph, list, true);
                whenELWrapper.when(elWrapper);
            }
            return whenELWrapper;
        }
        return ELBus.then(new ELWrapper[0]);
    }

    private static void groupPath(ELWrapper whenELWrapper, Graph graph, List<List<List<Node>>> groupPaths, boolean filterSpecialPath) throws FlowELException {
    }

    private static ELWrapper processSegments(ELWrapper eLWrapper, Graph graph, List<List<Node>> allPaths, boolean filterSpecialPath) throws FlowELException {
        block15: {
            List whenNodeList;
            Set allNodeSet;
            block14: {
                Node startNode;
                int i;
                allNodeSet = allPaths.stream().flatMap(Collection::stream).collect(Collectors.toSet());
                List<Node> segmentationPoints = GraphUtil.findSegmentationPoints(allPaths, graph.getNodes());
                List<List<Node>> processSegments = GraphUtil.getProcessSegments(allPaths, segmentationPoints);
                List<List<Node>> segments = GraphUtil.mergeSingleElementSegments(processSegments);
                for (List<Node> items : segments) {
                    FlowInfo flowInfo = GraphToEL.flow(eLWrapper, graph, items, filterSpecialPath);
                    if (flowInfo == null) continue;
                    Node node = flowInfo.getNode();
                    String type = node.getType();
                    if ("then".equalsIgnoreCase(type) || "when".equalsIgnoreCase(type)) break;
                    if (!"router".equalsIgnoreCase(type)) continue;
                    return GraphToEL.getBooleanELWrapper(graph, node);
                }
                List thenNodeList = segmentationPoints.stream().filter(m -> "then".equalsIgnoreCase(m.getType())).collect(Collectors.toList());
                whenNodeList = segmentationPoints.stream().filter(m -> "when".equalsIgnoreCase(m.getType())).collect(Collectors.toList());
                if (!CollUtil.isNotEmpty(thenNodeList)) break block14;
                boolean isFirstNode = false;
                for (i = 0; i < thenNodeList.size(); ++i) {
                    boolean flag;
                    startNode = (Node)thenNodeList.get(i);
                    List<Node> prev = graph.getPrev(startNode);
                    if (allNodeSet.containsAll(prev)) {
                        isFirstNode = true;
                        break;
                    }
                    boolean bl = flag = CollUtil.isEmpty(prev) || !allNodeSet.containsAll(prev);
                    if (!flag) continue;
                    isFirstNode = true;
                    break;
                }
                for (i = 0; i < thenNodeList.size(); ++i) {
                    startNode = (Node)thenNodeList.get(i);
                    Integer endIndex = i + 1 >= thenNodeList.size() ? null : Integer.valueOf(i + 1);
                    Node endNode = endIndex != null ? (Node)thenNodeList.get(endIndex) : null;
                    boolean isCatch = GraphToEL.isCatchProcess(startNode);
                    ThenELWrapper thenELWrapper = ELBus.then(new ELWrapper[0]);
                    if (eLWrapper instanceof ThenELWrapper && !isCatch && !isFirstNode) {
                        thenELWrapper = (ThenELWrapper)eLWrapper;
                    }
                    GraphToEL.thenProcess(thenELWrapper, startNode);
                    List<List<Node>> allPathList = null;
                    if (endNode != null) {
                        allPathList = graph.findAllPaths(startNode, endNode, true, true);
                    } else {
                        allPathList = graph.findAllPaths(startNode, true);
                        allPathList = allPathList.stream().map(m -> m.stream().filter(allNodeSet::contains).collect(Collectors.toList())).collect(Collectors.toList());
                    }
                    GraphToEL.processSegments(thenELWrapper, graph, allPathList, true);
                    if (eLWrapper instanceof ThenELWrapper && !isCatch && !isFirstNode) continue;
                    CatchELWrapper catchELWrapper = GraphToEL.catchProcess(thenELWrapper, startNode);
                    BaseELBus.eLWrapperConvert(eLWrapper, thenELWrapper, catchELWrapper);
                }
                break block15;
            }
            if (!CollUtil.isNotEmpty(whenNodeList)) break block15;
            for (int i = 0; i < whenNodeList.size(); ++i) {
                Node endNode1;
                Node startNode = (Node)whenNodeList.get(i);
                Integer endIndex = i + 1 >= whenNodeList.size() ? null : Integer.valueOf(i + 1);
                Node endNode = endIndex != null ? (Node)whenNodeList.get(endIndex) : null;
                WhenELWrapper whenELWrapper = ELBus.when(new ELWrapper[0]);
                GraphToEL.whenProcess(whenELWrapper, startNode);
                List<List<Node>> allPathList = null;
                boolean flag = false;
                Node joinNode = graph.findJoinNode(startNode);
                if (joinNode != null && joinNode != endNode) {
                    endNode = joinNode;
                    flag = true;
                }
                allPathList = endNode != null ? graph.findAllPaths(startNode, endNode, true, true) : graph.findAllPaths(startNode, true);
                List<List<List<Node>>> groupPaths = GraphUtil.groupPathsByIntersection(allPathList);
                for (List<List<Node>> paths : groupPaths) {
                    if (GraphUtil.isSingleNode(paths)) {
                        BaseELBus.eLWrapperConvert(whenELWrapper, GraphUtil.getSingleNode(paths));
                        continue;
                    }
                    ThenELWrapper thenELWrapper = ELBus.then(new ELWrapper[0]);
                    GraphToEL.processSegments(thenELWrapper, graph, paths, true);
                    whenELWrapper.when(thenELWrapper);
                }
                CatchELWrapper catchELWrapper = GraphToEL.catchProcess(whenELWrapper, startNode);
                BaseELBus.eLWrapperConvert(eLWrapper, whenELWrapper, catchELWrapper);
                if (!flag) continue;
                Node node = endNode1 = endIndex != null ? (Node)whenNodeList.get(endIndex) : null;
                if (endNode1 != null) {
                    allPathList = graph.findAllPaths(joinNode, endNode1, false, true);
                } else if (joinNode != null) {
                    allPathList = graph.findAllPaths(joinNode, false);
                    allPathList = allPathList.stream().map(m -> m.stream().filter(allNodeSet::contains).collect(Collectors.toList())).collect(Collectors.toList());
                }
                GraphToEL.processSegments(eLWrapper, graph, allPathList, true);
            }
        }
        return eLWrapper;
    }

    private static FlowInfo flow(ELWrapper eLWrapper, Graph graph, List<Node> nodes, boolean filterSpecialPath) throws FlowELException {
        List<List<Node>> allPathByNodes;
        if (filterSpecialPath) {
            nodes = nodes.stream().filter(m -> !graph.specialNodes.contains(m)).collect(Collectors.toList());
        }
        if ((allPathByNodes = GraphUtil.findAllPathByNodes(nodes, graph)).size() == 1) {
            List<Node> path = allPathByNodes.get(0);
            block26: for (Node node : path) {
                switch (node.getType()) {
                    case "switch": {
                        BaseELBus.eLWrapperConvert(eLWrapper, GraphToEL.getSwitchELWrapper(graph, node), null);
                        continue block26;
                    }
                    case "if": {
                        BaseELBus.eLWrapperConvert(eLWrapper, GraphToEL.getIfELWrapper(graph, node), null);
                        continue block26;
                    }
                    case "while": {
                        BaseELBus.eLWrapperConvert(eLWrapper, GraphToEL.getWhileELWrapper(graph, node), null);
                        continue block26;
                    }
                    case "for": {
                        BaseELBus.eLWrapperConvert(eLWrapper, GraphToEL.getForELWrapper(graph, node), null);
                        continue block26;
                    }
                    case "iterator": {
                        BaseELBus.eLWrapperConvert(eLWrapper, GraphToEL.getIteratorELWrapper(graph, node), null);
                        continue block26;
                    }
                    case "when": {
                        return FlowInfo.builder().node(node).isBreak(true).isContinue(false).build();
                    }
                    case "then": {
                        return FlowInfo.builder().node(node).isBreak(true).isContinue(false).build();
                    }
                    case "subflow": {
                        continue block26;
                    }
                    case "subvar": {
                        continue block26;
                    }
                    case "router": {
                        return FlowInfo.builder().node(node).isBreak(true).isContinue(false).build();
                    }
                    case "chain": {
                        BaseELBus.eLWrapperConvert(eLWrapper, GraphToEL.getChainELWrapper(graph, node), null);
                        continue block26;
                    }
                }
                BaseELBus.eLWrapperConvert(eLWrapper, node);
            }
        } else if (allPathByNodes.size() > 1) {
            WhenELWrapper whenELWrapper = ELBus.when(new ELWrapper[0]);
            List<List<List<Node>>> grouped = GraphUtil.groupPathsByIntersection(allPathByNodes);
            if (grouped.size() > 1) {
                for (List<List<Node>> itemList : grouped) {
                    ThenELWrapper thenELWrapper1;
                    if (itemList.size() == 1) {
                        List<Node> nodeList = itemList.get(0);
                        if (nodeList.size() == 1) {
                            whenELWrapper.when(GraphToEL.buildNode(graph, itemList.get(0).get(0)));
                            continue;
                        }
                        if (nodeList.size() <= 1) continue;
                        List<Node> startSameNode = GraphUtil.startSameNode(itemList);
                        if (startSameNode.get(0).getType().equals("when")) {
                            GraphToEL.processSegments(whenELWrapper, graph, itemList, filterSpecialPath);
                            continue;
                        }
                        ThenELWrapper thenELWrapper12 = ELBus.then(new ELWrapper[0]);
                        GraphToEL.processSegments(thenELWrapper12, graph, itemList, filterSpecialPath);
                        whenELWrapper.when(thenELWrapper12);
                        continue;
                    }
                    List<Node> startSameNode = GraphUtil.startSameNode(itemList);
                    if (!startSameNode.isEmpty()) {
                        if (startSameNode.get(0).getType().equals("when")) {
                            GraphToEL.processSegments(whenELWrapper, graph, itemList, filterSpecialPath);
                            continue;
                        }
                        thenELWrapper1 = ELBus.then(new ELWrapper[0]);
                        GraphToEL.processSegments(thenELWrapper1, graph, itemList, filterSpecialPath);
                        whenELWrapper.when(thenELWrapper1);
                        continue;
                    }
                    thenELWrapper1 = ELBus.then(new ELWrapper[0]);
                    GraphToEL.flow(thenELWrapper1, graph, GraphUtil.excludeSameNode(itemList, new ArrayList<Node>()), filterSpecialPath);
                    whenELWrapper.when(thenELWrapper1);
                }
                BaseELBus.eLWrapperConvert(eLWrapper, whenELWrapper, null);
            } else {
                List<Node> sameNodeList = GraphUtil.startSameNode(grouped.get(0));
                if (CollUtil.isNotEmpty(sameNodeList)) {
                    GraphToEL.processSegments(eLWrapper, graph, grouped.get(0), filterSpecialPath);
                } else {
                    for (List<Node> itemList : allPathByNodes) {
                        if (itemList.size() == 1) {
                            whenELWrapper.when(GraphToEL.buildNode(graph, itemList.get(0)));
                            continue;
                        }
                        ThenELWrapper thenELWrapper1 = ELBus.then(new ELWrapper[0]);
                        GraphToEL.flow(thenELWrapper1, graph, itemList, filterSpecialPath);
                        whenELWrapper.when(thenELWrapper1);
                    }
                    BaseELBus.eLWrapperConvert(eLWrapper, whenELWrapper, null);
                }
            }
        }
        return null;
    }

    public static ELWrapper getBooleanELWrapper(Graph graph, Node booleanNode) throws FlowELException {
        List<Node> segmentationPoints;
        List<List<Node>> allPaths = graph.findAllPaths(booleanNode, true);
        List<List<Node>> processSegments = GraphUtil.getProcessSegments(allPaths, segmentationPoints = GraphUtil.findSegmentationPoints(allPaths, graph.getNodes()));
        List<List<Node>> segments = GraphUtil.mergeSingleElementSegments(processSegments);
        if (!segments.isEmpty() && segments.get(0).size() == 1) {
            return GraphToEL.buildBooleanELWrapper(graph, segments.get(0).get(0));
        }
        throw new FlowELException("\u53ea\u80fd\u5b58\u5728\u4e00\u6761boolean\u8def\u5f84\uff01");
    }

    public static ELWrapper getBooleanELWrapper(Graph graph, List<Node> booleanNodeList) throws FlowELException {
        List<Node> segmentationPoints;
        List<List<Node>> allPaths = GraphUtil.findAllPathByNodes(booleanNodeList, graph);
        List<List<Node>> processSegments = GraphUtil.getProcessSegments(allPaths, segmentationPoints = GraphUtil.findSegmentationPoints(allPaths, graph.getNodes()));
        List<List<Node>> segments = GraphUtil.mergeSingleElementSegments(processSegments);
        if (!segments.isEmpty() && segments.get(0).size() == 1) {
            return GraphToEL.buildBooleanELWrapper(graph, segments.get(0).get(0));
        }
        throw new FlowELException("\u53ea\u80fd\u5b58\u5728\u4e00\u6761boolean\u8def\u5f84\uff01");
    }

    public static ELWrapper buildBooleanELWrapper(Graph graph, Node node) throws FlowELException {
        switch (node.getType()) {
            case "and": {
                AndELWrapper andELWrapper = ELBusAnd.node();
                List<Node> andList = graph.getNeighbors(node);
                for (Node n : andList) {
                    andELWrapper.and(GraphToEL.buildBooleanELWrapper(graph, n));
                }
                return andELWrapper;
            }
            case "or": {
                OrELWrapper orELWrapper = ELBus.or(new Object[0]);
                List<Node> orList = graph.getNeighbors(node);
                for (Node n : orList) {
                    orELWrapper.or(GraphToEL.buildBooleanELWrapper(graph, n));
                }
                return orELWrapper;
            }
            case "not": {
                List<Node> notList = graph.getNeighbors(node);
                ELWrapper elWrapper = GraphToEL.buildBooleanELWrapper(graph, notList.get(0));
                return ELBusNot.not(elWrapper);
            }
            case "boolean": {
                return ELBusNode.node(node);
            }
        }
        throw new FlowELException("boolean\u8def\u5f84\u4ec5\u652f\u6301\u3010\u4e0e\u3001\u6216\u3001\u975e\u3001\u5e03\u5c14\u7ec4\u4ef6\u3011\uff01");
    }

    public static ELWrapper getWhileELWrapper(Graph graph, Node node) throws FlowELException {
        List<Node> doNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.do_path);
        List<Node> breakNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.break_path);
        List<Node> booleanNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.boolean_path);
        LoopELWrapper elWrapper = null;
        if (!CollUtil.isNotEmpty(booleanNodeList)) {
            throw new FlowELException("\u672a\u8bbe\u7f6eboolean\u8def\u5f84\uff01");
        }
        ELWrapper booleanElWrapper = GraphToEL.getBooleanELWrapper(graph, booleanNodeList);
        elWrapper = ELBusWhile.wrapper(node, booleanElWrapper);
        if (CollUtil.isNotEmpty(doNodeList)) {
            if (doNodeList.size() == 1) {
                if (elWrapper != null) {
                    elWrapper.doOpt(ELBusNode.node(doNodeList.get(0)));
                }
            } else {
                ThenELWrapper doELWrapper = ELBus.then(new ELWrapper[0]);
                GraphToEL.processSegments(doELWrapper, graph, GraphUtil.findAllPathByNodes(doNodeList, graph), false);
                if (elWrapper != null) {
                    elWrapper.doOpt(doELWrapper);
                }
            }
        } else {
            throw new FlowELException("\u672a\u8bbe\u7f6edo\u8def\u5f84\uff01");
        }
        if (CollUtil.isNotEmpty(breakNodeList)) {
            Node breakNode = breakNodeList.get(0);
            if (NodeTypeEnum.BOOLEAN.getCode().equals(breakNode.getType())) {
                if (elWrapper != null) {
                    elWrapper.breakOpt(ELBusNode.node(breakNode));
                }
            } else {
                throw new FlowELException("break\u8def\u5f84\u4ec5\u652f\u6301\u3010\u5e03\u5c14\u7ec4\u4ef6\u3011\uff01");
            }
        }
        return elWrapper;
    }

    public static ELWrapper getIfELWrapper(Graph graph, Node node) throws FlowELException {
        List<Node> trueNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.true_path);
        List<Node> falseNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.false_path);
        List<Node> booleanNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.boolean_path);
        ELWrapper elWrapper = null;
        ELWrapper booleanElWrapper = null;
        if (CollUtil.isNotEmpty(booleanNodeList)) {
            booleanElWrapper = GraphToEL.getBooleanELWrapper(graph, booleanNodeList);
        } else if (StrUtil.isBlank((CharSequence)node.getData().getNodeDataBase().getClazz())) {
            throw new FlowELException("\u672a\u8bbe\u7f6eboolean\u8def\u5f84\u6216\u7ec4\u4ef6\u7c7b\uff01");
        }
        if (CollUtil.isNotEmpty(trueNodeList) && CollUtil.isNotEmpty(falseNodeList)) {
            ELWrapper trueELWrapper = null;
            if (trueNodeList.size() == 1) {
                trueELWrapper = ELBusNode.node(trueNodeList.get(0));
            } else {
                trueELWrapper = ELBus.then(new ELWrapper[0]);
                GraphToEL.processSegments(trueELWrapper, graph, GraphUtil.findAllPathByNodes(trueNodeList, graph), false);
            }
            ELWrapper falseELWrapper = null;
            if (falseNodeList.size() == 1) {
                falseELWrapper = ELBusNode.node(falseNodeList.get(0));
            } else {
                falseELWrapper = ELBus.then(new ELWrapper[0]);
                GraphToEL.processSegments(falseELWrapper, graph, GraphUtil.findAllPathByNodes(falseNodeList, graph), false);
            }
            IfELWrapper ifELWrapper = ELBusIf.node(node, booleanElWrapper, trueELWrapper, falseELWrapper);
            return ifELWrapper;
        }
        if (CollUtil.isNotEmpty(trueNodeList) && CollUtil.isEmpty(falseNodeList)) {
            ELWrapper trueELWrapper = null;
            if (trueNodeList.size() == 1) {
                trueELWrapper = ELBusNode.node(trueNodeList.get(0));
            } else {
                trueELWrapper = ELBus.then(new ELWrapper[0]);
                GraphToEL.processSegments(trueELWrapper, graph, GraphUtil.findAllPathByNodes(trueNodeList, graph), false);
            }
            IfELWrapper ifELWrapper = ELBusIf.node(node, booleanElWrapper, trueELWrapper, null);
            return ifELWrapper;
        }
        if (CollUtil.isEmpty(trueNodeList)) {
            throw new FlowELException("\u672a\u8bbe\u7f6etrue\u8def\u5f84\uff01");
        }
        if (CollUtil.isEmpty(falseNodeList)) {
            throw new FlowELException("\u672a\u8bbe\u7f6efalse\u8def\u5f84\uff01");
        }
        return elWrapper;
    }

    public static ELWrapper getChainELWrapper(Graph graph, Node node) throws FlowELException {
        return ELBusWrapper.chain(node);
    }

    public static ELWrapper getIteratorELWrapper(Graph graph, Node node) throws FlowELException {
        LoopELWrapper elWrapper = ELBusIterator.node(node);
        List<Node> doNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.do_path);
        List<Node> breakNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.break_path);
        if (CollUtil.isNotEmpty(doNodeList)) {
            if (doNodeList.size() == 1) {
                elWrapper.doOpt(ELBusNode.node(doNodeList.get(0)));
            } else {
                ThenELWrapper doELWrapper = ELBus.then(new ELWrapper[0]);
                GraphToEL.processSegments(doELWrapper, graph, GraphUtil.findAllPathByNodes(doNodeList, graph), false);
                elWrapper.doOpt(doELWrapper);
            }
        } else {
            throw new FlowELException("\u672a\u8bbe\u7f6edo\u8def\u5f84\uff01");
        }
        if (CollUtil.isNotEmpty(breakNodeList)) {
            Node breakNode = breakNodeList.get(0);
            if (NodeTypeEnum.BOOLEAN.getCode().equals(breakNode.getType())) {
                elWrapper.breakOpt(ELBusNode.node(breakNode));
            } else {
                throw new FlowELException("break\u8def\u5f84\u4ec5\u652f\u6301\u3010\u5e03\u5c14\u7ec4\u4ef6\u3011\uff01");
            }
        }
        return elWrapper;
    }

    public static ELWrapper getForELWrapper(Graph graph, Node node) throws FlowELException {
        LoopELWrapper elWrapper = ELBusFor.node(node);
        List<Node> doNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.do_path);
        List<Node> breakNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.break_path);
        if (CollUtil.isNotEmpty(doNodeList)) {
            if (doNodeList.size() == 1) {
                elWrapper.doOpt(ELBusNode.node(doNodeList.get(0)));
            } else {
                ThenELWrapper doELWrapper = ELBus.then(new ELWrapper[0]);
                GraphToEL.processSegments(doELWrapper, graph, GraphUtil.findAllPathByNodes(doNodeList, graph), false);
                elWrapper.doOpt(doELWrapper);
            }
        } else {
            throw new FlowELException("\u672a\u8bbe\u7f6edo\u8def\u5f84\uff01");
        }
        if (CollUtil.isNotEmpty(breakNodeList)) {
            Node breakNode = breakNodeList.get(0);
            if (NodeTypeEnum.BOOLEAN.getCode().equals(breakNode.getType())) {
                elWrapper.breakOpt(ELBusNode.node(breakNode));
            } else {
                throw new FlowELException("break\u8def\u5f84\u4ec5\u652f\u6301\u3010\u5e03\u5c14\u7ec4\u4ef6\u3011\uff01");
            }
        }
        return elWrapper;
    }

    public static ELWrapper getSwitchELWrapper(Graph graph, Node node) throws FlowELException {
        SwitchELWrapper elWrapper = ELBusSwitch.node(node);
        List<Edge> toEdgeList = graph.getEdges(node, IvyEnums.PATH_ENUM.to_path);
        for (Edge edge : toEdgeList) {
            ThenELWrapper thenELWrapper;
            Node startNode = graph.getNode(edge.getTarget());
            if (!graph.hasNextNode(startNode)) {
                if (StrUtil.isNotBlank((CharSequence)edge.getData().getId()) || StrUtil.isNotBlank((CharSequence)edge.getData().getTag())) {
                    thenELWrapper = ELBusThen.then(edge);
                    thenELWrapper.then(ELBusNode.node(startNode));
                    elWrapper.to(thenELWrapper);
                    continue;
                }
                elWrapper.to(ELBusNode.node(startNode));
                continue;
            }
            thenELWrapper = ELBusThen.then(edge);
            GraphToEL.processSegments(thenELWrapper, graph, graph.findAllPaths(startNode), false);
            elWrapper.to(thenELWrapper);
        }
        List<Node> defaultNodeList = graph.getSpecialPathNodes(node, IvyEnums.PATH_ENUM.default_path);
        if (CollUtil.isNotEmpty(defaultNodeList)) {
            if (defaultNodeList.size() == 1) {
                elWrapper.defaultOpt(ELBusNode.node(defaultNodeList.get(0)));
            } else {
                ThenELWrapper thenELWrapper = ELBus.then(new ELWrapper[0]);
                GraphToEL.processSegments(thenELWrapper, graph, GraphUtil.findAllPathByNodes(defaultNodeList, graph), false);
                elWrapper.defaultOpt(thenELWrapper);
            }
        }
        return elWrapper;
    }

    private static boolean isCatchProcess(Node node) {
        NodeDataWhen nodeDataWhen;
        NodeDataThen nodeDataThen;
        return node != null && ("then".equalsIgnoreCase(node.getType()) ? (nodeDataThen = node.getData().getNodeDataThen()).getIsCatch() != null && nodeDataThen.getIsCatch() != false : "when".equalsIgnoreCase(node.getType()) && (nodeDataWhen = node.getData().getNodeDataWhen()).getIsCatch() != null && nodeDataWhen.getIsCatch() != false);
    }

    private static CatchELWrapper catchProcess(ELWrapper elWrapper, Node node) {
        CatchELWrapper catchELWrapper = null;
        if (node != null) {
            NodeDataWhen nodeDataWhen;
            if (elWrapper instanceof ThenELWrapper && "then".equalsIgnoreCase(node.getType())) {
                NodeDataThen nodeDataThen = node.getData().getNodeDataThen();
                if (nodeDataThen.getIsCatch() != null && nodeDataThen.getIsCatch().booleanValue()) {
                    catchELWrapper = ELBusCatch.catchException(elWrapper);
                    if (StrUtil.isNotBlank((CharSequence)nodeDataThen.getCatchDo())) {
                        catchELWrapper.doOpt(nodeDataThen.getCatchDo());
                    }
                }
            } else if (elWrapper instanceof WhenELWrapper && "when".equalsIgnoreCase(node.getType()) && (nodeDataWhen = node.getData().getNodeDataWhen()).getIsCatch() != null && nodeDataWhen.getIsCatch().booleanValue()) {
                catchELWrapper = ELBusCatch.catchException(elWrapper);
                if (StrUtil.isNotBlank((CharSequence)nodeDataWhen.getCatchDo())) {
                    catchELWrapper.doOpt(nodeDataWhen.getCatchDo());
                }
            }
        }
        return catchELWrapper;
    }

    private static void thenProcess(ThenELWrapper thenELWrapper, Node thenNode) {
        if (thenNode != null && "then".equalsIgnoreCase(thenNode.getType())) {
            NodeDataThen nodeData = thenNode.getData().getNodeDataThen();
            if (StrUtil.isNotBlank((CharSequence)nodeData.getId())) {
                thenELWrapper.id(nodeData.getId());
            }
            if (StrUtil.isNotBlank((CharSequence)nodeData.getTag())) {
                thenELWrapper.tag(nodeData.getTag());
            }
        }
    }

    private static void whenProcess(WhenELWrapper whenELWrapper, Node whenNode) {
        if (whenNode != null && "when".equalsIgnoreCase(whenNode.getType())) {
            String ignoreType;
            NodeDataWhen nodeDataWhen = whenNode.getData().getNodeDataWhen();
            if (StrUtil.isNotBlank((CharSequence)nodeDataWhen.getId())) {
                whenELWrapper.id(nodeDataWhen.getId());
            }
            if (StrUtil.isNotBlank((CharSequence)nodeDataWhen.getTag())) {
                whenELWrapper.tag(nodeDataWhen.getTag());
            }
            if (nodeDataWhen.getIgnoreError() != null && nodeDataWhen.getIgnoreError().booleanValue()) {
                whenELWrapper.ignoreError(nodeDataWhen.getIgnoreError());
            }
            if (StrUtil.isNotBlank((CharSequence)(ignoreType = nodeDataWhen.getIgnoreType()))) {
                switch (ignoreType) {
                    case "any": {
                        whenELWrapper.any(true);
                        break;
                    }
                    case "must": {
                        if (!StrUtil.isNotBlank((CharSequence)nodeDataWhen.getMustId())) break;
                        whenELWrapper.must(nodeDataWhen.getMustId().split(","));
                    }
                }
            }
            if (StrUtil.isNotBlank((CharSequence)nodeDataWhen.getCustomThreadExecutor())) {
                whenELWrapper.customThreadExecutor(nodeDataWhen.getCustomThreadExecutor());
            }
        }
    }

    public static ELWrapper buildNode(Graph graph, Node node) throws FlowELException {
        String type;
        switch (type = node.getType()) {
            case "common": {
                return ELBusNode.node(node);
            }
            case "switch": {
                return GraphToEL.getSwitchELWrapper(graph, node);
            }
            case "if": {
                return GraphToEL.getIfELWrapper(graph, node);
            }
            case "while": {
                return GraphToEL.getWhileELWrapper(graph, node);
            }
            case "for": {
                return GraphToEL.getForELWrapper(graph, node);
            }
            case "iterator": {
                return GraphToEL.getIteratorELWrapper(graph, node);
            }
            case "chain": {
                return GraphToEL.getChainELWrapper(graph, node);
            }
        }
        return ELBusThen.then();
    }
}

