/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.flow.convert.el;

import com.jxdinfo.hutool.core.collection.CollectionUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.flow.convert.base.AbstractExpressParser;
import com.jxdinfo.idp.flow.convert.bean.CmpProperty;
import com.jxdinfo.idp.flow.convert.bean.Properties;
import com.jxdinfo.idp.flow.convert.enums.ExpressParserEnum;
import com.jxdinfo.liteflow.enums.ConditionTypeEnum;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.CatchCondition;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CatchConditionParser
extends AbstractExpressParser {
    @Override
    public ConditionTypeEnum parserType() {
        return ConditionTypeEnum.TYPE_CATCH;
    }

    @Override
    public ExpressParserEnum getExpressType(Condition condition) {
        return ExpressParserEnum.CATCH;
    }

    @Override
    public CmpProperty builderCondition(Condition condition) {
        CatchCondition catchCondition = (CatchCondition)condition;
        Executable catchItem = catchCondition.getCatchItem();
        CmpProperty vo = null;
        if (catchItem instanceof Condition) {
            vo = this.builderChildVO((Condition)catchItem);
        } else if (catchItem instanceof Node) {
            vo = Optional.of((Node)catchItem).map(this.nodeMapper).orElse(new CmpProperty());
        }
        return vo;
    }

    @Override
    public List<CmpProperty> builderChildren(Condition condition) {
        CatchCondition catchCondition = (CatchCondition)condition;
        Executable catchItem = catchCondition.getDoItem();
        if (Objects.isNull(catchItem)) {
            return Collections.emptyList();
        }
        CmpProperty vo = null;
        if (catchItem instanceof Condition) {
            vo = this.builderChildVO((Condition)catchItem);
        } else if (catchItem instanceof Node) {
            vo = Optional.of((Node)catchItem).map(this.nodeMapper).orElse(new CmpProperty());
        }
        return Collections.singletonList(vo);
    }

    @Override
    public String generateELMethod(CmpProperty jsonEl) {
        if (null == jsonEl.getChildren() || jsonEl.getChildren().isEmpty()) {
            return "CATCH({})";
        }
        return "CATCH({}).DO({})";
    }

    @Override
    public String generateCondition(CmpProperty jsonEl, String elExpress) {
        if (Objects.isNull(jsonEl.getCondition())) {
            return elExpress;
        }
        String catchInternalExpressions = "";
        catchInternalExpressions = this.generateNodeComponent(jsonEl.getCondition(), catchInternalExpressions);
        return StrUtil.replaceFirst((CharSequence)elExpress, (CharSequence)"{}", (CharSequence)catchInternalExpressions);
    }

    @Override
    public String generateCmp(CmpProperty jsonEl, String elExpress) {
        if (CollectionUtil.isEmpty(jsonEl.getChildren())) {
            return elExpress;
        }
        CmpProperty doItem = jsonEl.getChildren().get(0);
        String doExpressions = "";
        doExpressions = this.generateNodeComponent(doItem, doExpressions);
        return StrUtil.format((CharSequence)elExpress, (Object[])new Object[]{doExpressions});
    }

    @Override
    public String generateIdAndTag(CmpProperty jsonEl, String elExpress) {
        Properties properties = jsonEl.getProperties();
        if (Objects.isNull(properties)) {
            return elExpress;
        }
        String expressIdAndTag = "";
        if (StringUtils.isNotEmpty((CharSequence)properties.getId())) {
            expressIdAndTag = StrUtil.format((CharSequence)".id(\"{}\")", (Object[])new Object[]{properties.getId()});
        }
        if (StringUtils.isNotEmpty((CharSequence)properties.getTag())) {
            expressIdAndTag = expressIdAndTag + StrUtil.format((CharSequence)".tag(\"{}\")", (Object[])new Object[]{properties.getTag()});
        }
        return StrUtil.appendIfMissing((CharSequence)elExpress, (CharSequence)expressIdAndTag, (CharSequence[])new CharSequence[0]);
    }
}

