/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.thread;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public interface ExecutorBuilder {
    public ExecutorService buildExecutor();

    default public ExecutorService buildDefaultExecutor(int corePoolSize, int maximumPoolSize, int queueCapacity, final String threadName) {
        return TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueCapacity), new ThreadFactory(){
            private final AtomicLong number = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = Executors.defaultThreadFactory().newThread(r);
                newThread.setName(threadName + this.number.getAndIncrement());
                newThread.setDaemon(false);
                return newThread;
            }
        }, new ThreadPoolExecutor.AbortPolicy()));
    }
}

