/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.script;

import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.enums.ScriptTypeEnum;
import com.jxdinfo.liteflow.script.ScriptExecutor;
import com.jxdinfo.liteflow.script.exception.ScriptSpiException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class ScriptExecutorFactory {
    private static ScriptExecutorFactory scriptExecutorFactory;
    private final Map<String, ScriptExecutor> scriptExecutorMap = new HashMap<String, ScriptExecutor>();
    private final String NONE_LANGUAGE = "none";

    public static ScriptExecutorFactory loadInstance() {
        if (ObjectUtil.isNull(scriptExecutorFactory)) {
            scriptExecutorFactory = new ScriptExecutorFactory();
        }
        return scriptExecutorFactory;
    }

    public ScriptExecutor getScriptExecutor(String language) {
        if (StrUtil.isBlank(language)) {
            language = "none";
        }
        if (!this.scriptExecutorMap.containsKey(language)) {
            ServiceLoader<ScriptExecutor> loader = ServiceLoader.load(ScriptExecutor.class);
            Iterator<ScriptExecutor> it = loader.iterator();
            while (it.hasNext()) {
                ScriptExecutor scriptExecutor = it.next().init();
                if (language.equals("none")) {
                    this.scriptExecutorMap.put(language, scriptExecutor);
                    break;
                }
                ScriptTypeEnum scriptType = ScriptTypeEnum.getEnumByDisplayName(language);
                if (ObjectUtil.isNull((Object)scriptType)) {
                    throw new ScriptSpiException("script language config error");
                }
                if (!scriptType.equals((Object)scriptExecutor.scriptType())) continue;
                this.scriptExecutorMap.put(language, scriptExecutor);
                break;
            }
        }
        if (this.scriptExecutorMap.containsKey(language)) {
            return this.scriptExecutorMap.get(language);
        }
        throw new ScriptSpiException("script spi component failed to load");
    }

    public void cleanScriptCache() {
        this.scriptExecutorMap.forEach((key, value) -> value.cleanCache());
    }
}

