/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.script;

import com.jxdinfo.hutool.core.bean.BeanUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.liteflow.enums.ScriptTypeEnum;
import com.jxdinfo.liteflow.exception.LiteFlowException;
import com.jxdinfo.liteflow.script.ScriptBeanManager;
import com.jxdinfo.liteflow.script.ScriptExecuteWrap;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.slot.Slot;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class ScriptExecutor {
    public ScriptExecutor init() {
        return this;
    }

    public abstract void load(String var1, String var2);

    public abstract void unLoad(String var1);

    public abstract List<String> getNodeIds();

    public Object execute(ScriptExecuteWrap wrap) throws Exception {
        try {
            return this.executeScript(wrap);
        }
        catch (Exception e) {
            if (ObjectUtil.isNotNull(e.getCause()) && e.getCause() instanceof LiteFlowException) {
                throw (LiteFlowException)e.getCause();
            }
            if (ObjectUtil.isNotNull(e.getCause()) && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    public abstract Object executeScript(ScriptExecuteWrap var1) throws Exception;

    public abstract void cleanCache();

    public abstract ScriptTypeEnum scriptType();

    public void bindParam(ScriptExecuteWrap wrap, BiConsumer<String, Object> putConsumer, BiConsumer<String, Object> putIfAbsentConsumer) {
        DataBus.getContextBeanList(wrap.getSlotIndex()).forEach(tuple -> putConsumer.accept((String)tuple.get(0), tuple.get(1)));
        Map<String, Object> metaMap = BeanUtil.beanToMap((Object)wrap, new String[0]);
        Slot slot = DataBus.getSlot(wrap.getSlotIndex());
        metaMap.put("requestData", slot.getRequestData());
        Object subRequestData = slot.getChainReqData(wrap.getCurrChainId());
        if (ObjectUtil.isNotNull(subRequestData)) {
            metaMap.put("subRequestData", subRequestData);
        }
        putConsumer.accept("_meta", metaMap);
        ScriptBeanManager.getScriptBeanMap().forEach(putIfAbsentConsumer);
    }

    public abstract Object compile(String var1) throws Exception;
}

