/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.parallel;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class CompletableFutureExpand {
    public static <T> CompletableFuture<T> completeOnTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit, T timeoutDefaultObj) {
        if (future.isDone()) {
            return future;
        }
        return future.whenComplete((BiConsumer)new Canceller(Delayer.delay(new Timeout<T>(future, timeoutDefaultObj), timeout, unit)));
    }

    static final class Delayer {
        static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

        Delayer() {
        }

        static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
            return delayer.schedule(command, delay, unit);
        }

        static {
            delayer.setRemoveOnCancelPolicy(true);
        }

        static final class DaemonThreadFactory
        implements ThreadFactory {
            DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("CompletableFutureExpandUtilsDelayScheduler");
                return t;
            }
        }
    }

    static final class Canceller
    implements BiConsumer<Object, Throwable> {
        final Future<?> future;

        Canceller(Future<?> future) {
            this.future = future;
        }

        @Override
        public void accept(Object ignore, Throwable ex) {
            if (null == ex && null != this.future && !this.future.isDone()) {
                this.future.cancel(false);
            }
        }
    }

    static final class Timeout<T>
    implements Runnable {
        final CompletableFuture<T> future;
        final T timeoutDefaultObj;

        Timeout(CompletableFuture<T> future, T timeoutDefaultObj) {
            this.future = future;
            this.timeoutDefaultObj = timeoutDefaultObj;
        }

        @Override
        public void run() {
            if (null != this.future && !this.future.isDone()) {
                this.future.complete(this.timeoutDefaultObj);
            }
        }
    }
}

