/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.element.condition;

import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.liteflow.enums.ConditionTypeEnum;
import com.jxdinfo.liteflow.exception.CatchErrorException;
import com.jxdinfo.liteflow.exception.ChainEndException;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.slot.Slot;

public class CatchCondition
extends Condition {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());

    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            Executable catchExecutable = this.getCatchItem();
            if (ObjectUtil.isNull(catchExecutable)) {
                String errorInfo = "no catch item find";
                throw new CatchErrorException(errorInfo);
            }
            catchExecutable.setCurrChainId(this.getCurrChainId());
            catchExecutable.execute(slotIndex);
        }
        catch (ChainEndException e) {
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("catch exception:" + e.getMessage(), e);
            Executable doExecutable = this.getDoItem();
            if (ObjectUtil.isNotNull(doExecutable)) {
                doExecutable.setCurrChainId(this.getCurrChainId());
                doExecutable.execute(slotIndex);
            }
            DataBus.getSlot(slotIndex).removeException();
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_CATCH;
    }

    public Executable getCatchItem() {
        return this.getExecutableOne("CATCH_KEY");
    }

    public void setCatchItem(Executable executable) {
        this.addExecutable("CATCH_KEY", executable);
    }

    public Executable getDoItem() {
        return this.getExecutableOne("DO_KEY");
    }

    public void setDoItem(Executable executable) {
        this.addExecutable("DO_KEY", executable);
    }
}

