/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.element;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.enums.ExecuteableTypeEnum;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.exception.ChainEndException;
import com.jxdinfo.liteflow.exception.FlowSystemException;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Rollbackable;
import com.jxdinfo.liteflow.flow.element.condition.LoopCondition;
import com.jxdinfo.liteflow.flow.executor.NodeExecutor;
import com.jxdinfo.liteflow.flow.executor.NodeExecutorHelper;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.slot.Slot;
import com.jxdinfo.liteflow.util.TupleOf2;
import java.util.Stack;

public class Node
implements Executable,
Cloneable,
Rollbackable {
    private static final LFLog LOG = LFLoggerManager.getLogger(Node.class);
    private String id;
    private String name;
    private String clazz;
    private NodeTypeEnum type;
    private String script;
    private String language;
    @JsonIgnore
    private NodeComponent instance;
    private String tag;
    private String cmpData;
    private String currChainId;
    private TransmittableThreadLocal<Boolean> accessResult = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Stack<TupleOf2<Integer, Integer>>> loopIndexTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Stack<TupleOf2<Integer, Object>>> loopObjectTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Integer> slotIndexTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Boolean> isEndTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Boolean> isContinueOnErrorResult = new TransmittableThreadLocal();

    public Node() {
    }

    public Node(NodeComponent instance) {
        this.id = instance.getNodeId();
        this.name = instance.getName();
        this.instance = instance;
        this.type = instance.getType();
        this.clazz = instance.getClass().getName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public NodeComponent getInstance() {
        return this.instance;
    }

    public void setInstance(NodeComponent instance) {
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        block12: {
            if (ObjectUtil.isNull(this.instance)) {
                throw new FlowSystemException("there is no instance for node id " + this.id);
            }
            try {
                this.setSlotIndex(slotIndex);
                this.instance.setRefNode(this);
                if (this.getAccessResult() || this.instance.isAccess()) {
                    LOG.info("[O]start component[{}] execution", (Object)this.instance.getDisplayName());
                    NodeExecutor nodeExecutor = NodeExecutorHelper.loadInstance().buildNodeExecutor(this.instance.getNodeExecutorClass());
                    nodeExecutor.execute(this.instance);
                } else {
                    LOG.info("[X]skip component[{}] execution", (Object)this.instance.getDisplayName());
                }
                if (this.instance.isEnd()) {
                    String errorInfo = StrUtil.format("[{}] lead the chain to end", this.instance.getDisplayName());
                    throw new ChainEndException(errorInfo);
                }
            }
            catch (ChainEndException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.instance.isEnd()) {
                    String errorInfo = StrUtil.format("[{}] lead the chain to end", this.instance.getDisplayName());
                    throw new ChainEndException(errorInfo);
                }
                if (this.getIsContinueOnErrorResult() || this.instance.isContinueOnError()) {
                    String errorMsg = StrUtil.format("component[{}] cause error,but flow is still go on", this.id);
                    LOG.error(errorMsg);
                    break block12;
                }
                String errorMsg = StrUtil.format("component[{}] cause error,error:{}", this.id, e.getMessage());
                LOG.error(errorMsg);
                throw e;
            }
            finally {
                this.getInstance().removeRefNode();
                this.removeSlotIndex();
                this.removeIsEnd();
                this.removeLoopIndex();
                this.removeAccessResult();
                this.removeIsContinueOnErrorResult();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            this.setSlotIndex(slotIndex);
            this.instance.setRefNode(this);
            this.instance.doRollback();
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format("component[{}] rollback error,error:{}", this.id, e.getMessage());
            LOG.error(errorMsg);
        }
        finally {
            this.removeSlotIndex();
            this.instance.removeRefNode();
        }
    }

    @Override
    public boolean isAccess(Integer slotIndex) throws Exception {
        this.setSlotIndex(slotIndex);
        this.instance.setRefNode(this);
        return this.instance.isAccess();
    }

    @Override
    public ExecuteableTypeEnum getExecuteType() {
        return ExecuteableTypeEnum.NODE;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getCmpData() {
        return this.cmpData;
    }

    public void setCmpData(String cmpData) {
        this.cmpData = cmpData;
    }

    @Override
    public void setCurrChainId(String currentChainId) {
        this.currChainId = currentChainId;
    }

    public String getCurrChainId() {
        return this.currChainId;
    }

    public boolean getAccessResult() {
        Boolean result = (Boolean)this.accessResult.get();
        return result != null && result != false;
    }

    public void setAccessResult(boolean accessResult) {
        this.accessResult.set((Object)accessResult);
    }

    public void removeAccessResult() {
        this.accessResult.remove();
    }

    public boolean getIsContinueOnErrorResult() {
        Boolean result = (Boolean)this.isContinueOnErrorResult.get();
        return result != null && result != false;
    }

    public void setIsContinueOnErrorResult(boolean accessResult) {
        this.isContinueOnErrorResult.set((Object)accessResult);
    }

    public void removeIsContinueOnErrorResult() {
        this.isContinueOnErrorResult.remove();
    }

    public void setLoopIndex(LoopCondition condition, int index) {
        if (this.loopIndexTL.get() == null) {
            Stack<TupleOf2<Integer, Integer>> stack = new Stack<TupleOf2<Integer, Integer>>();
            TupleOf2<Integer, Integer> tuple2 = new TupleOf2<Integer, Integer>(condition.hashCode(), index);
            stack.push(tuple2);
            this.loopIndexTL.set(stack);
        } else {
            Stack stack = (Stack)this.loopIndexTL.get();
            TupleOf2 thisConditionTuple = stack.stream().filter(tuple -> ((Integer)tuple.getA()).equals(condition.hashCode())).findFirst().orElse(null);
            if (thisConditionTuple != null) {
                thisConditionTuple.setB(index);
            } else {
                TupleOf2<Integer, Integer> tuple3 = new TupleOf2<Integer, Integer>(condition.hashCode(), index);
                stack.push(tuple3);
            }
        }
    }

    public Integer getLoopIndex() {
        Stack stack = (Stack)this.loopIndexTL.get();
        if (stack != null) {
            return (Integer)((TupleOf2)stack.peek()).getB();
        }
        return null;
    }

    public Integer getPreLoopIndex() {
        return this.getPreNLoopIndex(1);
    }

    public Integer getPreNLoopIndex(int n) {
        Stack stack = (Stack)this.loopIndexTL.get();
        if (stack != null && stack.size() > n) {
            return (Integer)((TupleOf2)stack.elementAt(stack.size() - (n + 1))).getB();
        }
        return null;
    }

    public void removeLoopIndex() {
        Stack stack = (Stack)this.loopIndexTL.get();
        if (stack != null) {
            if (stack.size() > 1) {
                stack.pop();
            } else {
                this.loopIndexTL.remove();
            }
        }
    }

    public void setCurrLoopObject(LoopCondition condition, Object obj) {
        if (this.loopObjectTL.get() == null) {
            Stack<TupleOf2<Integer, Object>> stack = new Stack<TupleOf2<Integer, Object>>();
            TupleOf2<Integer, Object> tuple2 = new TupleOf2<Integer, Object>(condition.hashCode(), obj);
            stack.push(tuple2);
            this.loopObjectTL.set(stack);
        } else {
            Stack stack = (Stack)this.loopObjectTL.get();
            TupleOf2 thisConditionTuple = stack.stream().filter(tuple -> ((Integer)tuple.getA()).equals(condition.hashCode())).findFirst().orElse(null);
            if (thisConditionTuple != null) {
                thisConditionTuple.setB(obj);
            } else {
                TupleOf2<Integer, Object> tuple3 = new TupleOf2<Integer, Object>(condition.hashCode(), obj);
                stack.push(tuple3);
            }
        }
    }

    public <T> T getCurrLoopObject() {
        Stack stack = (Stack)this.loopObjectTL.get();
        if (stack != null) {
            return (T)((TupleOf2)stack.peek()).getB();
        }
        return null;
    }

    public <T> T getPreLoopObject() {
        return this.getPreNLoopObject(1);
    }

    public <T> T getPreNLoopObject(int n) {
        Stack stack = (Stack)this.loopObjectTL.get();
        if (stack != null && stack.size() > n) {
            return (T)((TupleOf2)stack.elementAt(stack.size() - (n + 1))).getB();
        }
        return null;
    }

    public void removeCurrLoopObject() {
        Stack stack = (Stack)this.loopObjectTL.get();
        if (stack != null) {
            if (stack.size() > 1) {
                stack.pop();
            } else {
                this.loopObjectTL.remove();
            }
        }
    }

    public Integer getSlotIndex() {
        return (Integer)this.slotIndexTL.get();
    }

    public void setSlotIndex(Integer slotIndex) {
        this.slotIndexTL.set((Object)slotIndex);
    }

    public void removeSlotIndex() {
        this.slotIndexTL.remove();
    }

    public Boolean getIsEnd() {
        return (Boolean)this.isEndTL.get();
    }

    public void setIsEnd(Boolean isEnd) {
        this.isEndTL.set((Object)isEnd);
    }

    public void removeIsEnd() {
        this.isEndTL.remove();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public <T> T getItemResultMetaValue(Integer slotIndex) {
        return this.instance.getItemResultMetaValue(slotIndex);
    }

    public Node clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        node.loopIndexTL = new TransmittableThreadLocal();
        node.loopObjectTL = new TransmittableThreadLocal();
        node.accessResult = new TransmittableThreadLocal();
        node.slotIndexTL = new TransmittableThreadLocal();
        node.isEndTL = new TransmittableThreadLocal();
        node.isContinueOnErrorResult = new TransmittableThreadLocal();
        return node;
    }
}

