/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.core.proxy;

import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.annotation.LiteflowMethod;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.core.proxy.DeclComponentProxy;
import com.jxdinfo.liteflow.core.proxy.DeclWarpBean;
import com.jxdinfo.liteflow.exception.ComponentProxyErrorException;
import com.jxdinfo.liteflow.exception.LiteFlowException;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.util.Arrays;

public class LiteFlowProxyUtil {
    private static final LFLog LOG = LFLoggerManager.getLogger(LiteFlowProxyUtil.class);

    public static boolean isDeclareCmp(Class<?> clazz) {
        Class<?> targetClass = LiteFlowProxyUtil.getUserClass(clazz);
        return Arrays.stream(targetClass.getMethods()).anyMatch(method -> method.getAnnotation(LiteflowMethod.class) != null);
    }

    public static NodeComponent proxy2NodeComponent(DeclWarpBean declWarpBean) {
        try {
            DeclComponentProxy proxy = new DeclComponentProxy(declWarpBean);
            return proxy.getProxy();
        }
        catch (LiteFlowException liteFlowException) {
            throw liteFlowException;
        }
        catch (Exception e) {
            String errMsg = StrUtil.format("Error while proxying bean[{}]", declWarpBean.getRawClazz().getName());
            LOG.error(errMsg);
            throw new ComponentProxyErrorException(errMsg);
        }
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && LiteFlowProxyUtil.isCglibProxyClassName(clazz.getName());
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz.getName().contains("$$") && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            return superclass;
        }
        return clazz;
    }

    private static boolean isCglibProxyClassName(String className) {
        return className != null && className.contains("$$");
    }
}

