/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.annotation.util;

import com.jxdinfo.hutool.core.annotation.AnnotationUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.ReflectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.annotation.LFAliasFor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AnnoUtil {
    private static final Map<String, Annotation> ANNO_CACHE_MAP = new ConcurrentHashMap<String, Annotation>();

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        String cacheKey = StrUtil.format("{}-{}", annotatedElement, annotationType.getSimpleName());
        if (ANNO_CACHE_MAP.containsKey(cacheKey)) {
            return (A)ANNO_CACHE_MAP.get(cacheKey);
        }
        Object annotation = AnnotationUtil.getAnnotation(annotatedElement, annotationType);
        if (ObjectUtil.isNull(annotation)) {
            return null;
        }
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        HashMap defaultValueMap = new HashMap();
        Arrays.stream(ReflectUtil.getMethods(annotationType)).forEach(method -> {
            LFAliasFor aliasFor = AnnotationUtil.getAnnotation(method, LFAliasFor.class);
            if (ObjectUtil.isNotNull(aliasFor)) {
                aliasMap.put(method.getName(), aliasFor.value());
                defaultValueMap.put(method.getName(), AnnoUtil.getDefaultValue(annotationType, method.getName()));
            }
        });
        aliasMap.forEach((key, value1) -> {
            Object defaultValue;
            Object value = ReflectUtil.invoke(annotation, key, new Object[0]);
            if (ObjectUtil.notEqual(value, defaultValue = defaultValueMap.get(key))) {
                AnnotationUtil.setValue(annotation, value1, value);
            }
        });
        ANNO_CACHE_MAP.put(cacheKey, (Annotation)annotation);
        return annotation;
    }

    private static <A extends Annotation> Object getDefaultValue(Class<A> annotationType, String property) {
        try {
            return annotationType.getMethod(property, new Class[0]).getDefaultValue();
        }
        catch (Exception e) {
            return null;
        }
    }
}

