/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.io;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.io.IORuntimeException;
import com.jxdinfo.hutool.core.io.IoUtil;
import com.jxdinfo.hutool.core.io.LineHandler;
import com.jxdinfo.hutool.core.io.file.FileNameUtil;
import com.jxdinfo.hutool.core.io.file.FileReader;
import com.jxdinfo.hutool.core.io.file.FileWriter;
import com.jxdinfo.hutool.core.io.file.PathUtil;
import com.jxdinfo.hutool.core.io.resource.ResourceUtil;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.thread.ThreadUtil;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.CharsetUtil;
import com.jxdinfo.hutool.core.util.ClassUtil;
import com.jxdinfo.hutool.core.util.ReUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.hutool.core.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class FileUtil
extends PathUtil {
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    private static final Pattern PATTERN_PATH_ABSOLUTE = Pattern.compile("^[a-zA-Z]:([/\\\\].*)?");

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static boolean isEmpty(File file) {
        if (null == file || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] subFiles = file.list();
            return ArrayUtil.isEmpty(subFiles);
        }
        if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return !FileUtil.isEmpty(file);
    }

    public static File file(String path) {
        if (null == path) {
            return null;
        }
        return new File(FileUtil.getAbsolutePath(path));
    }

    public static File file(String parent, String path) {
        return FileUtil.file(new File(parent), path);
    }

    public static File file(File parent, String path) {
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileUtil.checkSlip(parent, FileUtil.buildFile(parent, path));
    }

    public static File file(String ... names) {
        if (ArrayUtil.isEmpty(names)) {
            return null;
        }
        File file = null;
        for (String name : names) {
            file = file == null ? FileUtil.file(name) : FileUtil.file(file, name);
        }
        return file;
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File file(URL url) {
        return new File(URLUtil.toURI(url));
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static boolean exist(File file) {
        return null != file && file.exists();
    }

    public static long size(File file) {
        return FileUtil.size(file, false);
    }

    public static long size(File file, boolean includeDirSize) {
        if (null == file || !file.exists() || FileUtil.isSymlink(file)) {
            return 0L;
        }
        if (file.isDirectory()) {
            long size = includeDirSize ? file.length() : 0L;
            File[] subFiles = file.listFiles();
            if (ArrayUtil.isEmpty(subFiles)) {
                return 0L;
            }
            for (File subFile : subFiles) {
                size += FileUtil.size(subFile, includeDirSize);
            }
            return size;
        }
        return file.length();
    }

    public static File touch(String path) throws IORuntimeException {
        if (path == null) {
            return null;
        }
        return FileUtil.touch(FileUtil.file(path));
    }

    public static File touch(File file) throws IORuntimeException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileUtil.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new IORuntimeException(e);
            }
        }
        return file;
    }

    public static File mkParentDirs(File file) {
        if (null == file) {
            return null;
        }
        return FileUtil.mkdir(FileUtil.getParent(file, 1));
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            FileUtil.mkdirsSafely(dir, 5, 1L);
        }
        return dir;
    }

    public static boolean mkdirsSafely(File dir, int tryCount, long sleepMillis) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        for (int i = 1; i <= tryCount; ++i) {
            dir.mkdirs();
            if (dir.exists()) {
                return true;
            }
            ThreadUtil.sleep(sleepMillis);
        }
        return dir.exists();
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String normalPath;
        if (path == null) {
            normalPath = "";
        } else {
            normalPath = FileUtil.normalize(path);
            if (FileUtil.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = ResourceUtil.getResource(normalPath, baseClass);
        if (null != url) {
            return FileUtil.normalize(URLUtil.getDecodedPath(url));
        }
        String classPath = ClassUtil.getClassPath();
        if (null == classPath) {
            return path;
        }
        return FileUtil.normalize(classPath.concat(Objects.requireNonNull(path)));
    }

    public static String getAbsolutePath(String path) {
        return FileUtil.getAbsolutePath(path, null);
    }

    public static boolean isAbsolutePath(String path) {
        if (StrUtil.isEmpty(path)) {
            return false;
        }
        return '/' == path.charAt(0) || ReUtil.isMatch(PATTERN_PATH_ABSOLUTE, (CharSequence)path);
    }

    public static boolean isFile(String path) {
        return null != path && FileUtil.file(path).isFile();
    }

    @Deprecated
    public static boolean isModifed(File file, long lastModifyTime) {
        return FileUtil.isModified(file, lastModifyTime);
    }

    public static boolean isModified(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("\\\\")) {
            return path;
        }
        String pathToUse = StrUtil.removePrefixIgnoreCase(path, "classpath:");
        if (StrUtil.startWith((CharSequence)(pathToUse = StrUtil.removePrefixIgnoreCase(pathToUse, "file:")), '~')) {
            pathToUse = FileUtil.getUserHomePath() + pathToUse.substring(1);
        }
        pathToUse = pathToUse.replaceAll("[/\\\\]+", "/");
        pathToUse = StrUtil.trimStart(pathToUse);
        String prefix = "";
        int prefixIndex = pathToUse.indexOf(":");
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (StrUtil.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = StrUtil.split((CharSequence)pathToUse, '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && StrUtil.isEmpty(prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return prefix + CollUtil.join(pathElements, "/");
    }

    public static String getName(String filePath) {
        return FileNameUtil.getName(filePath);
    }

    public static String extName(String fileName) {
        return FileNameUtil.extName(fileName);
    }

    public static BufferedInputStream getInputStream(File file) throws IORuntimeException {
        return IoUtil.toBuffered(IoUtil.toStream(file));
    }

    @Deprecated
    public static BufferedReader getReader(File file, String charsetName) throws IORuntimeException {
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file), CharsetUtil.charset(charsetName));
    }

    public static BufferedReader getReader(File file, Charset charset) throws IORuntimeException {
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file), charset);
    }

    @Deprecated
    public static BufferedReader getReader(String path, String charsetName) throws IORuntimeException {
        return FileUtil.getReader(path, CharsetUtil.charset(charsetName));
    }

    public static BufferedReader getReader(String path, Charset charset) throws IORuntimeException {
        return FileUtil.getReader(FileUtil.file(path), charset);
    }

    public static byte[] readBytes(File file) throws IORuntimeException {
        return FileReader.create(file).readBytes();
    }

    @Deprecated
    public static String readString(File file, String charsetName) throws IORuntimeException {
        return FileUtil.readString(file, CharsetUtil.charset(charsetName));
    }

    public static String readString(File file, Charset charset) throws IORuntimeException {
        return FileReader.create(file, charset).readString();
    }

    @Deprecated
    public static String readString(String path, String charsetName) throws IORuntimeException {
        return FileUtil.readString(path, CharsetUtil.charset(charsetName));
    }

    public static String readString(String path, Charset charset) throws IORuntimeException {
        return FileUtil.readString(FileUtil.file(path), charset);
    }

    @Deprecated
    public static String readString(URL url, String charsetName) throws IORuntimeException {
        return FileUtil.readString(url, CharsetUtil.charset(charsetName));
    }

    public static String readString(URL url, Charset charset) throws IORuntimeException {
        if (url == null) {
            throw new NullPointerException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IoUtil.read(in, charset);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static <T extends Collection<String>> T readLines(String path, Charset charset, T collection) throws IORuntimeException {
        return FileUtil.readLines(FileUtil.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readLines(File file, Charset charset, T collection) throws IORuntimeException {
        return FileReader.create(file, charset).readLines(collection);
    }

    @Deprecated
    public static <T extends Collection<String>> T readLines(URL url, String charsetName, T collection) throws IORuntimeException {
        return FileUtil.readLines(url, CharsetUtil.charset(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, Charset charset, T collection) throws IORuntimeException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoUtil.readLines(in, charset, collection);
            return t;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }

    @Deprecated
    public static List<String> readLines(URL url, String charsetName) throws IORuntimeException {
        return FileUtil.readLines(url, CharsetUtil.charset(charsetName));
    }

    public static List<String> readLines(URL url, Charset charset) throws IORuntimeException {
        return FileUtil.readLines(url, charset, new ArrayList());
    }

    public static List<String> readLines(String path, Charset charset) throws IORuntimeException {
        return FileUtil.readLines(path, charset, new ArrayList());
    }

    public static List<String> readLines(File file, Charset charset) throws IORuntimeException {
        return FileUtil.readLines(file, charset, new ArrayList());
    }

    public static List<String> readLines(File file, Charset charset, Predicate<String> filter) throws IORuntimeException {
        ArrayList<String> result = new ArrayList<String>();
        FileUtil.readLines(file, charset, (String line) -> {
            if (filter.test(line)) {
                result.add(line);
            }
        });
        return result;
    }

    public static void readLines(File file, Charset charset, LineHandler lineHandler) throws IORuntimeException {
        FileReader.create(file, charset).readLines(lineHandler);
    }

    public static <T> T load(String path, String charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        return FileReader.create(FileUtil.file(path), CharsetUtil.charset(charset)).read(readerHandler);
    }

    public static <T> T load(String path, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        return FileReader.create(FileUtil.file(path), charset).read(readerHandler);
    }

    public static <T> T load(File file, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        return FileReader.create(file, charset).read(readerHandler);
    }

    @Deprecated
    public static BufferedWriter getWriter(String path, String charsetName, boolean isAppend) throws IORuntimeException {
        return FileUtil.getWriter(path, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(String path, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileUtil.getWriter(FileUtil.touch(path), charset, isAppend);
    }

    @Deprecated
    public static BufferedWriter getWriter(File file, String charsetName, boolean isAppend) throws IORuntimeException {
        return FileUtil.getWriter(file, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file, charset).getWriter(isAppend);
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static File writeString(String content, File file, Charset charset) throws IORuntimeException {
        return FileWriter.create(file, charset).write(content);
    }

    public static String getParent(String filePath, int level) {
        File parent = FileUtil.getParent(FileUtil.file(filePath), level);
        try {
            return null == parent ? null : parent.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileUtil.getParent(parentFile, level - 1);
    }

    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        if (null != parentFile && null != file && !FileUtil.isSub(parentFile, file)) {
            throw new IllegalArgumentException("New file is outside of the parent dir: " + file.getName());
        }
        return file;
    }

    public static boolean isSymlink(File file) {
        return FileUtil.isSymlink(file.toPath());
    }

    public static boolean isSub(File parent, File sub) {
        Assert.notNull(parent);
        Assert.notNull(sub);
        return FileUtil.isSub(parent.toPath(), sub.toPath());
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!FileUtil.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List<String> pathParts = StrUtil.split((CharSequence)fileName, '/', false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return new File(outFile, fileName);
    }
}

