/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.date;

import com.jxdinfo.hutool.core.comparator.CompareUtil;
import com.jxdinfo.hutool.core.date.BetweenFormatter;
import com.jxdinfo.hutool.core.date.CalendarUtil;
import com.jxdinfo.hutool.core.date.DateBetween;
import com.jxdinfo.hutool.core.date.DateException;
import com.jxdinfo.hutool.core.date.DateField;
import com.jxdinfo.hutool.core.date.DatePattern;
import com.jxdinfo.hutool.core.date.DateRange;
import com.jxdinfo.hutool.core.date.DateTime;
import com.jxdinfo.hutool.core.date.DateUnit;
import com.jxdinfo.hutool.core.date.LocalDateTimeUtil;
import com.jxdinfo.hutool.core.date.TemporalAccessorUtil;
import com.jxdinfo.hutool.core.date.format.DateParser;
import com.jxdinfo.hutool.core.date.format.DatePrinter;
import com.jxdinfo.hutool.core.date.format.GlobalCustomFormat;
import com.jxdinfo.hutool.core.lang.PatternPool;
import com.jxdinfo.hutool.core.util.NumberUtil;
import com.jxdinfo.hutool.core.util.ReUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtil
extends CalendarUtil {
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateUtil.dateNew(date);
    }

    public static DateTime dateNew(Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        return new DateTime(temporalAccessor);
    }

    public static long current() {
        return System.currentTimeMillis();
    }

    public static String now() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static String today() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static String format(LocalDateTime localDateTime, String format) {
        return LocalDateTimeUtil.format(localDateTime, format);
    }

    public static String format(Date date, String format) {
        if (null == date || StrUtil.isBlank(format)) {
            return null;
        }
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return GlobalCustomFormat.format(date, (CharSequence)format);
        }
        TimeZone timeZone = null;
        if (date instanceof DateTime) {
            timeZone = ((DateTime)date).getTimeZone();
        }
        return DateUtil.format(date, DateUtil.newSimpleFormat(format, null, timeZone));
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return TemporalAccessorUtil.format((TemporalAccessor)date.toInstant(), format);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATE_FORMAT.format(date);
    }

    public static DateTime parse(CharSequence dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(CharSequence dateStr, DateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, DateParser parser, boolean lenient) {
        return new DateTime(dateStr, parser, lenient);
    }

    public static DateTime parse(CharSequence dateStr, DateTimeFormatter formatter) {
        return new DateTime(dateStr, formatter);
    }

    public static DateTime parse(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(CharSequence dateStr, String format, Locale locale) {
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return new DateTime(GlobalCustomFormat.parse(dateStr, format));
        }
        return new DateTime(dateStr, DateUtil.newSimpleFormat(format, locale, null));
    }

    public static DateTime parse(String str, String ... parsePatterns) throws DateException {
        return new DateTime(CalendarUtil.parseByPatterns(str, parsePatterns));
    }

    public static DateTime parseTimeToday(CharSequence timeString) {
        timeString = StrUtil.format("{} {}", DateUtil.today(), timeString);
        if (1 == StrUtil.count(timeString, ':')) {
            return DateUtil.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return DateUtil.parse(timeString, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String utcString) {
        if (utcString == null) {
            return null;
        }
        int length = utcString.length();
        if (StrUtil.contains((CharSequence)utcString, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength && length >= patternLength - 6) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (StrUtil.contains((CharSequence)utcString, '+')) {
                String zoneOffset = StrUtil.subAfter((CharSequence)(utcString = utcString.replace(" +", "+")), '+', true);
                if (StrUtil.isBlank(zoneOffset)) {
                    throw new DateException("Invalid format: [{}]", utcString);
                }
                if (!StrUtil.contains((CharSequence)zoneOffset, ':')) {
                    String pre = StrUtil.subBefore((CharSequence)utcString, '+', true);
                    utcString = pre + "+" + zoneOffset.substring(0, 2) + ":00";
                }
                if (StrUtil.contains((CharSequence)utcString, '.')) {
                    utcString = DateUtil.normalizeMillSeconds(utcString, ".", "+");
                    return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_WITH_XXX_OFFSET_FORMAT);
            }
            if (ReUtil.contains("-\\d{2}:?00", (CharSequence)utcString)) {
                if (':' != (utcString = utcString.replace(" -", "-")).charAt(utcString.length() - 3)) {
                    utcString = utcString.substring(0, utcString.length() - 2) + ":00";
                }
                if (StrUtil.contains((CharSequence)utcString, '.')) {
                    utcString = DateUtil.normalizeMillSeconds(utcString, ".", "-");
                    return new DateTime((CharSequence)utcString, DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)utcString, DatePattern.UTC_WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_SIMPLE_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 5) {
                return DateUtil.parse((CharSequence)(utcString + ":00"), DatePattern.UTC_SIMPLE_FORMAT);
            }
            if (StrUtil.contains((CharSequence)utcString, '.')) {
                utcString = DateUtil.normalizeMillSeconds(utcString, ".", null);
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_SIMPLE_MS_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", utcString);
    }

    public static DateTime parseCST(CharSequence cstString) {
        if (cstString == null) {
            return null;
        }
        return DateUtil.parse(cstString, DatePattern.JDK_DATETIME_FORMAT);
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (StrUtil.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = StrUtil.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (NumberUtil.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return DateUtil.parse((CharSequence)dateStr, DatePattern.PURE_TIME_FORMAT);
            }
            if (length == 13) {
                return DateUtil.date(NumberUtil.parseLong(dateStr));
            }
        } else {
            if (ReUtil.isMatch(PatternPool.TIME, (CharSequence)dateStr)) {
                return DateUtil.parseTimeToday(dateStr);
            }
            if (StrUtil.containsAnyIgnoreCase(dateStr, wtb)) {
                return DateUtil.parseCST(dateStr);
            }
            if (StrUtil.contains((CharSequence)dateStr, 'T')) {
                return DateUtil.parseUTC(dateStr);
            }
        }
        if (ReUtil.isMatch(DatePattern.REGEX_NORM, (CharSequence)(dateStr = DateUtil.normalize(dateStr)))) {
            int colonCount = StrUtil.count((CharSequence)dateStr, ':');
            switch (colonCount) {
                case 0: {
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATE_FORMAT);
                }
                case 1: {
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    int indexOfDot = StrUtil.indexOf(dateStr, '.');
                    if (indexOfDot > 0) {
                        int length1 = dateStr.length();
                        if (length1 - indexOfDot > 4) {
                            dateStr = StrUtil.subPre(dateStr, indexOfDot + 4);
                        }
                        return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_MS_FORMAT);
                    }
                    return DateUtil.parse((CharSequence)dateStr, DatePattern.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw new DateException("No format fit for date String [{}] !", dateStr);
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date)));
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        return DateUtil.dateNew(date).offset(dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return DateUtil.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.MS);
    }

    public static String formatBetween(long betweenMs, BetweenFormatter.Level level) {
        return new BetweenFormatter(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return new BetweenFormatter(betweenMs, BetweenFormatter.Level.MILLISECOND).format();
    }

    @Deprecated
    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtil.format(date, "yyMMddHHmm"));
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    @Deprecated
    public static boolean isExpired(Date startDate, DateField dateField, int timeLength, Date endDate) {
        DateTime offsetDate = DateUtil.offset(startDate, dateField, timeLength);
        return offsetDate.after(endDate);
    }

    @Deprecated
    public static boolean isExpired(Date startDate, Date endDate, Date checkDate) {
        return DateUtil.betweenMs(startDate, checkDate) > DateUtil.betweenMs(startDate, endDate);
    }

    public static DateRange range(Date start, Date end, DateField unit) {
        return new DateRange(start, end, unit);
    }

    public static int compare(Date date1, Date date2) {
        return CompareUtil.compare(date1, date2);
    }

    public static int compare(Date date1, Date date2, String format) {
        if (format != null) {
            if (date1 != null) {
                date1 = DateUtil.parse((CharSequence)DateUtil.format(date1, format), format);
            }
            if (date2 != null) {
                date2 = DateUtil.parse((CharSequence)DateUtil.format(date2, format), format);
            }
        }
        return CompareUtil.compare(date1, date2);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toInstant(temporalAccessor);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return DateUtil.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    public static String getShotName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
        }
        return unit.name().toLowerCase();
    }

    private static String normalize(CharSequence dateStr) {
        if (StrUtil.isBlank(dateStr)) {
            return StrUtil.str(dateStr);
        }
        List<String> dateAndTime = StrUtil.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StrUtil.str(dateStr);
        }
        StringBuilder builder = StrUtil.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StrUtil.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StrUtil.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }

    private static String normalizeMillSeconds(String dateStr, CharSequence before, CharSequence after) {
        if (StrUtil.isBlank(after)) {
            String millOrNaco = StrUtil.subPre(StrUtil.subAfter((CharSequence)dateStr, before, true), 3);
            return StrUtil.subBefore((CharSequence)dateStr, before, true) + before + millOrNaco;
        }
        String millOrNaco = StrUtil.subPre(StrUtil.subBetween(dateStr, before, after), 3);
        return StrUtil.subBefore((CharSequence)dateStr, before, true) + before + millOrNaco + after + StrUtil.subAfter((CharSequence)dateStr, after, true);
    }
}

